/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import reactor.core.publisher.Mono;

public class ResponseValidationPolicyBuilder {
    private final List<TriConsumer<HttpResponse, ClientLogger, Context>> assertions = new ArrayList<TriConsumer<HttpResponse, ClientLogger, Context>>();

    public HttpPipelinePolicy build() {
        return new ResponseValidationPolicy(this.assertions);
    }

    @Deprecated
    public ResponseValidationPolicyBuilder addOptionalEcho(String headerName) {
        this.assertions.add((httpResponse, logger, context) -> {
            HttpHeaderName httpHeaderName = HttpHeaderName.fromString(headerName);
            String requestHeaderValue = httpResponse.getRequest().getHeaders().getValue(httpHeaderName);
            String responseHeaderValue = httpResponse.getHeaders().getValue(httpHeaderName);
            List<HttpHeaderName> headersToSkip = this.getHeadersToSkip((Context)context);
            if (responseHeaderValue != null && !responseHeaderValue.equals(requestHeaderValue) && !headersToSkip.contains(httpHeaderName)) {
                throw logger.logExceptionAsError(new RuntimeException(String.format("Unexpected header value. Expected response to echo `%s: %s`. Got value `%s`.", headerName, requestHeaderValue, responseHeaderValue)));
            }
        });
        return this;
    }

    public ResponseValidationPolicyBuilder addOptionalEcho(HttpHeaderName headerName) {
        this.assertions.add((httpResponse, logger, context) -> {
            String requestHeaderValue = httpResponse.getRequest().getHeaders().getValue(headerName);
            String responseHeaderValue = httpResponse.getHeaders().getValue(headerName);
            List<HttpHeaderName> headersToSkip = this.getHeadersToSkip((Context)context);
            if (responseHeaderValue != null && !responseHeaderValue.equals(requestHeaderValue) && !headersToSkip.contains(headerName)) {
                throw logger.logExceptionAsError(new RuntimeException(String.format("Unexpected header value. Expected response to echo `%s: %s`. Got value `%s`.", headerName, requestHeaderValue, responseHeaderValue)));
            }
        });
        return this;
    }

    private List<HttpHeaderName> getHeadersToSkip(Context context) {
        List<HttpHeaderName> headersToSkip = new ArrayList<HttpHeaderName>();
        Optional<Object> contextAdjustment = context.getData("skipEchoValidation");
        if (contextAdjustment.isPresent()) {
            headersToSkip = (List)contextAdjustment.get();
        }
        return headersToSkip;
    }

    public static class ResponseValidationPolicy
    implements HttpPipelinePolicy {
        private static final ClientLogger LOGGER = new ClientLogger(ResponseValidationPolicy.class);
        private final List<TriConsumer<HttpResponse, ClientLogger, Context>> assertions;

        ResponseValidationPolicy(List<TriConsumer<HttpResponse, ClientLogger, Context>> assertions) {
            this.assertions = new ArrayList<TriConsumer<HttpResponse, ClientLogger, Context>>(assertions);
        }

        @Override
        public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
            return next.process().map(response -> {
                this.assertions.forEach(assertion -> assertion.accept(response, LOGGER, context.getContext()));
                return response;
            });
        }

        @Override
        public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
            HttpResponse response = next.processSync();
            this.assertions.forEach(assertion -> assertion.accept(response, LOGGER, context.getContext()));
            return response;
        }
    }

    @FunctionalInterface
    private static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

