/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.TypeUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

final class AdditionalPropertiesSerializer
extends StdSerializer<Object>
implements ResolvableSerializer {
    private static final long serialVersionUID = -3458779491516161716L;
    private final JsonSerializer<?> defaultSerializer;
    private final ObjectMapper mapper;

    protected AdditionalPropertiesSerializer(Class<?> vc, JsonSerializer<?> defaultSerializer, ObjectMapper mapper) {
        super(vc, false);
        this.defaultSerializer = defaultSerializer;
        this.mapper = mapper;
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setSerializerModifier(new BeanSerializerModifier(){

            @Override
            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                for (Class<Object> clazz : TypeUtil.getAllClasses(beanDesc.getBeanClass())) {
                    Field[] fields;
                    if (clazz.isAssignableFrom(Object.class)) continue;
                    for (Field field : fields = clazz.getDeclaredFields()) {
                        JsonProperty property;
                        if (!"additionalProperties".equalsIgnoreCase(field.getName()) || (property = field.getAnnotation(JsonProperty.class)) == null || !property.value().isEmpty()) continue;
                        return new AdditionalPropertiesSerializer(beanDesc.getBeanClass(), serializer, mapper);
                    }
                }
                return serializer;
            }
        });
        return module;
    }

    @Override
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        ObjectNode root = (ObjectNode)this.mapper.valueToTree(value);
        ObjectNode res = root.deepCopy();
        LinkedBlockingQueue<ObjectNode> source = new LinkedBlockingQueue<ObjectNode>();
        LinkedBlockingQueue<ObjectNode> target = new LinkedBlockingQueue<ObjectNode>();
        source.add(root);
        target.add(res);
        while (!source.isEmpty()) {
            ObjectNode current = (ObjectNode)source.poll();
            ObjectNode resCurrent = (ObjectNode)target.poll();
            Iterator<Map.Entry<String, JsonNode>> fields = current.fields();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> field = fields.next();
                String key = field.getKey();
                JsonNode outNode = resCurrent.get(key);
                if ("additionalProperties".equals(key)) {
                    resCurrent.remove(key);
                    ObjectNode extraProperties = (ObjectNode)outNode;
                    Iterator<Map.Entry<String, JsonNode>> additionalFields = extraProperties.fields();
                    while (additionalFields.hasNext()) {
                        Map.Entry<String, JsonNode> additionalField = additionalFields.next();
                        resCurrent.set(additionalField.getKey(), additionalField.getValue());
                    }
                }
                if (field.getValue() instanceof ObjectNode) {
                    source.add((ObjectNode)field.getValue());
                    target.add((ObjectNode)outNode);
                    continue;
                }
                if (!(field.getValue() instanceof ArrayNode) || field.getValue().size() <= 0 || !(field.getValue().get(0) instanceof ObjectNode)) continue;
                Iterator<JsonNode> sourceIt = field.getValue().elements();
                Iterator<JsonNode> targetIt = outNode.elements();
                while (sourceIt.hasNext()) {
                    source.add((ObjectNode)sourceIt.next());
                    target.add((ObjectNode)targetIt.next());
                }
            }
        }
        jgen.writeTree(res);
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        ((ResolvableSerializer)((Object)this.defaultSerializer)).resolve(provider);
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSerializer) throws IOException {
        this.serialize(value, gen, provider);
    }
}

