/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.core.util.logging.LoggingEventBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.util.Version;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import reactor.netty.Connection;
import reactor.netty.channel.ChannelOperations;

public final class NettyUtility {
    private static final ClientLogger LOGGER = new ClientLogger(NettyUtility.class);
    static final String PROPERTIES_FILE_NAME = "azure-core-http-netty.properties";
    static final String NETTY_VERSION_PROPERTY = "netty-version";
    static final String NETTY_TCNATIVE_VERSION_PROPERTY = "netty-tcnative-version";
    private static final List<String> REQUIRED_NETTY_VERSION_ARTIFACTS = Arrays.asList("netty-common", "netty-handler", "netty-handler-proxy", "netty-buffer", "netty-codec", "netty-codec-http", "netty-codec-http2");
    private static final List<String> OPTIONAL_NETTY_VERSION_ARTIFACTS = Arrays.asList("netty-transport-native-unix-common", "netty-transport-native-epoll", "netty-transport-native-kqueue");
    private static final String NETTY_TCNATIVE_VERSION_ARTIFACT = "netty-tcnative-boringssl-static";

    public static ByteBuffer deepCopyBuffer(ByteBuf byteBuf) {
        byte[] bytes = new byte[byteBuf.readableBytes()];
        byteBuf.getBytes(byteBuf.readerIndex(), bytes);
        return ByteBuffer.wrap(bytes);
    }

    public static void closeConnection(Connection reactorNettyConnection) {
        if (reactorNettyConnection instanceof ChannelOperations) {
            ChannelOperations channelOperations = (ChannelOperations)reactorNettyConnection;
            if (!channelOperations.isInboundDisposed()) {
                channelOperations.channel().eventLoop().execute(channelOperations::discard);
            }
        } else if (!reactorNettyConnection.isDisposed()) {
            reactorNettyConnection.channel().eventLoop().execute(reactorNettyConnection::dispose);
        }
    }

    public static void validateNettyVersions() {
        if (!LOGGER.canLogAtLevel(LogLevel.INFORMATIONAL)) {
            return;
        }
        try {
            NettyUtility.validateNettyVersionsInternal();
        }
        catch (Exception ex) {
            LOGGER.info("Unable to load Netty version information. If Netty version validation is required, please review this exception. Otherwise, this log message can be ignored.", ex);
        }
    }

    static void validateNettyVersionsInternal() {
        Map<String, String> pomVersions = CoreUtils.getProperties(PROPERTIES_FILE_NAME);
        NettyVersionLogInformation versionLogInformation = NettyUtility.createNettyVersionLogInformation(pomVersions.get(NETTY_VERSION_PROPERTY), pomVersions.get(NETTY_TCNATIVE_VERSION_PROPERTY));
        if (versionLogInformation.shouldLog()) {
            versionLogInformation.log();
        }
    }

    static NettyVersionLogInformation createNettyVersionLogInformation(String azureNettyVersion, String azureNativeNettyVersion) {
        Version version;
        LinkedHashMap<String, String> classpathNettyVersions = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> classPathNativeNettyVersions = new LinkedHashMap<String, String>();
        Map<String, Version> nettyVersions = Version.identify(NettyUtility.class.getClassLoader());
        for (String artifact : REQUIRED_NETTY_VERSION_ARTIFACTS) {
            version = nettyVersions.get(artifact);
            if (version == null) {
                classpathNettyVersions.put("io.netty:" + artifact, "unknown (not found and is required)");
                continue;
            }
            classpathNettyVersions.put("io.netty:" + version.artifactId(), version.artifactVersion());
        }
        for (String artifact : OPTIONAL_NETTY_VERSION_ARTIFACTS) {
            version = nettyVersions.get(artifact);
            if (version == null) continue;
            classpathNettyVersions.put("io.netty:" + version.artifactId(), version.artifactVersion());
        }
        try {
            Enumeration<URL> enumeration = NettyUtility.class.getClassLoader().getResources("META-INF/maven/io.netty/netty-tcnative-boringssl-static/pom.properties");
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                Properties properties = new Properties();
                properties.load(url.openStream());
                String version2 = properties.getProperty("version");
                String groupId = properties.getProperty("groupId");
                String artifactId = properties.getProperty("artifactId");
                if (!"io.netty".equals(groupId) || !NETTY_TCNATIVE_VERSION_ARTIFACT.equals(artifactId)) continue;
                classPathNativeNettyVersions.put("io.netty:netty-tcnative-boringssl-static", version2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new NettyVersionLogInformation(azureNettyVersion, azureNativeNettyVersion, classpathNettyVersions, classPathNativeNettyVersions);
    }

    private NettyUtility() {
    }

    static final class NettyVersionLogInformation {
        private final String azureNettyVersion;
        private final String azureNativeNettyVersion;
        final Map<String, String> classpathNettyVersions;
        final Map<String, String> classPathNativeNettyVersions;

        NettyVersionLogInformation(String azureNettyVersion, String azureNativeNettyVersion, Map<String, String> classpathNettyVersions, Map<String, String> classPathNativeNettyVersions) {
            this.azureNettyVersion = azureNettyVersion;
            this.azureNativeNettyVersion = azureNativeNettyVersion;
            this.classpathNettyVersions = classpathNettyVersions;
            this.classPathNativeNettyVersions = classPathNativeNettyVersions;
        }

        boolean shouldLog() {
            boolean hasNettyVersionMismatch = this.classpathNettyVersions.values().stream().anyMatch(version -> !Objects.equals(version, this.azureNettyVersion));
            boolean hasNativeNettyVersionMismatch = this.classPathNativeNettyVersions.values().stream().anyMatch(version -> !Objects.equals(version, this.azureNativeNettyVersion));
            return hasNettyVersionMismatch || hasNativeNettyVersionMismatch;
        }

        private void log() {
            LoggingEventBuilder loggingEventBuilder = LOGGER.atInfo();
            loggingEventBuilder.addKeyValue("azure-netty-version", this.azureNettyVersion).addKeyValue("azure-netty-native-version", this.azureNativeNettyVersion);
            for (Map.Entry<String, String> entry : this.classpathNettyVersions.entrySet()) {
                loggingEventBuilder.addKeyValue("classpath-netty-version-" + entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this.classPathNativeNettyVersions.entrySet()) {
                loggingEventBuilder.addKeyValue("classpath-native-netty-version-" + entry.getKey(), entry.getValue());
            }
            loggingEventBuilder.log("The following Netty versions were found on the classpath and have a mismatch with the versions used by azure-core-http-netty. If your application runs without issue this message can be ignored, otherwise please align the Netty versions used in your application. For more information, see https://aka.ms/azsdk/java/dependency/troubleshoot.");
        }
    }
}

