/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geopkg;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.sqlite3.SQLite3TableReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class GeoPkgTableReader
extends SQLite3TableReader {
    private final Set<String> ignoreBlobColumns;

    public GeoPkgTableReader(Connection connection, String tableName, EmbeddedDocumentUtil embeddedDocumentUtil, Set<String> ignoreBlobColumns) {
        super(connection, tableName, embeddedDocumentUtil);
        this.ignoreBlobColumns = ignoreBlobColumns;
    }

    protected void handleBlob(String tableName, String columnName, int rowNum, ResultSet resultSet, int columnIndex, ContentHandler handler, ParseContext context) throws SQLException, IOException, SAXException {
        if (this.ignoreBlobColumns.contains(columnName)) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "type", "type", "CDATA", "blob");
            attrs.addAttribute("", "column_name", "column_name", "CDATA", columnName);
            attrs.addAttribute("", "row_number", "row_number", "CDATA", Integer.toString(rowNum));
            handler.startElement("", "span", "span", attrs);
            handler.endElement("", "span", "span");
            return;
        }
        super.handleBlob(tableName, columnName, rowNum, resultSet, columnIndex, handler, context);
    }
}

