/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Collector;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.coverage.grid.j2d.TileOpExecutor;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.image.ImageAdapter;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;

abstract class AnnotatedImage
extends ImageAdapter {
    public static final String WARNINGS_SUFFIX = ".warnings";
    private static final Object NULL = Void.TYPE;
    private static final WeakHashMap<RenderedImage, Cache<Object, Object>> CACHE = new WeakHashMap();
    private final Cache<Object, Object> cache;
    protected final Shape areaOfInterest;
    protected final Rectangle boundsOfInterest;
    private volatile ErrorHandler.Report errors;
    private final boolean parallel;
    private final boolean failOnException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnnotatedImage(RenderedImage source, Shape areaOfInterest, boolean parallel, boolean failOnException) {
        super(source);
        Rectangle bounds = null;
        if (areaOfInterest != null) {
            bounds = areaOfInterest.getBounds();
            ImageUtilities.clipBounds(source, bounds);
            if (bounds.isEmpty()) {
                bounds.x = this.getMinX();
                bounds.y = this.getMinY();
                bounds.width = 0;
                bounds.height = 0;
            }
            if (areaOfInterest.contains(bounds)) {
                areaOfInterest = bounds;
            }
            if (bounds.x == this.getMinX() && bounds.width == this.getWidth() && bounds.y == this.getMinY() && bounds.height == this.getHeight()) {
                if (bounds == areaOfInterest) {
                    areaOfInterest = null;
                }
                bounds = null;
            }
        }
        this.boundsOfInterest = bounds;
        this.areaOfInterest = areaOfInterest;
        this.parallel = parallel;
        this.failOnException = failOnException;
        while (source instanceof ImageAdapter) {
            if (source instanceof AnnotatedImage) {
                this.cache = ((AnnotatedImage)source).cache;
                return;
            }
            source = ((ImageAdapter)source).source;
        }
        WeakHashMap<RenderedImage, Cache<Object, Object>> weakHashMap = CACHE;
        synchronized (weakHashMap) {
            this.cache = CACHE.computeIfAbsent(source, k -> new Cache(8, 200L, false));
        }
    }

    Object[] getExtraParameter() {
        return null;
    }

    final RenderedImage unique() {
        if (this.source.getClass() == this.getClass() && this.equalParameters((AnnotatedImage)this.source)) {
            return this.source;
        }
        return ImageProcessor.unique(this);
    }

    private Object getCacheKey(String property) {
        Object[] extraParameter = this.getExtraParameter();
        return this.areaOfInterest != null || extraParameter != null ? new CacheKey(property, this.areaOfInterest, extraParameter) : property;
    }

    protected abstract String getComputedPropertyName();

    @Override
    public String[] getPropertyNames() {
        boolean hasErrors = this.errors != null;
        String[] names = new String[hasErrors ? 2 : 1];
        names[0] = this.getComputedPropertyName();
        if (hasErrors) {
            names[1] = names[0] + WARNINGS_SUFFIX;
        }
        return ArraysExt.concatenate(this.source.getPropertyNames(), names);
    }

    private static boolean isErrorProperty(String cn, String name) {
        return name != null && name.length() == cn.length() + WARNINGS_SUFFIX.length() && name.startsWith(cn) && name.endsWith(WARNINGS_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object getProperty(String name) {
        Object value;
        block9: {
            String property;
            block8: {
                property = this.getComputedPropertyName();
                if (!property.equals(name)) break block8;
                Object key = this.getCacheKey(property);
                value = this.cache.peek(key);
                if (value != null) break block9;
                boolean success = false;
                Cache.Handler<Object> handler = this.cache.lock(key);
                try {
                    value = handler.peek();
                    if (value == null) {
                        try {
                            value = this.computeProperty();
                            if (value == null) {
                                value = NULL;
                            }
                            success = this.errors == null;
                        }
                        catch (Exception e) {
                            if (this.failOnException) {
                                throw (ImagingOpException)new ImagingOpException(Errors.format((short)5, property)).initCause(e);
                            }
                            ErrorHandler.Report report = this.errors;
                            if (report == null) {
                                this.errors = report = new ErrorHandler.Report();
                            }
                            report.add(null, e, () -> Errors.getResources((Locale)null).getLogRecord(Level.WARNING, (short)5, property));
                        }
                    }
                    handler.putAndUnlock(success ? value : null);
                }
                catch (Throwable throwable) {
                    handler.putAndUnlock(success ? value : null);
                    throw throwable;
                }
                value = value == NULL ? null : this.cloneProperty(property, value);
                break block9;
            }
            value = AnnotatedImage.isErrorProperty(property, name) ? this.errors : this.source.getProperty(name);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void logAndClearError(Class<?> classe, String method, ErrorHandler handler) {
        ErrorHandler.Report report = this.errors;
        if (report != null) {
            ErrorHandler.Report report2 = report;
            synchronized (report2) {
                LogRecord record = report.getDescription();
                record.setSourceClassName(classe.getCanonicalName());
                record.setSourceMethodName(method);
                this.errors = null;
            }
            handler.handle(report);
        }
    }

    protected Object computeProperty() throws Exception {
        Collector<? super Raster, ?, ?> collector;
        TileOpExecutor executor;
        if (this.parallel && (executor = new TileOpExecutor(this.source, this.boundsOfInterest)).isMultiTiled() && (collector = this.collector()) != null) {
            if (!this.failOnException) {
                executor.setErrorHandler(e -> {
                    this.errors = e;
                }, AnnotatedImage.class, "getProperty");
            }
            executor.setAreaOfInterest(this.source, this.areaOfInterest);
            return executor.executeOnReadable(this.source, collector);
        }
        return this.computeSequentially();
    }

    protected abstract Object computeSequentially() throws Exception;

    protected Collector<? super Raster, ?, ?> collector() {
        return null;
    }

    protected Object cloneProperty(String name, Object value) {
        return value;
    }

    final Class<AnnotatedImage> appendStringContent(StringBuilder buffer) {
        String property = this.getComputedPropertyName();
        if (this.cache.containsKey(this.getCacheKey(property))) {
            buffer.append("Cached ");
        }
        buffer.append('\"').append(property).append('\"');
        return AnnotatedImage.class;
    }

    @Override
    public final int hashCode() {
        return super.hashCode() + Objects.hashCode(this.areaOfInterest) + Boolean.hashCode(this.failOnException);
    }

    @Override
    public final boolean equals(Object object) {
        return super.equals(object) && this.equalParameters((AnnotatedImage)object);
    }

    private boolean equalParameters(AnnotatedImage other) {
        return this.parallel == other.parallel && this.failOnException == other.failOnException && Objects.equals(this.areaOfInterest, other.areaOfInterest) && Arrays.equals(this.getExtraParameter(), other.getExtraParameter());
    }

    private static final class CacheKey {
        private final String property;
        private final Shape areaOfInterest;
        private final Object[] extraParameter;

        CacheKey(String property, Shape areaOfInterest, Object[] extraParameter) {
            this.property = property;
            this.areaOfInterest = areaOfInterest;
            this.extraParameter = extraParameter;
        }

        public int hashCode() {
            return this.property.hashCode() + 19 * Objects.hashCode(this.areaOfInterest) + 37 * Arrays.hashCode(this.extraParameter);
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                return this.property.equals(other.property) && Objects.equals(this.areaOfInterest, other.areaOfInterest) && Arrays.equals(this.extraParameter, other.extraParameter);
            }
            return false;
        }

        public String toString() {
            return Strings.toString(this.getClass(), "property", this.property, "areaOfInterest", this.areaOfInterest);
        }
    }
}

