/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.setup;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.system.Fallback;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;

public abstract class OptionalInstallations
extends InstallationResources
implements Localized {
    private static final String EPSG_DOWNLOAD_URL = "https://repo1.maven.org/maven2/org/apache/sis/non-free/sis-epsg/1.3/sis-epsg-1.3.jar";
    private static final int DATABASE_SIZE = 26;
    private final String licenseMimeType;
    protected final Path destinationDirectory;
    private InstallationResources provider;
    private Boolean accepted;

    protected OptionalInstallations(String string) {
        ArgumentChecks.ensureNonEmpty("licenseMimeType", string);
        this.licenseMimeType = string;
        this.destinationDirectory = DataDirectory.DATABASES.getDirectory();
    }

    protected abstract boolean askUserAgreement(String var1, String var2);

    @Override
    public Locale getLocale() {
        return Locale.getDefault();
    }

    @Override
    public Set<String> getAuthorities() {
        return this.destinationDirectory != null ? Collections.singleton("EPSG") : Collections.emptySet();
    }

    private IllegalArgumentException unsupported(String string) {
        return new IllegalArgumentException(Errors.getResources(this.getLocale()).getString((short)45, "authority", string));
    }

    public int getSpaceRequirement(String string) {
        switch (string) {
            case "EPSG": {
                return 26;
            }
        }
        throw this.unsupported(string);
    }

    private String getDownloadURL(String string) {
        switch (string) {
            case "EPSG": {
                return System.getProperty("org.apache.sis.epsg.downloadURL", EPSG_DOWNLOAD_URL);
            }
        }
        throw this.unsupported(string);
    }

    private InstallationResources download(String string) throws IOException {
        String string2 = this.getDownloadURL(string);
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{new URL(string2)});
        for (InstallationResources installationResources : ServiceLoader.load(InstallationResources.class, uRLClassLoader)) {
            if (installationResources.getClass().isAnnotationPresent(Fallback.class) || !installationResources.getAuthorities().contains(string)) continue;
            return installationResources;
        }
        throw new FileNotFoundException(Errors.getResources(this.getLocale()).getString((short)39, string2));
    }

    private synchronized InstallationResources provider(String string, boolean bl) throws IOException {
        if (!"EPSG".equals(string)) {
            throw this.unsupported(string);
        }
        if (this.provider == null) {
            if (!this.askUserAgreement(string, null)) {
                throw new AccessDeniedException(this.getDownloadURL(string));
            }
            this.provider = this.download(string);
        }
        if (bl) {
            if (this.accepted == null) {
                String string2 = this.getLicense(string, this.getLocale(), this.licenseMimeType);
                this.accepted = string2 == null || this.askUserAgreement(string, string2);
            }
            if (!this.accepted.booleanValue()) {
                throw new AccessDeniedException(this.getDownloadURL(string));
            }
        }
        return this.provider;
    }

    @Override
    public String getLicense(String string, Locale locale, String string2) throws IOException {
        return this.provider(string, false).getLicense(string, locale, string2);
    }

    @Override
    public String[] getResourceNames(String string) throws IOException {
        return this.provider(string, true).getResourceNames(string);
    }

    @Override
    public Object getResource(String string, int n) throws IOException {
        return this.provider(string, true).getResource(string, n);
    }

    @Override
    public BufferedReader openScript(String string, int n) throws IOException {
        return this.provider(string, true).openScript(string, n);
    }
}

