/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.opengis.referencing.operation.Matrix;

public class Matrix1
extends MatrixSIS {
    private static final long serialVersionUID = -4829171016106097031L;
    public static final int SIZE = 1;
    public double m00;

    public Matrix1() {
        this.m00 = 1.0;
    }

    Matrix1(boolean bl) {
    }

    public Matrix1(double d) {
        this.m00 = d;
    }

    public Matrix1(double[] dArray) throws IllegalArgumentException {
        this.setElements(dArray);
    }

    Matrix1(Matrix matrix) {
        this.m00 = matrix.getElement(0, 0);
    }

    public static Matrix1 castOrCopy(Matrix matrix) throws MismatchedMatrixSizeException {
        if (matrix == null || matrix instanceof Matrix1) {
            return (Matrix1)matrix;
        }
        Matrix1.ensureSizeMatch(1, 1, matrix);
        return new Matrix1(matrix);
    }

    @Override
    public final int getNumRow() {
        return 1;
    }

    @Override
    public final int getNumCol() {
        return 1;
    }

    @Override
    public final double getElement(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return this.m00;
        }
        throw Matrix1.indexOutOfBounds(n, n2);
    }

    @Override
    public final void setElement(int n, int n2, double d) {
        if (n != 0 || n2 != 0) {
            throw Matrix1.indexOutOfBounds(n, n2);
        }
        this.m00 = d;
    }

    @Override
    public final double[] getElements() {
        double[] dArray = new double[1];
        this.getElements(dArray);
        return dArray;
    }

    @Override
    final void getElements(double[] dArray) {
        dArray[0] = this.m00;
    }

    @Override
    public final void setElements(double[] dArray) {
        Matrix1.ensureLengthMatch(1, dArray);
        this.m00 = dArray[0];
    }

    @Override
    public final boolean isAffine() {
        return this.m00 == 1.0;
    }

    @Override
    public final boolean isIdentity() {
        return this.m00 == 1.0;
    }

    @Override
    public void transpose() {
    }

    @Override
    public MatrixSIS normalizeColumns() {
        Matrix1 matrix1 = new Matrix1(Math.abs(this.m00));
        this.m00 = Math.signum(this.m00);
        return matrix1;
    }

    @Override
    public Matrix1 clone() {
        return (Matrix1)super.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            Matrix1 matrix1 = (Matrix1)object;
            return Numerics.equals(this.m00, matrix1.m00);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(Double.doubleToLongBits(this.m00) ^ 0xBCFB568C01624679L);
    }
}

