/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gml.Measure;
import org.apache.sis.internal.jaxb.referencing.SecondDefiningParameter;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.Sphere;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.datum.Ellipsoid;

@XmlType(name="EllipsoidType", propOrder={"semiMajorAxisMeasure", "secondDefiningParameter"})
@XmlRootElement(name="Ellipsoid")
public class DefaultEllipsoid
extends AbstractIdentifiedObject
implements Ellipsoid {
    private static final long serialVersionUID = -1149451543954764081L;
    private double semiMajorAxis;
    private double semiMinorAxis;
    private double inverseFlattening;
    private boolean ivfDefinitive;
    private Unit<Length> unit;

    protected DefaultEllipsoid(Map<String, ?> map, double d, double d2, double d3, boolean bl, Unit<Length> unit) {
        super(map);
        ArgumentChecks.ensureNonNull("unit", unit);
        ArgumentChecks.ensureStrictlyPositive("semiMajorAxis", d);
        ArgumentChecks.ensureStrictlyPositive("semiMinorAxis", d2);
        ArgumentChecks.ensureStrictlyPositive("inverseFlattening", d3);
        this.unit = unit;
        this.semiMajorAxis = d;
        this.semiMinorAxis = d2;
        this.inverseFlattening = d3;
        this.ivfDefinitive = bl;
    }

    protected DefaultEllipsoid(Ellipsoid ellipsoid) {
        super(ellipsoid);
        this.semiMajorAxis = ellipsoid.getSemiMajorAxis();
        this.semiMinorAxis = ellipsoid.getSemiMinorAxis();
        this.inverseFlattening = ellipsoid.getInverseFlattening();
        this.ivfDefinitive = ellipsoid.isIvfDefinitive();
        this.unit = ellipsoid.getAxisUnit();
    }

    public static DefaultEllipsoid createEllipsoid(Map<String, ?> map, double d, double d2, Unit<Length> unit) {
        if (d == d2) {
            return new Sphere(map, d, false, unit);
        }
        return new DefaultEllipsoid(map, d, d2, Formulas.getInverseFlattening(d, d2), false, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(Map<String, ?> map, double d, double d2, Unit<Length> unit) {
        if (Double.isInfinite(d2)) {
            return new Sphere(map, d, true, unit);
        }
        return new DefaultEllipsoid(map, d, Formulas.getSemiMinor(d, d2), d2, true, unit);
    }

    public static DefaultEllipsoid castOrCopy(Ellipsoid ellipsoid) {
        if (ellipsoid == null || ellipsoid instanceof DefaultEllipsoid) {
            return (DefaultEllipsoid)ellipsoid;
        }
        Map<String, ?> map = IdentifiedObjects.getProperties(ellipsoid, new String[0]);
        double d = ellipsoid.getSemiMajorAxis();
        Unit<Length> unit = ellipsoid.getAxisUnit();
        return ellipsoid.isIvfDefinitive() ? DefaultEllipsoid.createFlattenedSphere(map, d, ellipsoid.getInverseFlattening(), unit) : DefaultEllipsoid.createEllipsoid(map, d, ellipsoid.getSemiMinorAxis(), unit);
    }

    public Class<? extends Ellipsoid> getInterface() {
        return Ellipsoid.class;
    }

    @Override
    public Unit<Length> getAxisUnit() {
        return this.unit;
    }

    @Override
    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    @Override
    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    public double getAuthalicRadius() {
        return Formulas.getAuthalicRadius(this.getSemiMajorAxis(), this.getSemiMinorAxis());
    }

    public double getRadius(double d) {
        return Formulas.getRadius(this, Math.toRadians(d));
    }

    public double getEccentricity() {
        DoubleDouble doubleDouble = this.eccentricitySquared();
        doubleDouble.sqrt();
        return doubleDouble.doubleValue();
    }

    public double getEccentricitySquared() {
        return this.eccentricitySquared().doubleValue();
    }

    private DoubleDouble eccentricitySquared() {
        DoubleDouble doubleDouble = DefaultEllipsoid.flattening(this);
        DoubleDouble doubleDouble2 = new DoubleDouble(doubleDouble);
        doubleDouble2.multiply(2.0);
        doubleDouble.square();
        doubleDouble2.subtract(doubleDouble);
        return doubleDouble2;
    }

    private static DoubleDouble flattening(Ellipsoid ellipsoid) {
        DoubleDouble doubleDouble;
        if (ellipsoid.isIvfDefinitive()) {
            doubleDouble = DoubleDouble.createAndGuessError(ellipsoid.getInverseFlattening());
            doubleDouble.inverseDivide(1.0);
        } else {
            doubleDouble = DoubleDouble.createAndGuessError(ellipsoid.getSemiMajorAxis());
            double d = doubleDouble.value;
            double d2 = doubleDouble.error;
            doubleDouble.subtractGuessError(ellipsoid.getSemiMinorAxis());
            doubleDouble.divide(d, d2);
        }
        return doubleDouble;
    }

    @Override
    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    @Override
    public boolean isIvfDefinitive() {
        return this.ivfDefinitive;
    }

    @Override
    public boolean isSphere() {
        return this.semiMajorAxis == this.semiMinorAxis;
    }

    public double semiMajorAxisDifference(Ellipsoid ellipsoid) {
        double d = ellipsoid.getSemiMajorAxis();
        d = ellipsoid.getAxisUnit().getConverterTo(this.getAxisUnit()).convert(d);
        DoubleDouble doubleDouble = DoubleDouble.createAndGuessError(d);
        doubleDouble.subtractGuessError(this.getSemiMajorAxis());
        return doubleDouble.doubleValue();
    }

    public double flatteningDifference(Ellipsoid ellipsoid) {
        DoubleDouble doubleDouble = DefaultEllipsoid.flattening(ellipsoid);
        doubleDouble.subtract(DefaultEllipsoid.flattening(this));
        return doubleDouble.doubleValue();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                DefaultEllipsoid defaultEllipsoid = (DefaultEllipsoid)object;
                return this.ivfDefinitive == defaultEllipsoid.ivfDefinitive && Numerics.equals(this.semiMajorAxis, defaultEllipsoid.semiMajorAxis) && Numerics.equals(this.semiMinorAxis, defaultEllipsoid.semiMinorAxis) && Numerics.equals(this.inverseFlattening, defaultEllipsoid.inverseFlattening) && Objects.equals(this.unit, defaultEllipsoid.unit);
            }
            case BY_CONTRACT: {
                if (this.isIvfDefinitive() != ((Ellipsoid)object).isIvfDefinitive()) {
                    return false;
                }
            }
            case IGNORE_METADATA: {
                if (Numerics.equals(this.getInverseFlattening(), ((Ellipsoid)object).getInverseFlattening())) break;
                return false;
            }
        }
        Ellipsoid ellipsoid = (Ellipsoid)object;
        Unit<Length> unit = this.getAxisUnit();
        if (!Utilities.deepEquals(unit, ellipsoid.getAxisUnit(), comparisonMode)) {
            return false;
        }
        UnitConverter unitConverter = comparisonMode.isApproximate() ? unit.getConverterTo(Units.METRE) : null;
        boolean bl = false;
        double d = this.getSemiMajorAxis();
        double d2 = ellipsoid.getSemiMajorAxis();
        if (unitConverter == null ? Numerics.equals(d, d2) : Numerics.epsilonEqual(unitConverter.convert(d), unitConverter.convert(d2), 0.01)) {
            bl = true;
            d = this.getSemiMinorAxis();
            d2 = ellipsoid.getSemiMinorAxis();
            if (unitConverter == null ? Numerics.equals(d, d2) : Numerics.epsilonEqual(unitConverter.convert(d), unitConverter.convert(d2), 0.01)) {
                return true;
            }
        }
        assert (comparisonMode != ComparisonMode.DEBUG) : Numerics.messageForDifference(bl ? "semiMinorAxis" : "semiMajorAxis", d, d2);
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + Double.doubleToLongBits(this.semiMajorAxis) + 31L * Double.doubleToLongBits(this.ivfDefinitive ? this.inverseFlattening : this.semiMinorAxis);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        Convention convention = formatter.getConvention();
        boolean bl = convention.majorVersion() == 1;
        Unit<Length> unit = this.getAxisUnit();
        double d = this.getSemiMajorAxis();
        if (bl) {
            d = unit.getConverterTo(Units.METRE).convert(d);
        }
        formatter.append(d);
        double d2 = this.getInverseFlattening();
        formatter.append(Double.isInfinite(d2) ? 0.0 : d2);
        if (bl) {
            return "Spheroid";
        }
        if (!convention.isSimplified() || !Units.METRE.equals(unit)) {
            formatter.append(unit);
        }
        return "Ellipsoid";
    }

    private DefaultEllipsoid() {
        super(NilReferencingObject.INSTANCE);
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        if (this.ivfDefinitive) {
            if (this.semiMinorAxis == 0.0) {
                this.semiMinorAxis = Formulas.getSemiMinor(this.semiMajorAxis, this.inverseFlattening);
            }
        } else if (this.inverseFlattening == 0.0) {
            this.inverseFlattening = Formulas.getInverseFlattening(this.semiMajorAxis, this.semiMinorAxis);
        } else if (this.inverseFlattening == Double.POSITIVE_INFINITY && this.semiMinorAxis == 0.0) {
            this.semiMinorAxis = this.semiMajorAxis;
        }
        if (this.unit == null) {
            this.unit = Units.METRE;
            Measure.missingUOM(DefaultEllipsoid.class, "semiMajorAxis");
        }
    }

    @XmlElement(name="semiMajorAxis", required=true)
    private Measure getSemiMajorAxisMeasure() {
        return new Measure(this.semiMajorAxis, this.unit);
    }

    private void setSemiMajorAxisMeasure(Measure measure) {
        if (this.semiMajorAxis == 0.0) {
            Unit<Length> unit = this.unit;
            this.semiMajorAxis = measure.value;
            ArgumentChecks.ensureStrictlyPositive("semiMajorAxis", this.semiMajorAxis);
            this.unit = measure.getUnit(Length.class);
            this.harmonizeAxisUnits(unit);
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultEllipsoid.class, "setSemiMajorAxisMeasure", "semiMajorAxis");
        }
    }

    @XmlElement(name="secondDefiningParameter", required=true)
    private SecondDefiningParameter getSecondDefiningParameter() {
        return new SecondDefiningParameter(this, true);
    }

    private void setSecondDefiningParameter(SecondDefiningParameter secondDefiningParameter) {
        boolean bl;
        Measure measure;
        if (secondDefiningParameter.secondDefiningParameter != null) {
            secondDefiningParameter = secondDefiningParameter.secondDefiningParameter;
        }
        boolean bl2 = false;
        if (Boolean.TRUE.equals(secondDefiningParameter.isSphere)) {
            boolean bl3 = bl2 = this.inverseFlattening != 0.0;
            if (!bl2) {
                this.inverseFlattening = Double.POSITIVE_INFINITY;
            }
        }
        if ((measure = secondDefiningParameter.measure) != null && !(bl2 |= ((bl = secondDefiningParameter.isIvfDefinitive()) ? this.inverseFlattening : this.semiMinorAxis) != 0.0)) {
            this.ivfDefinitive = bl;
            double d = measure.value;
            if (bl) {
                if (d == 0.0) {
                    d = Double.POSITIVE_INFINITY;
                }
                this.inverseFlattening = d;
                ArgumentChecks.ensureStrictlyPositive("inverseFlattening", this.inverseFlattening);
            } else {
                this.semiMinorAxis = d;
                ArgumentChecks.ensureStrictlyPositive("semiMinorAxis", this.semiMinorAxis);
                this.harmonizeAxisUnits(measure.getUnit(Length.class));
            }
        }
        if (bl2) {
            ImplementationHelper.propertyAlreadySet(DefaultEllipsoid.class, "setSecondDefiningParameter", "secondDefiningParameter");
        }
    }

    private void harmonizeAxisUnits(Unit<Length> unit) {
        if (this.unit == null) {
            this.unit = unit;
        } else if (unit != null && unit != this.unit) {
            this.semiMinorAxis = unit.getConverterTo(this.unit).convert(this.semiMinorAxis);
        }
    }
}

