/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.parameter.UnmodifiableParameterValueGroup;
import org.apache.sis.util.ComparisonMode;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;

final class FilteredParameters
extends UnmodifiableParameterValueGroup {
    private static final long serialVersionUID = 4880548875706032438L;
    private final GeneralParameterValue[] filtered;

    private FilteredParameters(UnmodifiableParameterValueGroup unmodifiableParameterValueGroup, GeneralParameterValue[] generalParameterValueArray) {
        super(unmodifiableParameterValueGroup);
        this.filtered = generalParameterValueArray;
    }

    static UnmodifiableParameterValueGroup create(UnmodifiableParameterValueGroup unmodifiableParameterValueGroup, Predicate<? super GeneralParameterDescriptor> predicate) {
        if (unmodifiableParameterValueGroup != null && predicate != null) {
            List<GeneralParameterValue> list = unmodifiableParameterValueGroup.values();
            GeneralParameterValue[] generalParameterValueArray = new GeneralParameterValue[list.size()];
            int n = 0;
            for (GeneralParameterValue generalParameterValue : list) {
                if (!predicate.test(generalParameterValue.getDescriptor())) continue;
                generalParameterValueArray[n++] = generalParameterValue;
            }
            if (n != generalParameterValueArray.length) {
                return new FilteredParameters(unmodifiableParameterValueGroup, Arrays.copyOf(generalParameterValueArray, n));
            }
        }
        return unmodifiableParameterValueGroup;
    }

    @Override
    public List<GeneralParameterValue> values() {
        return UnmodifiableArrayList.wrap(this.filtered);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode) && comparisonMode == ComparisonMode.STRICT) {
            FilteredParameters filteredParameters = (FilteredParameters)object;
            return Arrays.equals(this.filtered, filteredParameters.filtered);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.filtered.length;
    }
}

