/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataVisitor;
import org.apache.sis.metadata.PropertyComparator;
import org.apache.sis.metadata.PropertyInformation;
import org.apache.sis.metadata.SpecialCases;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.UnmodifiableMetadataException;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.opengis.annotation.UML;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.citation.Citation;

class PropertyAccessor {
    static final int COUNT_FIRST = 0;
    static final int COUNT_SHALLOW = 1;
    static final int COUNT_DEEP = 2;
    static final int RETURN_NULL = 0;
    static final int RETURN_PREVIOUS = 1;
    static final int APPEND = 2;
    static final int IGNORE_READ_ONLY = 3;
    private static final Method EXTRA_GETTER;
    final Class<?> type;
    final Class<?> implementation;
    private final int allCount;
    private final int standardCount;
    private final Method[] getters;
    private final Method[] setters;
    private final String[] names;
    private final Class<?>[] elementTypes;
    private final Map<String, Integer> mapping;
    private volatile transient ObjectConverter<?, ?> lastConverter;
    private transient ExtendedElementInformation[] informations;

    PropertyAccessor(Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
        int n;
        assert (clazz.isAssignableFrom(clazz2)) : clazz2;
        this.type = clazz;
        this.implementation = clazz2;
        this.getters = PropertyAccessor.getGetters(clazz, clazz2, clazz3);
        int n2 = n = this.getters.length;
        if (n != 0 && this.getters[n - 1] == EXTRA_GETTER) {
            if (!EXTRA_GETTER.getDeclaringClass().isAssignableFrom(clazz2)) {
                --n;
            }
            --n2;
        }
        while (n2 != 0 && this.isDeprecated(n2 - 1)) {
            --n2;
        }
        this.allCount = n;
        this.standardCount = n2;
        this.mapping = new HashMap<String, Integer>(Containers.hashMapCapacity(n));
        this.names = new String[n];
        this.elementTypes = new Class[n];
        Method[] methodArray = null;
        Class[] classArray = new Class[1];
        for (int i = 0; i < n; ++i) {
            Class<Object> clazz4;
            Method method;
            Method method2;
            block21: {
                Class<?> clazz5;
                Integer n3 = i;
                method2 = this.getters[i];
                String string = method2.getName();
                int n4 = PropertyComparator.prefix(string).length();
                this.addMapping(string, n3);
                this.names[i] = PropertyComparator.toPropertyName(string, n4);
                this.addMappingWithLowerCase(this.names[i], n3);
                UML uML = method2.getAnnotation(UML.class);
                if (uML != null) {
                    this.addMappingWithLowerCase(uML.identifier().intern(), n3);
                }
                classArray[0] = clazz5 = method2.getReturnType();
                if (string.length() > n4) {
                    int n5 = string.codePointAt(n4);
                    int n6 = Character.toUpperCase(n5);
                    int n7 = string.length();
                    StringBuilder stringBuilder = new StringBuilder(n7 - n4 + 5).append("set");
                    if (n5 != n6) {
                        stringBuilder.appendCodePoint(n6).append(string, n4 + Character.charCount(n5), n7);
                    } else {
                        stringBuilder.append(string, n4, n7);
                    }
                    string = stringBuilder.toString();
                }
                method = null;
                try {
                    method = clazz2.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method2 = clazz2.getMethod(method2.getName(), null);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        throw new AssertionError((Object)noSuchMethodException2);
                    }
                    Class<?> clazz6 = clazz5;
                    clazz5 = method2.getReturnType();
                    if (clazz6 == clazz5) break block21;
                    classArray[0] = clazz5;
                    try {
                        method = clazz2.getMethod(string, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {
                        // empty catch block
                    }
                }
            }
            if (method != null) {
                if (methodArray == null) {
                    methodArray = new Method[n];
                }
                methodArray[i] = method;
            }
            if (Collection.class.isAssignableFrom(clazz4 = method2.getReturnType())) {
                clazz4 = Classes.boundOfParameterizedProperty(method2);
                if (clazz4 == null) {
                    clazz4 = Classes.boundOfParameterizedProperty(this.getters[i]);
                }
            } else if (Map.class.isAssignableFrom(clazz4)) {
                clazz4 = Map.Entry.class;
            }
            this.elementTypes[i] = Numbers.primitiveToWrapper(clazz4);
        }
        this.setters = methodArray;
    }

    private void addMapping(String string, Integer n) {
        Integer n2;
        if (!string.isEmpty() && (n2 = this.mapping.put(string, n)) != null && !n2.equals(n)) {
            boolean bl = this.isDeprecated(n);
            if (bl == this.isDeprecated(n2)) {
                throw new IllegalStateException(Errors.format((short)25, Classes.getShortName(this.type) + '.' + string));
            }
            if (bl) {
                this.mapping.put(string, n2);
            }
        }
    }

    private void addMappingWithLowerCase(String string, Integer n) {
        this.addMapping(string, n);
        String string2 = string.toLowerCase(Locale.ROOT);
        if (!string2.equals(string)) {
            this.addMapping(string2, n);
        }
    }

    private static Method[] getGetters(Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
        Method[] methodArray = clazz2.getMethods();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(Containers.hashMapCapacity(methodArray.length));
        boolean bl = false;
        int n = 0;
        for (Method method : methodArray) {
            Integer n2;
            String string;
            if (!Classes.isPossibleGetter(method) || (string = method.getName()).startsWith("set") || SpecialCases.exclude(clazz, string)) continue;
            if (clazz == clazz2) {
                if (!clazz.isInterface() && !method.isAnnotationPresent(UML.class)) {
                    continue;
                }
            } else {
                try {
                    method = clazz.getMethod(string, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!method.isAnnotationPresent(UML.class)) continue;
                }
            }
            if ((n2 = hashMap.put(string, n)) != null) {
                Class<?> clazz4 = methodArray[n2].getReturnType();
                Class<?> clazz5 = method.getReturnType();
                if (clazz5.isAssignableFrom(clazz4)) continue;
                if (clazz4.isAssignableFrom(clazz5)) {
                    methodArray[n2.intValue()] = method;
                    continue;
                }
                throw new ClassCastException(Errors.format((short)43, Classes.getShortName(clazz) + '.' + string, clazz5, clazz4));
            }
            methodArray[n++] = method;
            if (bl) continue;
            bl = string.equals(EXTRA_GETTER.getName());
        }
        Arrays.sort(methodArray, 0, n, new PropertyComparator(clazz2, clazz3));
        if (!bl) {
            if (methodArray.length == n) {
                methodArray = Arrays.copyOf(methodArray, n + 1);
            }
            methodArray[n++] = EXTRA_GETTER;
        }
        methodArray = ArraysExt.resize(methodArray, n);
        return methodArray;
    }

    final int count() {
        return this.standardCount;
    }

    final int indexOf(String string, boolean bl) {
        String string2;
        Integer n = this.mapping.get(string);
        if (n == null && ((string2 = CharSequences.trimWhitespaces(CharSequences.replace(string, " ", "").toString().toLowerCase(Locale.ROOT))) == string || (n = this.mapping.get(string2)) == null)) {
            if (!bl) {
                return -1;
            }
            throw new IllegalArgumentException(Errors.format((short)120, this.type, string));
        }
        return n;
    }

    final String name(int n, KeyNamePolicy keyNamePolicy) {
        if (n >= 0 && n < this.names.length) {
            switch (keyNamePolicy) {
                case UML_IDENTIFIER: {
                    UML uML = this.getters[n].getAnnotation(UML.class);
                    if (uML != null) {
                        return uML.identifier().intern();
                    }
                }
                case JAVABEANS_PROPERTY: {
                    return this.names[n];
                }
                case METHOD_NAME: {
                    return this.getters[n].getName();
                }
                case SENTENCE: {
                    return CharSequences.camelCaseToSentence(this.names[n]).toString();
                }
            }
        }
        return null;
    }

    Class<?> type(int n, TypeValuePolicy typeValuePolicy) {
        if (n >= 0 && n < this.allCount) {
            switch (typeValuePolicy) {
                case ELEMENT_TYPE: {
                    return this.elementTypes[n];
                }
                case PROPERTY_TYPE: {
                    return this.getters[n].getReturnType();
                }
                case DECLARING_INTERFACE: {
                    return this.getters[n].getDeclaringClass();
                }
                case DECLARING_CLASS: {
                    Method method = this.getters[n];
                    if (this.implementation != this.type) {
                        try {
                            method = this.implementation.getMethod(method.getName(), null);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new AssertionError((Object)noSuchMethodException);
                        }
                    }
                    return method.getDeclaringClass();
                }
            }
        }
        return null;
    }

    final boolean isCollectionOrMap(int n) {
        if (n >= 0 && n < this.allCount) {
            Class<?> clazz = this.getters[n].getReturnType();
            return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
        }
        return false;
    }

    final boolean isMap(int n) {
        return n >= 0 && n < this.allCount && this.elementTypes[n] == Map.Entry.class;
    }

    private boolean isDeprecated(int n) {
        return PropertyComparator.isDeprecated(this.implementation, this.getters[n]);
    }

    final synchronized ExtendedElementInformation information(Citation citation, int n) {
        ExtendedElementInformation[] extendedElementInformationArray = this.informations;
        if (extendedElementInformationArray == null) {
            this.informations = extendedElementInformationArray = new PropertyInformation[this.standardCount];
        }
        if (n < 0 || n >= extendedElementInformationArray.length) {
            return null;
        }
        PropertyInformation propertyInformation = extendedElementInformationArray[n];
        if (propertyInformation == null) {
            ValueRange valueRange;
            Class<?> clazz = this.elementTypes[n];
            String string = this.name(n, KeyNamePolicy.UML_IDENTIFIER);
            Method method = this.getters[n];
            try {
                valueRange = this.implementation.getMethod(method.getName(), null).getAnnotation(ValueRange.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
            extendedElementInformationArray[n] = propertyInformation = new PropertyInformation(citation, string, method, clazz, valueRange);
        }
        return propertyInformation;
    }

    CharSequence remarks(int n, Object object) {
        return null;
    }

    final boolean isWritable() {
        return this.setters != null;
    }

    final boolean isWritable(int n) {
        return n >= 0 && n < this.allCount && this.setters != null && this.setters[n] != null;
    }

    Object get(int n, Object object) throws BackingStoreException {
        return n >= 0 && n < this.allCount ? PropertyAccessor.get(this.getters[n], object) : null;
    }

    private static Object get(Method method, Object object) throws BackingStoreException {
        assert (method.getReturnType() != Void.TYPE) : method;
        try {
            try {
                return method.invoke(object, (Object[])null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (method.getDeclaringClass().isInstance(object)) {
                    throw illegalArgumentException;
                }
                try {
                    Method method2 = object.getClass().getMethod(method.getName(), method.getParameterTypes());
                    if (method.getReturnType().equals(method2.getReturnType())) {
                        return method2.invoke(object, (Object[])null);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return null;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError(method.toString(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new BackingStoreException(throwable);
        }
    }

    Object set(int n, Object object, Object object2, int n2) throws UnmodifiableMetadataException, ClassCastException, BackingStoreException {
        if (n < 0 || n >= this.allCount) {
            return null;
        }
        if (this.setters != null) {
            Method method = this.getters[n];
            Method method2 = this.setters[n];
            if (method2 != null) {
                Object object3;
                List list;
                switch (n2) {
                    case 0: 
                    case 3: {
                        list = null;
                        object3 = null;
                        break;
                    }
                    case 2: {
                        list = PropertyAccessor.get(method, object);
                        object3 = null;
                        break;
                    }
                    case 1: {
                        list = PropertyAccessor.get(method, object);
                        if (list instanceof Collection) {
                            if (list instanceof List) {
                                object3 = CollectionsExt.snapshot(list);
                                break;
                            }
                            object3 = CollectionsExt.modifiableCopy(list);
                            break;
                        }
                        if (list instanceof Map) {
                            object3 = CollectionsExt.modifiableCopy((Map)((Object)list));
                            break;
                        }
                        object3 = list;
                        break;
                    }
                    default: {
                        throw new AssertionError(n2);
                    }
                }
                Object[] objectArray = new Object[]{object2};
                Boolean bl = this.convert(method, object, list, objectArray, this.elementTypes[n], n2 == 2);
                if (bl == null && (bl = Boolean.valueOf(n2 == 0 || n2 == 3 || objectArray[0] != list)).booleanValue() && n2 == 2 && !ValueExistencePolicy.isNullOrEmpty(list)) {
                    return null;
                }
                if (bl.booleanValue()) {
                    PropertyAccessor.set(method2, object, objectArray);
                }
                return n2 == 2 ? bl : object3;
            }
        }
        if (n2 == 3) {
            return UnmodifiableMetadataException.class;
        }
        throw new UnmodifiableMetadataException(Errors.format((short)15, this.type.getSimpleName() + '.' + this.names[n]));
    }

    private static void set(Method method, Object object, Object[] objectArray) throws BackingStoreException {
        try {
            method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new BackingStoreException(throwable);
        }
    }

    private Boolean convert(Method method, Object object, Object object2, Object[] objectArray, Class<?> clazz, boolean bl) throws ClassCastException, BackingStoreException {
        assert (objectArray.length == 1);
        Collection<Object> collection = objectArray[0];
        Class<?> clazz2 = method.getReturnType();
        if (collection == null) {
            if (clazz2.isPrimitive()) {
                objectArray[0] = Numbers.valueOfNil(clazz2);
            }
            return null;
        }
        Boolean bl2 = null;
        if (!Collection.class.isAssignableFrom(clazz2)) {
            if (collection instanceof Collection) {
                Iterator iterator = ((Collection)collection).iterator();
                if (!iterator.hasNext()) {
                    objectArray[0] = null;
                    return null;
                }
                Object e = iterator.next();
                if (!iterator.hasNext()) {
                    collection = e;
                }
            }
            clazz2 = Numbers.primitiveToWrapper(clazz2);
        } else {
            List<Object> list;
            Object[] objectArray2;
            boolean bl3 = collection instanceof Collection;
            if (bl3) {
                objectArray2 = ((Collection)collection).toArray();
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = collection;
            }
            Object[] objectArray4 = objectArray2;
            collection = list = Arrays.asList(objectArray4);
            Collection collection2 = null;
            if (!bl3 || bl) {
                if (object2 == null) {
                    object2 = PropertyAccessor.get(method, object);
                }
                if (object2 != null) {
                    collection2 = (Collection)object2;
                    if (collection2 instanceof CheckedContainer) {
                        clazz = ((CheckedContainer)((Object)collection2)).getElementType();
                    }
                    collection = collection2;
                }
            }
            if (clazz != null) {
                this.convert(objectArray4, clazz);
            }
            if (collection2 != null) {
                bl2 = collection2.addAll(list);
            }
        }
        objectArray[0] = collection;
        this.convert(objectArray, clazz2);
        return bl2;
    }

    private void convert(Object[] objectArray, Class<?> clazz) throws ClassCastException {
        boolean bl = false;
        ObjectConverter<?, ?> objectConverter = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Class<?> clazz2;
            Object object = objectArray[i];
            if (object == null || clazz.isAssignableFrom(clazz2 = object.getClass())) continue;
            try {
                if (objectConverter == null) {
                    objectConverter = this.lastConverter;
                }
                if (objectConverter == null || objectConverter.getSourceClass() != clazz2 || objectConverter.getTargetClass() != clazz) {
                    objectConverter = ObjectConverters.find(clazz2, clazz);
                    bl = true;
                }
                objectArray[i] = objectConverter.apply(object);
                continue;
            }
            catch (UnconvertibleObjectException unconvertibleObjectException) {
                throw (ClassCastException)new ClassCastException(Errors.format((short)50, clazz, clazz2)).initCause(unconvertibleObjectException);
            }
        }
        if (bl) {
            this.lastConverter = objectConverter;
        }
    }

    final int count(Object object, ValueExistencePolicy valueExistencePolicy, int n) throws BackingStoreException {
        assert (this.type.isInstance(object)) : object;
        if (valueExistencePolicy == ValueExistencePolicy.ALL && n != 2) {
            return this.count();
        }
        int n2 = 0;
        block5: for (int i = 0; i < this.standardCount; ++i) {
            Object object2 = PropertyAccessor.get(this.getters[i], object);
            if (valueExistencePolicy.isSkipped(object2)) continue;
            switch (n) {
                case 0: {
                    return 1;
                }
                case 1: {
                    ++n2;
                    continue block5;
                }
                case 2: {
                    n2 += this.isCollectionOrMap(i) ? Math.max(CollectionsExt.size(object2), 1) : 1;
                    continue block5;
                }
                default: {
                    throw new AssertionError(n);
                }
            }
        }
        return n2;
    }

    public boolean equals(Object object, Object object2, ComparisonMode comparisonMode) throws BackingStoreException {
        Object object3;
        assert (this.type.isInstance(object)) : object;
        assert (this.type.isInstance(object2)) : object2;
        for (int i = 0; i < this.standardCount; ++i) {
            boolean bl;
            object3 = this.getters[i];
            Object object4 = PropertyAccessor.get((Method)object3, object);
            Object object5 = PropertyAccessor.get((Method)object3, object2);
            if (ValueExistencePolicy.isNullOrEmpty(object4) && ValueExistencePolicy.isNullOrEmpty(object5) || (bl = !(!(object4 instanceof Double) && !(object4 instanceof Float) || !(object5 instanceof Double) && !(object5 instanceof Float)) ? Numerics.epsilonEqual(((Number)object4).doubleValue(), ((Number)object5).doubleValue(), comparisonMode) : Utilities.deepEquals(object4, object5, comparisonMode))) continue;
            assert (comparisonMode != ComparisonMode.DEBUG) : this.type.getSimpleName() + '.' + this.names[i] + " differ.";
            return false;
        }
        if (comparisonMode == ComparisonMode.STRICT && EXTRA_GETTER.getDeclaringClass().isInstance(object2)) {
            Object object6 = PropertyAccessor.get(EXTRA_GETTER, object);
            object3 = PropertyAccessor.get(EXTRA_GETTER, object2);
            if (!ValueExistencePolicy.isNullOrEmpty(object6) || !ValueExistencePolicy.isNullOrEmpty(object3)) {
                return Utilities.deepEquals(object6, object3, comparisonMode);
            }
        }
        return true;
    }

    final void walkReadable(MetadataVisitor<?> metadataVisitor, Object object) throws Exception {
        assert (this.type.isInstance(object)) : object;
        for (int i = 0; i < this.standardCount; ++i) {
            Object object2;
            metadataVisitor.setCurrentProperty(this.names[i]);
            Object object3 = PropertyAccessor.get(this.getters[i], object);
            if (object3 == null || (object2 = metadataVisitor.visit(this.elementTypes[i], object3)) == object3) continue;
            if (object2 == MetadataVisitor.SKIP_SIBLINGS) break;
            this.set(i, object, object2, 3);
        }
    }

    final void walkWritable(MetadataVisitor<?> metadataVisitor, Object object, Object object2) throws Exception {
        assert (this.type.isInstance(object)) : object;
        assert (this.type.isInstance(object2)) : object2;
        if (this.setters == null || !this.implementation.isInstance(object2)) {
            return;
        }
        Object[] objectArray = new Object[1];
        for (int i = 0; i < this.allCount; ++i) {
            metadataVisitor.setCurrentProperty(this.names[i]);
            Method method = this.setters[i];
            if (method == null || method.isAnnotationPresent(Deprecated.class)) continue;
            Object object3 = PropertyAccessor.get(this.getters[i], object);
            Object object4 = metadataVisitor.visit(this.elementTypes[i], object3);
            if (!(object == object2 ? object4 != object3 : !ValueExistencePolicy.isNullOrEmpty(object4))) continue;
            if (object4 == MetadataVisitor.SKIP_SIBLINGS) break;
            objectArray[0] = object4;
            PropertyAccessor.set(method, object2, objectArray);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(60);
        stringBuilder.append("PropertyAccessor[").append(this.standardCount).append(" getters");
        int n = this.allCount - this.standardCount;
        if (n != 0) {
            stringBuilder.append(" (+").append(n).append(" ext.)");
        }
        if (this.setters != null) {
            int n2 = 0;
            for (Method method : this.setters) {
                if (method == null) continue;
                ++n2;
            }
            stringBuilder.append(" & ").append(n2).append(" setters");
        }
        stringBuilder.append(" in ").append(Classes.getShortName(this.implementation));
        if (this.type != this.implementation) {
            stringBuilder.append(':').append(Classes.getShortName(this.type));
        }
        return stringBuilder.append(']').toString();
    }

    static {
        try {
            EXTRA_GETTER = IdentifiedObject.class.getMethod("getIdentifiers", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }
}

