/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.xml;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.ObjIntConsumer;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.system.SystemListener;

public final class XmlUtilities
extends SystemListener {
    private static volatile DatatypeFactory factory;
    private static final ChronoField[] FIELDS;
    private static final ObjIntConsumer<XMLGregorianCalendar>[] SETTERS;

    private XmlUtilities() {
        super("org.apache.sis.util");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void classpathChanged() {
        Class<XmlUtilities> clazz = XmlUtilities.class;
        synchronized (XmlUtilities.class) {
            factory = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatatypeFactory getDatatypeFactory() throws DatatypeConfigurationException {
        DatatypeFactory datatypeFactory = factory;
        if (datatypeFactory != null) return datatypeFactory;
        Class<XmlUtilities> clazz = XmlUtilities.class;
        synchronized (XmlUtilities.class) {
            datatypeFactory = factory;
            if (datatypeFactory != null) return datatypeFactory;
            factory = datatypeFactory = DatatypeFactory.newInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return datatypeFactory;
        }
    }

    public static boolean trimTime(XMLGregorianCalendar xMLGregorianCalendar, boolean bl) {
        if (bl || xMLGregorianCalendar.getMillisecond() == 0) {
            xMLGregorianCalendar.setMillisecond(Integer.MIN_VALUE);
            if (bl || xMLGregorianCalendar.getHour() == 0 && xMLGregorianCalendar.getMinute() == 0 && xMLGregorianCalendar.getSecond() == 0) {
                xMLGregorianCalendar.setHour(Integer.MIN_VALUE);
                xMLGregorianCalendar.setMinute(Integer.MIN_VALUE);
                xMLGregorianCalendar.setSecond(Integer.MIN_VALUE);
                xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
                return true;
            }
        }
        return false;
    }

    public static XMLGregorianCalendar toXML(Context context, Temporal temporal) throws DatatypeConfigurationException {
        if (temporal == null) {
            return null;
        }
        XMLGregorianCalendar xMLGregorianCalendar = XmlUtilities.getDatatypeFactory().newXMLGregorianCalendar();
        if (temporal instanceof Instant) {
            TimeZone timeZone = context != null ? context.getTimeZone() : null;
            ZoneId zoneId = timeZone != null ? timeZone.toZoneId() : ZoneId.systemDefault();
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant((Instant)temporal, zoneId);
            for (int i = 0; i < FIELDS.length; ++i) {
                SETTERS[i].accept(xMLGregorianCalendar, zonedDateTime.get(FIELDS[i]));
            }
        } else {
            for (int i = 0; i < FIELDS.length; ++i) {
                ChronoField chronoField = FIELDS[i];
                if (!temporal.isSupported(chronoField)) continue;
                SETTERS[i].accept(xMLGregorianCalendar, temporal.get(chronoField));
            }
        }
        return xMLGregorianCalendar;
    }

    public static XMLGregorianCalendar toXML(Context context, Date date) throws DatatypeConfigurationException {
        if (date != null) {
            GregorianCalendar gregorianCalendar = XmlUtilities.createGregorianCalendar(context);
            gregorianCalendar.setTime(date);
            return XmlUtilities.getDatatypeFactory().newXMLGregorianCalendar(gregorianCalendar);
        }
        return null;
    }

    private static GregorianCalendar createGregorianCalendar(Context context) {
        if (context != null) {
            Locale locale = context.getLocale();
            TimeZone timeZone = context.getTimeZone();
            if (timeZone != null) {
                return locale != null ? new GregorianCalendar(timeZone, locale) : new GregorianCalendar(timeZone);
            }
            if (locale != null) {
                return new GregorianCalendar(locale);
            }
        }
        return new GregorianCalendar();
    }

    private static int zeroIfUndef(int n) {
        return n != Integer.MIN_VALUE ? n : 0;
    }

    public static Temporal toTemporal(Context context, XMLGregorianCalendar xMLGregorianCalendar) {
        boolean bl;
        if (xMLGregorianCalendar == null) {
            return null;
        }
        int n = xMLGregorianCalendar.getYear();
        int n2 = xMLGregorianCalendar.getMonth();
        int n3 = xMLGregorianCalendar.getDay();
        int n4 = xMLGregorianCalendar.getHour();
        int n5 = XmlUtilities.zeroIfUndef(xMLGregorianCalendar.getMinute());
        int n6 = XmlUtilities.zeroIfUndef(xMLGregorianCalendar.getSecond());
        boolean bl2 = n != Integer.MIN_VALUE;
        boolean bl3 = bl2 && n2 != Integer.MIN_VALUE;
        boolean bl4 = bl = bl3 && n3 != Integer.MIN_VALUE;
        if (n4 == Integer.MIN_VALUE) {
            return bl ? LocalDate.of(n, n2, n3) : (bl3 ? YearMonth.of(n, n2) : (bl2 ? Year.of(n) : null));
        }
        BigDecimal bigDecimal = xMLGregorianCalendar.getFractionalSecond();
        int n7 = bigDecimal != null ? bigDecimal.movePointRight(9).intValue() : 0;
        int n8 = xMLGregorianCalendar.getTimezone();
        if (n8 == Integer.MIN_VALUE) {
            if (bl) {
                return LocalDateTime.of(n, n2, n3, n4, n5, n6, n7);
            }
            return LocalTime.of(n4, n5, n6, n7);
        }
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n8 * 60);
        if (bl) {
            return OffsetDateTime.of(n, n2, n3, n4, n5, n6, n7, zoneOffset);
        }
        return OffsetTime.of(n4, n5, n6, n7, zoneOffset);
    }

    public static Date toDate(Context context, XMLGregorianCalendar xMLGregorianCalendar) {
        if (xMLGregorianCalendar != null) {
            TimeZone timeZone;
            GregorianCalendar gregorianCalendar = xMLGregorianCalendar.toGregorianCalendar();
            if (context != null && xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE && (timeZone = context.getTimeZone()) != null) {
                gregorianCalendar.setTimeZone(timeZone);
            }
            return gregorianCalendar.getTime();
        }
        return null;
    }

    static {
        SystemListener.add(new XmlUtilities());
        FIELDS = new ChronoField[]{ChronoField.YEAR, ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_MONTH, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.MILLI_OF_SECOND, ChronoField.OFFSET_SECONDS};
        SETTERS = new ObjIntConsumer[FIELDS.length];
        XmlUtilities.SETTERS[0] = XMLGregorianCalendar::setYear;
        XmlUtilities.SETTERS[1] = XMLGregorianCalendar::setMonth;
        XmlUtilities.SETTERS[2] = XMLGregorianCalendar::setDay;
        XmlUtilities.SETTERS[3] = XMLGregorianCalendar::setHour;
        XmlUtilities.SETTERS[4] = XMLGregorianCalendar::setMinute;
        XmlUtilities.SETTERS[5] = XMLGregorianCalendar::setSecond;
        XmlUtilities.SETTERS[6] = XMLGregorianCalendar::setMillisecond;
        XmlUtilities.SETTERS[7] = (xMLGregorianCalendar, n) -> xMLGregorianCalendar.setTimezone(n / 60);
    }
}

