/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.logging.Logger;
import org.apache.sis.internal.system.DaemonThread;
import org.apache.sis.internal.system.Threads;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.logging.Logging;

public final class ReferenceQueueConsumer
extends DaemonThread {
    public static final ReferenceQueue<Object> QUEUE = new ReferenceQueue();

    private ReferenceQueueConsumer(DaemonThread daemonThread) {
        super("ReferenceQueueConsumer", daemonThread);
        this.setPriority(8);
    }

    @Override
    public final void run() {
        ReferenceQueue<Object> referenceQueue;
        while ((referenceQueue = QUEUE) != null) {
            try {
                Reference<Object> reference = referenceQueue.remove();
                if (reference != null) {
                    ((Disposable)((Object)reference)).dispose();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                Logging.unexpectedException(Logger.getLogger("org.apache.sis.system"), this.getClass(), "run", throwable);
            }
            if (!this.isKillRequested()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<Threads> clazz = Threads.class;
        synchronized (Threads.class) {
            ReferenceQueueConsumer referenceQueueConsumer = new ReferenceQueueConsumer(Threads.lastCreatedDaemon);
            Threads.lastCreatedDaemon = referenceQueueConsumer;
            referenceQueueConsumer.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

