/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.wkt;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.wkt.StoreFormat;
import org.apache.sis.internal.storage.wkt.StoreProvider;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.CharSequences;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.ReferenceSystem;

final class Store
extends URIDataStore {
    private static final int SIZE_LIMIT = 1000000;
    private Reader source;
    private final Locale locale;
    private final TimeZone timezone;
    private final GeometryLibrary library;
    private final List<Object> objects = new ArrayList<Object>();
    private Metadata metadata;

    public Store(StoreProvider storeProvider, StorageConnector storageConnector) throws DataStoreException {
        super(storeProvider, storageConnector);
        this.locale = storageConnector.getOption(OptionKey.LOCALE);
        this.timezone = storageConnector.getOption(OptionKey.TIMEZONE);
        this.library = storageConnector.getOption(OptionKey.GEOMETRY_LIBRARY);
        this.source = storageConnector.commit(Reader.class, "WKT");
        this.listeners.useReadOnlyEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws DataStoreException {
        Reader reader = this.source;
        if (reader != null) {
            try {
                String string;
                Object object;
                this.source = null;
                try {
                    int n;
                    object = new char[2048];
                    int n2 = 0;
                    while ((n = reader.read((char[])object, n2, ((char[])object).length - n2)) >= 0) {
                        if ((n2 += n) < ((char[])object).length) continue;
                        if (n >= 1000000) {
                            throw new DataStoreContentException(Resources.format((short)6, this.getDisplayName(), 1000000, n));
                        }
                        object = Arrays.copyOf((char[])object, n << 1);
                    }
                    string = String.valueOf((char[])object, 0, n2);
                }
                finally {
                    reader.close();
                }
                object = new ParsePosition(0);
                StoreFormat storeFormat = new StoreFormat(this.locale, this.timezone, this.library, this.listeners);
                do {
                    Object object2 = storeFormat.parse(string, (ParsePosition)object);
                    this.objects.add(object2);
                    ((ParsePosition)object).setIndex(CharSequences.skipLeadingWhitespaces(string, ((ParsePosition)object).getIndex(), string.length()));
                    storeFormat.validate(object2);
                } while (((ParsePosition)object).getIndex() < string.length());
            }
            catch (ParseException parseException) {
                throw new DataStoreContentException(this.getLocale(), "WKT", this.getDisplayName(), (Object)reader).initCause(parseException);
            }
            catch (IOException iOException) {
                throw new DataStoreException(this.getLocale(), "WKT", this.getDisplayName(), (Object)reader).initCause(iOException);
            }
        }
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.parse();
            MetadataBuilder metadataBuilder = new MetadataBuilder();
            String string = null;
            int n = 0;
            for (Object object : this.objects) {
                if (!(object instanceof ReferenceSystem)) continue;
                ReferenceSystem referenceSystem = (ReferenceSystem)object;
                metadataBuilder.addReferenceSystem(referenceSystem);
                string = IdentifiedObjects.getDisplayName(referenceSystem, this.getLocale());
                ++n;
                metadataBuilder.addIdentifier(IdentifiedObjects.getIdentifier(referenceSystem, null), MetadataBuilder.Scope.RESOURCE);
            }
            if (n == 1) {
                metadataBuilder.addTitle(string);
            } else {
                this.addTitleOrIdentifier(metadataBuilder);
            }
            this.metadata = metadataBuilder.buildAndFreeze();
        }
        return this.metadata;
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.listeners.close();
        Reader reader = this.source;
        this.source = null;
        this.objects.clear();
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
        }
    }
}

