/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;

final class NullChannel
implements ReadableByteChannel {
    private volatile boolean closed;

    NullChannel() {
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws ClosedChannelException {
        Objects.requireNonNull(byteBuffer);
        if (this.closed) {
            throw new ClosedChannelException();
        }
        return -1;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

