/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.image;

import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.storage.RangeArgument;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.internal.storage.image.WorldFileStore;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

class WorldFileResource
extends AbstractGridCoverageResource
implements StoreResource {
    static final int X_DIMENSION = 0;
    static final int Y_DIMENSION = 1;
    private volatile WorldFileStore store;
    private int imageIndex;
    private GenericName identifier;
    private GridGeometry gridGeometry;
    private List<SampleDimension> sampleDimensions;
    private SoftReference<GridCoverage> fullCoverage;

    WorldFileResource(WorldFileStore worldFileStore, StoreListeners storeListeners, int n, GridGeometry gridGeometry) {
        super(storeListeners, worldFileStore.isComponentHidden());
        this.store = worldFileStore;
        this.imageIndex = n;
        this.gridGeometry = gridGeometry;
    }

    @Override
    public final DataStore getOriginator() {
        return this.store;
    }

    final WorldFileStore store() throws DataStoreException {
        WorldFileStore worldFileStore = this.store;
        if (worldFileStore != null) {
            return worldFileStore;
        }
        throw new DataStoreException(Resources.format((short)73));
    }

    final int getImageIndex() {
        return this.imageIndex;
    }

    final void decrementImageIndex() throws DataStoreException {
        this.getIdentifier();
        --this.imageIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Optional<GenericName> getIdentifier() throws DataStoreException {
        WorldFileStore worldFileStore;
        WorldFileStore worldFileStore2 = worldFileStore = this.store();
        synchronized (worldFileStore2) {
            if (this.identifier == null) {
                String string;
                String string2 = string = String.valueOf(this.getImageIndex() + 1);
                int n = 0;
                while (worldFileStore.identifiers.putIfAbsent(string2, Boolean.TRUE) != null) {
                    if (--n >= 0) {
                        throw new ArithmeticException();
                    }
                    string2 = string + n;
                }
                String string3 = worldFileStore.getDisplayName();
                if (worldFileStore.suffix != null) {
                    string3 = IOUtilities.filenameWithoutExtension(string3);
                }
                this.identifier = Names.createLocalName(string3, null, string2).toFullyQualifiedName();
            }
            return Optional.of(this.identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GridGeometry getGridGeometry() throws DataStoreException {
        WorldFileStore worldFileStore = this.store();
        synchronized (worldFileStore) {
            return this.gridGeometry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<SampleDimension> getSampleDimensions() throws DataStoreException {
        WorldFileStore worldFileStore;
        WorldFileStore worldFileStore2 = worldFileStore = this.store();
        synchronized (worldFileStore2) {
            if (this.sampleDimensions == null) {
                try {
                    ImageReader imageReader = worldFileStore.reader();
                    ImageTypeSpecifier imageTypeSpecifier = imageReader.getRawImageType(this.getImageIndex());
                    SampleDimension[] sampleDimensionArray = new SampleDimension[imageTypeSpecifier.getNumBands()];
                    SampleDimension.Builder builder = new SampleDimension.Builder();
                    short[] sArray = ImageUtilities.bandNames(imageTypeSpecifier.getColorModel(), imageTypeSpecifier.getSampleModel());
                    for (int i = 0; i < sampleDimensionArray.length; ++i) {
                        short s;
                        InternationalString internationalString = i < sArray.length && (s = sArray[i]) != 0 ? Vocabulary.formatInternational(s) : Vocabulary.formatInternational((short)15, (Object)(i + 1));
                        sampleDimensionArray[i] = builder.setName(internationalString).build();
                        builder.clear();
                    }
                    this.sampleDimensions = UnmodifiableArrayList.wrap(sampleDimensionArray);
                }
                catch (IOException iOException) {
                    throw new DataStoreException(iOException);
                }
            }
            return this.sampleDimensions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GridCoverage read(GridGeometry gridGeometry, int ... nArray) throws DataStoreException {
        boolean bl = gridGeometry == null && nArray == null;
        WorldFileStore worldFileStore = this.store();
        try {
            WorldFileStore worldFileStore2 = worldFileStore;
            synchronized (worldFileStore2) {
                Object object;
                Object object2;
                UnmodifiableArrayList<SampleDimension> unmodifiableArrayList;
                Object object3;
                if (bl && this.fullCoverage != null) {
                    object3 = this.fullCoverage.get();
                    if (object3 != null) {
                        return object3;
                    }
                    this.fullCoverage = null;
                }
                object3 = worldFileStore.reader();
                ImageReadParam imageReadParam = ((ImageReader)object3).getDefaultReadParam();
                if (gridGeometry == null) {
                    gridGeometry = this.gridGeometry;
                } else {
                    unmodifiableArrayList = this.gridGeometry.derive().rounding(GridRoundingMode.ENCLOSING).subgrid(gridGeometry);
                    object2 = ((GridDerivation)((Object)unmodifiableArrayList)).getIntersection();
                    object = ((GridDerivation)((Object)unmodifiableArrayList)).getSubsampling();
                    int[] nArray2 = ((GridDerivation)((Object)unmodifiableArrayList)).getSubsamplingOffsets();
                    int n = object[0];
                    Object object4 = object[1];
                    Rectangle rectangle = new Rectangle(Math.toIntExact(((GridExtent)object2).getLow(0)), Math.toIntExact(((GridExtent)object2).getLow(1)), Math.toIntExact(((GridExtent)object2).getSize(0)), Math.toIntExact(((GridExtent)object2).getSize(1)));
                    gridGeometry = ((GridDerivation)((Object)unmodifiableArrayList)).build();
                    GridExtent gridExtent = gridGeometry.getExtent();
                    imageReadParam.setSourceRegion(rectangle);
                    imageReadParam.setSourceSubsampling(n, (int)object4, Math.toIntExact(gridExtent.getLow(0) * (long)n + (long)nArray2[0] - (long)rectangle.x), Math.toIntExact(gridExtent.getLow(1) * (long)object4 + (long)nArray2[1] - (long)rectangle.y));
                }
                unmodifiableArrayList = this.getSampleDimensions();
                if (nArray != null) {
                    object2 = ((ImageReader)object3).getRawImageType(this.getImageIndex());
                    object = RangeArgument.validate(((ImageTypeSpecifier)object2).getNumBands(), nArray, this.listeners);
                    if (((RangeArgument)object).isIdentity()) {
                        nArray = null;
                    } else {
                        unmodifiableArrayList = UnmodifiableArrayList.wrap(((RangeArgument)object).select((List<? extends SampleDimension>)unmodifiableArrayList));
                        if (((RangeArgument)object).hasAllBands || ((ImageTypeSpecifier)object2).getSampleModel() instanceof BandedSampleModel) {
                            nArray = ((RangeArgument)object).getSelectedBands();
                            imageReadParam.setSourceBands(nArray);
                            imageReadParam.setDestinationBands(ArraysExt.range(0, nArray.length));
                            nArray = null;
                        }
                    }
                }
                object2 = ((ImageReader)object3).readAsRenderedImage(this.getImageIndex(), imageReadParam);
                if (nArray != null) {
                    object2 = new ImageProcessor().selectBands((RenderedImage)object2, nArray);
                }
                object = new GridCoverage2D(gridGeometry, (List<? extends SampleDimension>)unmodifiableArrayList, (RenderedImage)object2);
                if (bl) {
                    this.fullCoverage = new SoftReference<Object>(object);
                }
                return object;
            }
        }
        catch (IOException | RuntimeException exception) {
            throw this.canNotRead(worldFileStore.getDisplayName(), gridGeometry, exception);
        }
    }

    final void setGridCoverage(GridCoverage gridCoverage) {
        this.sampleDimensions = gridCoverage.getSampleDimensions();
        this.gridGeometry = gridCoverage.getGridGeometry();
        this.fullCoverage = new SoftReference<GridCoverage>(gridCoverage);
    }

    final void dispose() {
        if (this.identifier != null) {
            this.store.identifiers.put(this.identifier.tip().toString(), Boolean.FALSE);
        }
        this.store = null;
        this.identifier = null;
        this.sampleDimensions = null;
        this.gridGeometry = null;
        this.fullCoverage = null;
    }
}

