/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.processing.isoline;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.util.Map;
import org.apache.sis.internal.processing.isoline.Fragments;

enum PolylineStage {
    BUFFER,
    FRAGMENT,
    FINAL;


    private Path2D destination(Map<PolylineStage, Path2D> map) {
        return map.computeIfAbsent(this, polylineStage -> new Path2D.Float());
    }

    final void add(Map<PolylineStage, Path2D> map, double[] dArray, int n) {
        int n2 = 0;
        if (n2 < n) {
            Path2D path2D = this.destination(map);
            path2D.moveTo(dArray[n2++], dArray[n2++]);
            while (n2 < n) {
                path2D.lineTo(dArray[n2++], dArray[n2++]);
            }
        }
    }

    final void add(Map<PolylineStage, Path2D> map, Map<?, Fragments> map2) {
        for (Fragments fragments : map2.values()) {
            for (double[] dArray : fragments) {
                if (dArray == null) continue;
                this.add(map, dArray, dArray.length);
            }
        }
    }

    final void add(Map<PolylineStage, Path2D> map, Shape shape) {
        if (shape != null) {
            this.destination(map).append(shape, false);
        }
    }
}

