/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.xml.XmlUtilities;

@XmlType(name="Date_PropertyType")
public class GO_Temporal
extends XmlAdapter<GO_Temporal, Temporal> {
    @XmlElement(name="DateTime")
    @XmlSchemaType(name="dateTime")
    private XMLGregorianCalendar dateTime;
    @XmlElement(name="Date")
    @XmlSchemaType(name="date")
    private XMLGregorianCalendar date;

    public GO_Temporal() {
    }

    private GO_Temporal(Temporal temporal) {
        Context context = Context.current();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = XmlUtilities.toXML(context, temporal);
            if (xMLGregorianCalendar.getMillisecond() == 0) {
                xMLGregorianCalendar.setMillisecond(Integer.MIN_VALUE);
            }
            if (Context.isFlagSet(context, 32) && !temporal.isSupported(ChronoField.HOUR_OF_DAY)) {
                this.date = xMLGregorianCalendar;
                return;
            }
            this.dateTime = xMLGregorianCalendar;
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            Context.warningOccured(context, XmlAdapter.class, "marshal", datatypeConfigurationException, true);
        }
    }

    private Temporal getDate() {
        return XmlUtilities.toTemporal(Context.current(), this.dateTime != null ? this.dateTime : this.date);
    }

    @Override
    public final Temporal unmarshal(GO_Temporal gO_Temporal) {
        return gO_Temporal != null ? gO_Temporal.getDate() : null;
    }

    @Override
    public GO_Temporal marshal(Temporal temporal) {
        return temporal != null ? new GO_Temporal(temporal) : null;
    }

    public static final class Since2014
    extends GO_Temporal {
        @Override
        public GO_Temporal marshal(Temporal temporal) {
            return FilterByVersion.CURRENT_METADATA.accept() ? super.marshal(temporal) : null;
        }
    }
}

