/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ImagingOpException;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class ResamplingGrid
extends AbstractMathTransform2D {
    private static final int MIN_TILE_SIZE = 4;
    static final double TOLERANCE = 0.125;
    private static final Cache<Key, MathTransform2D> CACHE = new Cache<Key, MathTransform2D>(12, 32768L, false){

        @Override
        protected int cost(MathTransform2D mathTransform2D) {
            if (mathTransform2D instanceof ResamplingGrid) {
                return ((ResamplingGrid)mathTransform2D).coordinates.length;
            }
            return 50;
        }
    };
    final int numXTiles;
    final int numYTiles;
    private final double tileWidth;
    private final double tileHeight;
    private final double xmin;
    private final double ymin;
    private final double[] coordinates;

    ResamplingGrid(MathTransform2D mathTransform2D, Rectangle rectangle, Dimension dimension) throws TransformException {
        this.xmin = rectangle.x;
        this.ymin = rectangle.y;
        this.tileWidth = Math.scalb(rectangle.width, -dimension.width);
        this.tileHeight = Math.scalb(rectangle.height, -dimension.height);
        this.numXTiles = 1 << dimension.width;
        this.numYTiles = 1 << dimension.height;
        this.coordinates = new double[(this.numXTiles + 1) * (this.numYTiles + 1) * 2];
        int n = 0;
        for (int i = 0; i <= this.numYTiles; ++i) {
            for (int j = 0; j <= this.numXTiles; ++j) {
                this.coordinates[n++] = j;
                this.coordinates[n++] = i;
            }
        }
        mathTransform2D = MathTransforms.concatenate(new AffineTransform2D(this.tileWidth, 0.0, 0.0, this.tileHeight, this.xmin, this.ymin), mathTransform2D);
        mathTransform2D.transform(this.coordinates, 0, this.coordinates, 0, n / 2);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        if (bl) {
            throw new TransformException(Errors.format((short)162, "derivative"));
        }
        this.transform(dArray, n, dArray2, n2, 1);
        return null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (n < n2 && dArray == dArray2 && n3 > 1) {
            super.transform(dArray, n, dArray2, n2, n3);
            return;
        }
        int n4 = this.numXTiles + 1;
        while (--n3 >= 0) {
            double d = (dArray[n++] - this.xmin) / this.tileWidth;
            double d2 = (dArray[n++] - this.ymin) / this.tileHeight;
            double d3 = Math.floor(d);
            d -= d3;
            double d4 = Math.floor(d2);
            d2 -= d4;
            int n5 = (int)d3;
            int n6 = (int)d4;
            if (n5 < 0 || n5 >= this.numXTiles || n6 < 0 || n6 >= this.numYTiles) {
                throw new TransformException(Errors.format((short)119));
            }
            int n7 = (n5 + n6 * n4) * 2;
            int n8 = n7 + 2;
            int n9 = n7 + 2 * n4;
            int n10 = n9 + 2;
            double d5 = 1.0 - d;
            double d6 = 1.0 - d2;
            dArray2[n2++] = d6 * (d5 * this.coordinates[n7] + d * this.coordinates[n8]) + d2 * (d5 * this.coordinates[n9] + d * this.coordinates[n10]);
            dArray2[n2++] = d6 * (d5 * this.coordinates[n7 | 1] + d * this.coordinates[n8 | 1]) + d2 * (d5 * this.coordinates[n9 | 1] + d * this.coordinates[n10 | 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MathTransform2D getOrCreate(MathTransform2D mathTransform2D, Rectangle rectangle) throws TransformException {
        Key key = new Key(mathTransform2D, rectangle);
        MathTransform2D mathTransform2D2 = CACHE.peek(key);
        if (mathTransform2D2 == null) {
            Cache.Handler<MathTransform2D> handler = CACHE.lock(key);
            try {
                mathTransform2D2 = handler.peek();
                if (mathTransform2D2 == null) {
                    mathTransform2D2 = ResamplingGrid.create(mathTransform2D, rectangle);
                }
            }
            finally {
                handler.putAndUnlock(mathTransform2D2);
            }
        }
        return mathTransform2D2;
    }

    static MathTransform2D create(MathTransform2D mathTransform2D, Rectangle rectangle) throws TransformException {
        Dimension dimension;
        block3: {
            MathTransform2D mathTransform2D2 = (MathTransform2D)MathTransforms.concatenate(MathTransforms.translation(-0.5, -0.5), (MathTransform)mathTransform2D, MathTransforms.translation(0.5, 0.5));
            double d = rectangle.getMinX();
            double d2 = rectangle.getMaxX();
            double d3 = rectangle.getMinY();
            double d4 = rectangle.getMaxY();
            Point2D.Double double_ = new Point2D.Double();
            double_.x = d;
            double_.y = d4;
            Matrix2 matrix2 = ResamplingGrid.derivative(mathTransform2D2, double_);
            double_.x = d2;
            double_.y = d4;
            Matrix2 matrix22 = ResamplingGrid.derivative(mathTransform2D2, double_);
            double_.x = d;
            double_.y = d3;
            Matrix2 matrix23 = ResamplingGrid.derivative(mathTransform2D2, double_);
            double_.x = d2;
            double_.y = d3;
            Matrix2 matrix24 = ResamplingGrid.derivative(mathTransform2D2, double_);
            dimension = ResamplingGrid.depth(mathTransform2D2, double_, new Point2D.Double(0.25 / (d2 - d), 0.25 / (d4 - d3)), d, d2, d3, d4, matrix2, matrix22, matrix23, matrix24);
            if (dimension.width == 0 && dimension.height == 0) {
                double d5 = rectangle.getCenterX();
                double d6 = rectangle.getCenterY();
                double_.x = d2;
                double_.y = d6;
                Point2D point2D = mathTransform2D.transform(double_, double_);
                double d7 = point2D.getX();
                double d8 = point2D.getY();
                double_.x = d;
                double_.y = d6;
                point2D = mathTransform2D.transform(double_, double_);
                d7 -= point2D.getX();
                d8 -= point2D.getY();
                double_.x = d5;
                double_.y = d4;
                point2D = mathTransform2D.transform(double_, double_);
                double d9 = point2D.getX();
                double d10 = point2D.getY();
                double_.x = d5;
                double_.y = d3;
                point2D = mathTransform2D.transform(double_, double_);
                d9 -= point2D.getX();
                d10 -= point2D.getY();
                double_.x = d5;
                double_.y = d6;
                point2D = mathTransform2D.transform(double_, double_);
                double d11 = rectangle.getWidth();
                double d12 = rectangle.getHeight();
                AffineTransform affineTransform = new AffineTransform(d7 / d11, d8 / d11, d9 / d12, d10 / d12, point2D.getX(), point2D.getY());
                affineTransform.translate(-d5, -d6);
                point2D = null;
                for (int i = 0; i < 4; ++i) {
                    double_.x = (i & 1) == 0 ? d : d2;
                    double_.y = (i & 2) == 0 ? d3 : d4;
                    point2D = affineTransform.transform(double_, point2D);
                    Point2D point2D2 = mathTransform2D.transform(double_, double_);
                    if (Math.abs(point2D.getX() - point2D2.getX()) <= 0.125 && Math.abs(point2D.getY() - point2D2.getY()) <= 0.125) {
                        continue;
                    }
                    break block3;
                }
                return new AffineTransform2D(affineTransform);
            }
        }
        return new ResamplingGrid(mathTransform2D, rectangle, dimension);
    }

    private static Dimension depth(MathTransform2D mathTransform2D, Point2D.Double double_, Point2D.Double double_2, double d, double d2, double d3, double d4, Matrix2 matrix2, Matrix2 matrix22, Matrix2 matrix23, Matrix2 matrix24) throws TransformException {
        Dimension dimension;
        if (!(d2 - d >= 4.0) || !(d4 - d3 >= 4.0)) {
            throw new ImagingOpException(null);
        }
        double d5 = double_2.x;
        double d6 = double_2.y;
        double_2.x *= 2.0;
        double_2.y *= 2.0;
        double d7 = double_.x = 0.5 * (d + d2);
        double d8 = double_.y = 0.5 * (d3 + d4);
        Matrix2 matrix25 = Matrix2.castOrCopy(mathTransform2D.derivative(double_));
        double_.x = d;
        double_.y = d8;
        Matrix2 matrix26 = ResamplingGrid.derivative(mathTransform2D, double_);
        double_.x = d2;
        double_.y = d8;
        Matrix2 matrix27 = ResamplingGrid.derivative(mathTransform2D, double_);
        double_.x = d7;
        double_.y = d3;
        Matrix2 matrix28 = ResamplingGrid.derivative(mathTransform2D, double_);
        double_.x = d7;
        double_.y = d4;
        Matrix2 matrix29 = ResamplingGrid.derivative(mathTransform2D, double_);
        boolean bl = ResamplingGrid.equals(matrix25, matrix26, double_2);
        boolean bl2 = ResamplingGrid.equals(matrix25, matrix27, double_2);
        boolean bl3 = ResamplingGrid.equals(matrix25, matrix28, double_2);
        boolean bl4 = ResamplingGrid.equals(matrix25, matrix29, double_2);
        int n = 0;
        int n2 = 0;
        if (!(bl & bl4) || !ResamplingGrid.equals(matrix25, matrix2, double_2)) {
            dimension = ResamplingGrid.depth(mathTransform2D, double_, double_2, d, d7, d8, d4, matrix2, matrix29, matrix26, matrix25);
            ResamplingGrid.incrementNonAffineDimension(bl, bl4, dimension);
            n = dimension.width;
            n2 = dimension.height;
        }
        if (!(bl2 & bl4) || !ResamplingGrid.equals(matrix25, matrix22, double_2)) {
            dimension = ResamplingGrid.depth(mathTransform2D, double_, double_2, d7, d2, d8, d4, matrix29, matrix22, matrix25, matrix27);
            ResamplingGrid.incrementNonAffineDimension(bl2, bl4, dimension);
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        if (!(bl & bl3) || !ResamplingGrid.equals(matrix25, matrix23, double_2)) {
            dimension = ResamplingGrid.depth(mathTransform2D, double_, double_2, d, d7, d3, d8, matrix26, matrix25, matrix23, matrix28);
            ResamplingGrid.incrementNonAffineDimension(bl, bl3, dimension);
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        if (!(bl2 & bl3) || !ResamplingGrid.equals(matrix25, matrix24, double_2)) {
            dimension = ResamplingGrid.depth(mathTransform2D, double_, double_2, d7, d2, d3, d8, matrix25, matrix27, matrix28, matrix24);
            ResamplingGrid.incrementNonAffineDimension(bl2, bl3, dimension);
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        double_2.x = d5;
        double_2.y = d6;
        return new Dimension(n, n2);
    }

    private static void incrementNonAffineDimension(boolean bl, boolean bl2, Dimension dimension) {
        if (bl == bl2) {
            ++dimension.width;
            ++dimension.height;
        } else if (bl2) {
            ++dimension.width;
        } else {
            ++dimension.height;
        }
    }

    private static Matrix2 derivative(MathTransform2D mathTransform2D, Point2D point2D) throws TransformException {
        return Matrix2.castOrCopy(mathTransform2D.derivative(point2D));
    }

    private static boolean equals(Matrix2 matrix2, Matrix2 matrix22, Point2D.Double double_) {
        return Math.abs(matrix2.m00 - matrix22.m00) + Math.abs(matrix2.m01 - matrix22.m01) <= double_.x && Math.abs(matrix2.m10 - matrix22.m10) + Math.abs(matrix2.m11 - matrix22.m11) <= double_.y;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        formatter.append(this.numXTiles);
        formatter.append(this.numYTiles);
        formatter.setInvalidWKT(ResamplingGrid.class, null);
        return "ResamplingGrid";
    }

    private static final class Key {
        private final MathTransform2D toSourceCenter;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        Key(MathTransform2D mathTransform2D, Rectangle rectangle) {
            this.toSourceCenter = mathTransform2D;
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = rectangle.width;
            this.height = rectangle.height;
        }

        public int hashCode() {
            return (this.x * 31 + this.y * 31 + this.width) * 31 + this.height + this.toSourceCenter.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.x == key.x && this.y == key.y && this.width == key.width && this.height == key.height && this.toSourceCenter.equals(key.toSourceCenter);
            }
            return false;
        }
    }
}

