/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

public abstract class AbstractDirectPosition
extends FormattableObject
implements DirectPosition {
    protected AbstractDirectPosition() {
    }

    public static AbstractDirectPosition castOrCopy(DirectPosition directPosition) {
        if (directPosition == null || directPosition instanceof AbstractDirectPosition) {
            return (AbstractDirectPosition)directPosition;
        }
        return new GeneralDirectPosition(directPosition);
    }

    @Override
    public final DirectPosition getDirectPosition() {
        return this;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    @Override
    public double[] getCoordinate() {
        double[] dArray = new double[this.getDimension()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getOrdinate(i);
        }
        return dArray;
    }

    @Override
    public void setOrdinate(int n, double d) {
        throw new UnsupportedOperationException(Errors.format((short)153, this.getClass()));
    }

    public void setLocation(DirectPosition directPosition) throws MismatchedDimensionException, MismatchedReferenceSystemException {
        int n = this.getDimension();
        if (directPosition != null) {
            CoordinateReferenceSystem coordinateReferenceSystem;
            ArgumentChecks.ensureDimensionMatches("position", n, directPosition);
            CoordinateReferenceSystem coordinateReferenceSystem2 = this.getCoordinateReferenceSystem();
            if (coordinateReferenceSystem2 != null && (coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem()) != null && !Utilities.equalsIgnoreMetadata(coordinateReferenceSystem2, coordinateReferenceSystem)) {
                throw new MismatchedReferenceSystemException(Errors.format((short)78));
            }
            for (int i = 0; i < n; ++i) {
                this.setOrdinate(i, directPosition.getOrdinate(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.setOrdinate(i, Double.NaN);
            }
        }
    }

    public boolean normalize() {
        boolean bl = false;
        CoordinateReferenceSystem coordinateReferenceSystem = this.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null) {
            int n = this.getDimension();
            CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
            for (int i = 0; i < n; ++i) {
                double d = this.getOrdinate(i);
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
                double d2 = coordinateSystemAxis.getMinimumValue();
                double d3 = coordinateSystemAxis.getMaximumValue();
                RangeMeaning rangeMeaning = coordinateSystemAxis.getRangeMeaning();
                if (RangeMeaning.EXACT.equals(rangeMeaning)) {
                    if (d < d2) {
                        d = d2;
                    } else {
                        if (!(d > d3)) continue;
                        d = d3;
                    }
                } else if (RangeMeaning.WRAPAROUND.equals(rangeMeaning)) {
                    double d4 = d3 - d2;
                    double d5 = Math.floor((d - d2) / d4) * d4;
                    if (d5 == 0.0) continue;
                    d -= d5;
                }
                this.setOrdinate(i, d);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Vector[] vectorArray = new Vector[]{Vector.create(this.getCoordinate())};
        formatter.append(vectorArray, WKTUtilities.suggestFractionDigits(this.getCoordinateReferenceSystem(), vectorArray));
        return "Point";
    }

    @Override
    public String toString() {
        return AbstractDirectPosition.toString(this, false);
    }

    static String toString(DirectPosition directPosition, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(32).append("POINT");
        int n = directPosition.getDimension();
        if (n == 0) {
            stringBuilder.append("()");
        } else {
            int n2 = 40;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append((char)n2);
                double d = directPosition.getOrdinate(i);
                if (bl) {
                    stringBuilder.append((float)d);
                } else {
                    stringBuilder.append(d);
                }
                StringBuilders.trimFractionalPart(stringBuilder);
                n2 = 32;
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    static double[] parse(CharSequence charSequence) throws NumberFormatException, IllegalArgumentException {
        int n;
        int n2;
        int n3 = CharSequences.skipTrailingWhitespaces(charSequence, 0, charSequence.length());
        int n4 = CharSequences.skipLeadingWhitespaces(charSequence, 0, n3);
        while (true) {
            if (n4 >= n3) {
                return null;
            }
            n2 = Character.codePointAt(charSequence, n4);
            if (Character.isUnicodeIdentifierStart(n2)) {
                do {
                    if ((n4 += Character.charCount(n2)) < n3) continue;
                    return null;
                } while (Character.isUnicodeIdentifierPart(n2 = Character.codePointAt(charSequence, n4)));
            }
            if (!Character.isSpaceChar(n2)) break;
            n4 += Character.charCount(n2);
        }
        if (n2 == 40 || n2 == 91) {
            n4 += Character.charCount(n2);
            char c = n2 == 40 ? (char)')' : ']';
            n = CharSequences.lastIndexOf(charSequence, c, n4 = CharSequences.skipLeadingWhitespaces(charSequence, n4, n3), n3);
            if (n != --n3) {
                Object[] objectArray;
                short s;
                if (n < 0) {
                    s = 101;
                    objectArray = new Object[]{charSequence, Character.valueOf(c)};
                } else {
                    s = 155;
                    objectArray = new Object[]{"POINT", charSequence, CharSequences.trimWhitespaces(charSequence, n + 1, n3 + 1)};
                }
                throw new IllegalArgumentException(Errors.format(s, objectArray));
            }
            n2 = Character.codePointAt(charSequence, n4);
        }
        double[] dArray = new double[2];
        n = 0;
        block2: while (n4 < n3) {
            int n5 = n4;
            do {
                if ((n4 += Character.charCount(n2)) < n3) continue;
                n2 = 0;
                break;
            } while (!Character.isSpaceChar(n2 = Character.codePointAt(charSequence, n4)));
            double d = Double.parseDouble(charSequence.subSequence(n5, n4).toString());
            if (n == dArray.length) {
                dArray = Arrays.copyOf(dArray, n * 2);
            }
            dArray[n++] = d;
            while (Character.isSpaceChar(n2)) {
                if ((n4 += Character.charCount(n2)) >= n3) break block2;
                n2 = Character.codePointAt(charSequence, n4);
            }
        }
        return ArraysExt.resize(dArray, n);
    }

    @Override
    public int hashCode() {
        int n = this.getDimension();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + Double.hashCode(this.getOrdinate(i));
        }
        return n2 + Objects.hashCode(this.getCoordinateReferenceSystem());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DirectPosition) {
            DirectPosition directPosition = (DirectPosition)object;
            int n = this.getDimension();
            if (n == directPosition.getDimension()) {
                for (int i = 0; i < n; ++i) {
                    if (Numerics.equals(this.getOrdinate(i), directPosition.getOrdinate(i))) continue;
                    return false;
                }
                if (Objects.equals(this.getCoordinateReferenceSystem(), directPosition.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == directPosition.hashCode()) : this;
                    return true;
                }
            }
        }
        return false;
    }
}

