/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.List;
import java.util.Locale;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.DataType;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Vocabulary;

abstract class DerivedGridCoverage
extends GridCoverage {
    protected final GridCoverage source;

    DerivedGridCoverage(GridCoverage gridCoverage, GridGeometry gridGeometry) {
        super(gridCoverage, gridGeometry);
        this.source = gridCoverage;
    }

    DerivedGridCoverage(GridCoverage gridCoverage, List<? extends SampleDimension> list) {
        super(gridCoverage.getGridGeometry(), list);
        this.source = gridCoverage;
    }

    boolean IsNotRepleacable() {
        return false;
    }

    @Override
    DataType getBandType() {
        return this.source.getBandType();
    }

    @Override
    public GridCoverage.Evaluator evaluator() {
        return this.source.evaluator();
    }

    @Override
    public TreeTable toTree(Locale locale, int n) {
        TreeTable treeTable = super.toTree(locale, n);
        TreeTable.Node node = treeTable.getRoot().newChild();
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        TableColumn<CharSequence> tableColumn = TableColumn.VALUE_AS_TEXT;
        node.setValue(tableColumn, vocabulary.getString((short)182));
        node.newChild().setValue(tableColumn, DerivedGridCoverage.summary(this.source));
        return treeTable;
    }

    private static String summary(GridCoverage gridCoverage) {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(gridCoverage));
        GridExtent gridExtent = gridCoverage.gridGeometry.extent;
        if (gridExtent != null) {
            stringBuilder.append('[');
            int n = gridExtent.getDimension();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuilder.append(" \u00d7 ");
                }
                stringBuilder.append(GridExtent.toSizeString(gridExtent.getHigh(i) - gridExtent.getLow(i) + 1L));
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }
}

