/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import jakarta.mail.BodyPart;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.util.Store;

public class ReadSignedMail {
    private static final String BC = "BC";

    private static void verify(SMIMESigned sMIMESigned) throws Exception {
        Store<X509CertificateHolder> store = sMIMESigned.getCertificates();
        SignerInformationStore signerInformationStore = sMIMESigned.getSignerInfos();
        Collection<SignerInformation> collection = signerInformationStore.getSigners();
        for (SignerInformation signerInformation : collection) {
            Collection<X509CertificateHolder> collection2 = store.getMatches(signerInformation.getSID());
            Iterator<X509CertificateHolder> iterator = collection2.iterator();
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(BC).getCertificate(iterator.next());
            if (signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(x509Certificate))) {
                System.out.println("signature verified");
                continue;
            }
            System.out.println("signature failed!");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)properties, null);
        MimeMessage mimeMessage = new MimeMessage(session, (InputStream)new FileInputStream("signed.message"));
        if (mimeMessage.isMimeType("multipart/signed")) {
            SMIMESigned sMIMESigned = new SMIMESigned((MimeMultipart)mimeMessage.getContent());
            MimeBodyPart mimeBodyPart = sMIMESigned.getContent();
            System.out.println("Content:");
            Object object = mimeBodyPart.getContent();
            if (object instanceof String) {
                System.out.println((String)object);
            } else if (object instanceof Multipart) {
                Multipart multipart = (Multipart)object;
                int n = multipart.getCount();
                for (int i = 0; i < n; ++i) {
                    BodyPart bodyPart = multipart.getBodyPart(i);
                    Object object2 = bodyPart.getContent();
                    System.out.println("Part " + i);
                    System.out.println("---------------------------");
                    if (object2 instanceof String) {
                        System.out.println((String)object2);
                        continue;
                    }
                    System.out.println("can't print...");
                }
            }
            System.out.println("Status:");
            ReadSignedMail.verify(sMIMESigned);
        } else if (mimeMessage.isMimeType("application/pkcs7-mime") || mimeMessage.isMimeType("application/x-pkcs7-mime")) {
            SMIMESigned sMIMESigned = new SMIMESigned((Part)mimeMessage);
            MimeBodyPart mimeBodyPart = sMIMESigned.getContent();
            System.out.println("Content:");
            Object object = mimeBodyPart.getContent();
            if (object instanceof String) {
                System.out.println((String)object);
            }
            System.out.println("Status:");
            ReadSignedMail.verify(sMIMESigned);
        } else {
            System.err.println("Not a signed message!");
        }
    }
}

