/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geo.topic.gazetteer;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.tika.parser.geo.topic.GeoParserConfig;
import org.apache.tika.parser.geo.topic.gazetteer.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoGazetteerClient {
    private static final String SEARCH_API = "/api/search";
    private static final String SEARCH_PARAM = "s";
    private static final String PING = "/api/ping";
    private static final Logger LOG = LoggerFactory.getLogger(GeoGazetteerClient.class);
    private String url;

    public GeoGazetteerClient(String url) {
        this.url = url;
    }

    public GeoGazetteerClient(GeoParserConfig config) {
        this.url = config.getGazetteerRestEndpoint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, List<Location>> getLocations(List<String> locations) {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            URIBuilder uri = new URIBuilder(this.url + SEARCH_API);
            for (String loc : locations) {
                uri.addParameter(SEARCH_PARAM, loc);
            }
            HttpGet httpGet = new HttpGet(uri.build());
            CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpGet);
            String respJson = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            Type typeDef = new TypeToken<Map<String, List<Location>>>(){}.getType();
            Map map = (Map)new Gson().fromJson(respJson, typeDef);
            return map;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkAvail() {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            HttpGet httpGet = new HttpGet(this.url + PING);
            CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpGet);
            if (resp.getStatusLine().getStatusCode() != 200) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

