/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.io.EndianUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Photoshop;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.xmp.JempboxExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PSDParser
extends AbstractParser {
    private static final long serialVersionUID = 883387734607994914L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Collections.singletonList(MediaType.image((String)"vnd.adobe.photoshop"))));
    private static final int MAX_DATA_LENGTH_BYTES = 10000000;
    private static final int MAX_BLOCKS = 10000;
    private int maxDataLengthBytes = 10000000;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        byte[] signature = new byte[4];
        IOUtils.readFully((InputStream)stream, (byte[])signature);
        if (signature[0] != 56 || signature[1] != 66 || signature[2] != 80 || signature[3] != 83) {
            throw new TikaException("PSD/PSB magic signature invalid");
        }
        int version = EndianUtils.readUShortBE((InputStream)stream);
        if (version != 1 && version != 2) {
            throw new TikaException("Invalid PSD/PSB version " + version);
        }
        IOUtils.readFully((InputStream)stream, (byte[])new byte[6]);
        int numChannels = EndianUtils.readUShortBE((InputStream)stream);
        int height = EndianUtils.readIntBE((InputStream)stream);
        int width = EndianUtils.readIntBE((InputStream)stream);
        metadata.set(TIFF.IMAGE_LENGTH, height);
        metadata.set(TIFF.IMAGE_WIDTH, width);
        int depth = EndianUtils.readUShortBE((InputStream)stream);
        metadata.set(TIFF.BITS_PER_SAMPLE, Integer.toString(depth));
        int colorMode = EndianUtils.readUShortBE((InputStream)stream);
        if (colorMode < Photoshop._COLOR_MODE_CHOICES_INDEXED.length) {
            metadata.set(Photoshop.COLOR_MODE, Photoshop._COLOR_MODE_CHOICES_INDEXED[colorMode]);
        }
        long colorModeSectionSize = EndianUtils.readIntBE((InputStream)stream);
        IOUtils.skipFully((InputStream)stream, (long)colorModeSectionSize);
        long imageResourcesSectionSize = EndianUtils.readIntBE((InputStream)stream);
        long read = 0L;
        for (int blocks = 0; read < imageResourcesSectionSize && blocks < 10000; ++blocks) {
            ResourceBlock rb = new ResourceBlock(stream, this.maxDataLengthBytes);
            if (rb.totalLength <= 0) {
                // empty if block
            }
            read += (long)rb.totalLength;
            if (rb.id == 1008) {
                metadata.add(TikaCoreProperties.DESCRIPTION, rb.getDataAsString());
                continue;
            }
            if (rb.id == 1058 || rb.id == 1059 || rb.id != 1060) continue;
            JempboxExtractor ex = new JempboxExtractor(metadata);
            ex.parse((InputStream)UnsynchronizedByteArrayInputStream.builder().setByteArray(rb.data).get());
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }

    @Field
    public void setMaxDataLengthBytes(int maxDataLengthBytes) {
        this.maxDataLengthBytes = maxDataLengthBytes;
    }

    public int getMaxDataLengthBytes() {
        return this.maxDataLengthBytes;
    }

    private static class ResourceBlock {
        private static final long SIGNATURE = 943868237L;
        private static final int ID_CAPTION = 1008;
        private static final int ID_EXIF_1 = 1058;
        private static final int ID_EXIF_3 = 1059;
        private static final int ID_XMP = 1060;
        private static final int ID_URL = 1035;
        private static final int ID_AUTO_SAVE_FILE_PATH = 1086;
        private static final int ID_THUMBNAIL_RESOURCE = 1036;
        static int counter = 0;
        private final int maxDataLengthBytes;
        private int id;
        private String name;
        private byte[] data;
        private int totalLength;

        private ResourceBlock(InputStream stream, int maxDataLengthBytes) throws IOException, TikaException {
            int dataLen;
            this.maxDataLengthBytes = maxDataLengthBytes;
            ++counter;
            long sig = EndianUtils.readIntBE((InputStream)stream);
            if (sig != 943868237L) {
                throw new TikaException("Invalid Image Resource Block Signature Found, got " + sig + " 0x" + Long.toHexString(sig) + " but the spec defines " + 943868237L);
            }
            this.id = EndianUtils.readUShortBE((InputStream)stream);
            StringBuilder nameB = new StringBuilder();
            int nameLen = 0;
            while (true) {
                int v;
                if ((v = stream.read()) < 0) {
                    throw new EOFException();
                }
                ++nameLen;
                if (v == 0) {
                    if (nameLen % 2 != 1) break;
                    stream.read();
                    ++nameLen;
                    break;
                }
                nameB.append((char)v);
                this.name = nameB.toString();
            }
            if ((dataLen = EndianUtils.readIntBE((InputStream)stream)) < 0) {
                throw new TikaException("data length must be >= 0: " + dataLen);
            }
            if (dataLen % 2 == 1) {
                ++dataLen;
            }
            if (Integer.MAX_VALUE - dataLen < nameLen + 10) {
                throw new TikaException("data length is too long:" + dataLen);
            }
            this.totalLength = 6 + nameLen + 4 + dataLen;
            if (ResourceBlock.captureData(this.id)) {
                if (dataLen > maxDataLengthBytes) {
                    throw new TikaMemoryLimitException("data length must be < " + maxDataLengthBytes + ": " + dataLen);
                }
                this.data = new byte[dataLen];
                IOUtils.readFully((InputStream)stream, (byte[])this.data);
            } else {
                this.data = new byte[0];
                IOUtils.skipFully((InputStream)stream, (long)dataLen);
            }
        }

        private static boolean captureData(int id) {
            switch (id) {
                case 1008: 
                case 1058: 
                case 1059: 
                case 1060: {
                    return true;
                }
            }
            return false;
        }

        private String getDataAsString() {
            return new String(this.data, 0, this.data.length - 1, StandardCharsets.US_ASCII);
        }
    }
}

