package org.apache.tika;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * The Tika Grpc Service definition
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.73.0)",
    comments = "Source: tika.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class TikaGrpc {

  private TikaGrpc() {}

  public static final java.lang.String SERVICE_NAME = "tika.Tika";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<org.apache.tika.SaveFetcherRequest,
      org.apache.tika.SaveFetcherReply> getSaveFetcherMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SaveFetcher",
      requestType = org.apache.tika.SaveFetcherRequest.class,
      responseType = org.apache.tika.SaveFetcherReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.apache.tika.SaveFetcherRequest,
      org.apache.tika.SaveFetcherReply> getSaveFetcherMethod() {
    io.grpc.MethodDescriptor<org.apache.tika.SaveFetcherRequest, org.apache.tika.SaveFetcherReply> getSaveFetcherMethod;
    if ((getSaveFetcherMethod = TikaGrpc.getSaveFetcherMethod) == null) {
      synchronized (TikaGrpc.class) {
        if ((getSaveFetcherMethod = TikaGrpc.getSaveFetcherMethod) == null) {
          TikaGrpc.getSaveFetcherMethod = getSaveFetcherMethod =
              io.grpc.MethodDescriptor.<org.apache.tika.SaveFetcherRequest, org.apache.tika.SaveFetcherReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SaveFetcher"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.SaveFetcherRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.SaveFetcherReply.getDefaultInstance()))
              .setSchemaDescriptor(new TikaMethodDescriptorSupplier("SaveFetcher"))
              .build();
        }
      }
    }
    return getSaveFetcherMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.tika.GetFetcherRequest,
      org.apache.tika.GetFetcherReply> getGetFetcherMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetFetcher",
      requestType = org.apache.tika.GetFetcherRequest.class,
      responseType = org.apache.tika.GetFetcherReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.apache.tika.GetFetcherRequest,
      org.apache.tika.GetFetcherReply> getGetFetcherMethod() {
    io.grpc.MethodDescriptor<org.apache.tika.GetFetcherRequest, org.apache.tika.GetFetcherReply> getGetFetcherMethod;
    if ((getGetFetcherMethod = TikaGrpc.getGetFetcherMethod) == null) {
      synchronized (TikaGrpc.class) {
        if ((getGetFetcherMethod = TikaGrpc.getGetFetcherMethod) == null) {
          TikaGrpc.getGetFetcherMethod = getGetFetcherMethod =
              io.grpc.MethodDescriptor.<org.apache.tika.GetFetcherRequest, org.apache.tika.GetFetcherReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetFetcher"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.GetFetcherRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.GetFetcherReply.getDefaultInstance()))
              .setSchemaDescriptor(new TikaMethodDescriptorSupplier("GetFetcher"))
              .build();
        }
      }
    }
    return getGetFetcherMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.tika.ListFetchersRequest,
      org.apache.tika.ListFetchersReply> getListFetchersMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListFetchers",
      requestType = org.apache.tika.ListFetchersRequest.class,
      responseType = org.apache.tika.ListFetchersReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.apache.tika.ListFetchersRequest,
      org.apache.tika.ListFetchersReply> getListFetchersMethod() {
    io.grpc.MethodDescriptor<org.apache.tika.ListFetchersRequest, org.apache.tika.ListFetchersReply> getListFetchersMethod;
    if ((getListFetchersMethod = TikaGrpc.getListFetchersMethod) == null) {
      synchronized (TikaGrpc.class) {
        if ((getListFetchersMethod = TikaGrpc.getListFetchersMethod) == null) {
          TikaGrpc.getListFetchersMethod = getListFetchersMethod =
              io.grpc.MethodDescriptor.<org.apache.tika.ListFetchersRequest, org.apache.tika.ListFetchersReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListFetchers"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.ListFetchersRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.ListFetchersReply.getDefaultInstance()))
              .setSchemaDescriptor(new TikaMethodDescriptorSupplier("ListFetchers"))
              .build();
        }
      }
    }
    return getListFetchersMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.tika.DeleteFetcherRequest,
      org.apache.tika.DeleteFetcherReply> getDeleteFetcherMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteFetcher",
      requestType = org.apache.tika.DeleteFetcherRequest.class,
      responseType = org.apache.tika.DeleteFetcherReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.apache.tika.DeleteFetcherRequest,
      org.apache.tika.DeleteFetcherReply> getDeleteFetcherMethod() {
    io.grpc.MethodDescriptor<org.apache.tika.DeleteFetcherRequest, org.apache.tika.DeleteFetcherReply> getDeleteFetcherMethod;
    if ((getDeleteFetcherMethod = TikaGrpc.getDeleteFetcherMethod) == null) {
      synchronized (TikaGrpc.class) {
        if ((getDeleteFetcherMethod = TikaGrpc.getDeleteFetcherMethod) == null) {
          TikaGrpc.getDeleteFetcherMethod = getDeleteFetcherMethod =
              io.grpc.MethodDescriptor.<org.apache.tika.DeleteFetcherRequest, org.apache.tika.DeleteFetcherReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteFetcher"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.DeleteFetcherRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.DeleteFetcherReply.getDefaultInstance()))
              .setSchemaDescriptor(new TikaMethodDescriptorSupplier("DeleteFetcher"))
              .build();
        }
      }
    }
    return getDeleteFetcherMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.tika.FetchAndParseRequest,
      org.apache.tika.FetchAndParseReply> getFetchAndParseMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "FetchAndParse",
      requestType = org.apache.tika.FetchAndParseRequest.class,
      responseType = org.apache.tika.FetchAndParseReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.apache.tika.FetchAndParseRequest,
      org.apache.tika.FetchAndParseReply> getFetchAndParseMethod() {
    io.grpc.MethodDescriptor<org.apache.tika.FetchAndParseRequest, org.apache.tika.FetchAndParseReply> getFetchAndParseMethod;
    if ((getFetchAndParseMethod = TikaGrpc.getFetchAndParseMethod) == null) {
      synchronized (TikaGrpc.class) {
        if ((getFetchAndParseMethod = TikaGrpc.getFetchAndParseMethod) == null) {
          TikaGrpc.getFetchAndParseMethod = getFetchAndParseMethod =
              io.grpc.MethodDescriptor.<org.apache.tika.FetchAndParseRequest, org.apache.tika.FetchAndParseReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "FetchAndParse"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.FetchAndParseRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.FetchAndParseReply.getDefaultInstance()))
              .setSchemaDescriptor(new TikaMethodDescriptorSupplier("FetchAndParse"))
              .build();
        }
      }
    }
    return getFetchAndParseMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.tika.FetchAndParseRequest,
      org.apache.tika.FetchAndParseReply> getFetchAndParseServerSideStreamingMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "FetchAndParseServerSideStreaming",
      requestType = org.apache.tika.FetchAndParseRequest.class,
      responseType = org.apache.tika.FetchAndParseReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.tika.FetchAndParseRequest,
      org.apache.tika.FetchAndParseReply> getFetchAndParseServerSideStreamingMethod() {
    io.grpc.MethodDescriptor<org.apache.tika.FetchAndParseRequest, org.apache.tika.FetchAndParseReply> getFetchAndParseServerSideStreamingMethod;
    if ((getFetchAndParseServerSideStreamingMethod = TikaGrpc.getFetchAndParseServerSideStreamingMethod) == null) {
      synchronized (TikaGrpc.class) {
        if ((getFetchAndParseServerSideStreamingMethod = TikaGrpc.getFetchAndParseServerSideStreamingMethod) == null) {
          TikaGrpc.getFetchAndParseServerSideStreamingMethod = getFetchAndParseServerSideStreamingMethod =
              io.grpc.MethodDescriptor.<org.apache.tika.FetchAndParseRequest, org.apache.tika.FetchAndParseReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "FetchAndParseServerSideStreaming"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.FetchAndParseRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.FetchAndParseReply.getDefaultInstance()))
              .setSchemaDescriptor(new TikaMethodDescriptorSupplier("FetchAndParseServerSideStreaming"))
              .build();
        }
      }
    }
    return getFetchAndParseServerSideStreamingMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.tika.FetchAndParseRequest,
      org.apache.tika.FetchAndParseReply> getFetchAndParseBiDirectionalStreamingMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "FetchAndParseBiDirectionalStreaming",
      requestType = org.apache.tika.FetchAndParseRequest.class,
      responseType = org.apache.tika.FetchAndParseReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.tika.FetchAndParseRequest,
      org.apache.tika.FetchAndParseReply> getFetchAndParseBiDirectionalStreamingMethod() {
    io.grpc.MethodDescriptor<org.apache.tika.FetchAndParseRequest, org.apache.tika.FetchAndParseReply> getFetchAndParseBiDirectionalStreamingMethod;
    if ((getFetchAndParseBiDirectionalStreamingMethod = TikaGrpc.getFetchAndParseBiDirectionalStreamingMethod) == null) {
      synchronized (TikaGrpc.class) {
        if ((getFetchAndParseBiDirectionalStreamingMethod = TikaGrpc.getFetchAndParseBiDirectionalStreamingMethod) == null) {
          TikaGrpc.getFetchAndParseBiDirectionalStreamingMethod = getFetchAndParseBiDirectionalStreamingMethod =
              io.grpc.MethodDescriptor.<org.apache.tika.FetchAndParseRequest, org.apache.tika.FetchAndParseReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "FetchAndParseBiDirectionalStreaming"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.FetchAndParseRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.FetchAndParseReply.getDefaultInstance()))
              .setSchemaDescriptor(new TikaMethodDescriptorSupplier("FetchAndParseBiDirectionalStreaming"))
              .build();
        }
      }
    }
    return getFetchAndParseBiDirectionalStreamingMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.tika.GetFetcherConfigJsonSchemaRequest,
      org.apache.tika.GetFetcherConfigJsonSchemaReply> getGetFetcherConfigJsonSchemaMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetFetcherConfigJsonSchema",
      requestType = org.apache.tika.GetFetcherConfigJsonSchemaRequest.class,
      responseType = org.apache.tika.GetFetcherConfigJsonSchemaReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.apache.tika.GetFetcherConfigJsonSchemaRequest,
      org.apache.tika.GetFetcherConfigJsonSchemaReply> getGetFetcherConfigJsonSchemaMethod() {
    io.grpc.MethodDescriptor<org.apache.tika.GetFetcherConfigJsonSchemaRequest, org.apache.tika.GetFetcherConfigJsonSchemaReply> getGetFetcherConfigJsonSchemaMethod;
    if ((getGetFetcherConfigJsonSchemaMethod = TikaGrpc.getGetFetcherConfigJsonSchemaMethod) == null) {
      synchronized (TikaGrpc.class) {
        if ((getGetFetcherConfigJsonSchemaMethod = TikaGrpc.getGetFetcherConfigJsonSchemaMethod) == null) {
          TikaGrpc.getGetFetcherConfigJsonSchemaMethod = getGetFetcherConfigJsonSchemaMethod =
              io.grpc.MethodDescriptor.<org.apache.tika.GetFetcherConfigJsonSchemaRequest, org.apache.tika.GetFetcherConfigJsonSchemaReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetFetcherConfigJsonSchema"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.GetFetcherConfigJsonSchemaRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.tika.GetFetcherConfigJsonSchemaReply.getDefaultInstance()))
              .setSchemaDescriptor(new TikaMethodDescriptorSupplier("GetFetcherConfigJsonSchema"))
              .build();
        }
      }
    }
    return getGetFetcherConfigJsonSchemaMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static TikaStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TikaStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TikaStub>() {
        @java.lang.Override
        public TikaStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TikaStub(channel, callOptions);
        }
      };
    return TikaStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports all types of calls on the service
   */
  public static TikaBlockingV2Stub newBlockingV2Stub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TikaBlockingV2Stub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TikaBlockingV2Stub>() {
        @java.lang.Override
        public TikaBlockingV2Stub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TikaBlockingV2Stub(channel, callOptions);
        }
      };
    return TikaBlockingV2Stub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static TikaBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TikaBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TikaBlockingStub>() {
        @java.lang.Override
        public TikaBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TikaBlockingStub(channel, callOptions);
        }
      };
    return TikaBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static TikaFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TikaFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TikaFutureStub>() {
        @java.lang.Override
        public TikaFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TikaFutureStub(channel, callOptions);
        }
      };
    return TikaFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * The Tika Grpc Service definition
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * 
     *Save a fetcher to the fetcher store.   
     * </pre>
     */
    default void saveFetcher(org.apache.tika.SaveFetcherRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.SaveFetcherReply> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSaveFetcherMethod(), responseObserver);
    }

    /**
     * <pre>
     * 
     *Get a fetcher's data from the fetcher store.   
     * </pre>
     */
    default void getFetcher(org.apache.tika.GetFetcherRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.GetFetcherReply> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetFetcherMethod(), responseObserver);
    }

    /**
     * <pre>
     * 
     *List fetchers that are currently in the fetcher store.   
     * </pre>
     */
    default void listFetchers(org.apache.tika.ListFetchersRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.ListFetchersReply> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListFetchersMethod(), responseObserver);
    }

    /**
     * <pre>
     * 
     *Delete a fetcher from the fetcher store.   
     * </pre>
     */
    default void deleteFetcher(org.apache.tika.DeleteFetcherRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.DeleteFetcherReply> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getDeleteFetcherMethod(), responseObserver);
    }

    /**
     * <pre>
     * 
     *Using a Fetcher in the fetcher store, send a FetchAndParse request. This will fetch, parse, and return
     *the FetchParseTuple data output from Tika Pipes. This is a synchronous call that immediately returns 1 result.
     * </pre>
     */
    default void fetchAndParse(org.apache.tika.FetchAndParseRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.FetchAndParseReply> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getFetchAndParseMethod(), responseObserver);
    }

    /**
     * <pre>
     *Using a Fetcher in the fetcher store, send a FetchAndParse request. This will fetch, parse, and return
     *the FetchParseTuple data output from Tika Pipes. This will stream the data from the server in response.
     * </pre>
     */
    default void fetchAndParseServerSideStreaming(org.apache.tika.FetchAndParseRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.FetchAndParseReply> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getFetchAndParseServerSideStreamingMethod(), responseObserver);
    }

    /**
     * <pre>
     *Using a Fetcher in the fetcher store, send a FetchAndParse request. This will fetch, parse, and return
     *the FetchParseTuple data output from Tika Pipes. This serves a bi-directional stream of fetch inputs and
     *parsed outputs.
     * </pre>
     */
    default io.grpc.stub.StreamObserver<org.apache.tika.FetchAndParseRequest> fetchAndParseBiDirectionalStreaming(
        io.grpc.stub.StreamObserver<org.apache.tika.FetchAndParseReply> responseObserver) {
      return io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall(getFetchAndParseBiDirectionalStreamingMethod(), responseObserver);
    }

    /**
     * <pre>
     *Get the Fetcher Config schema for a given fetcher class.
     * </pre>
     */
    default void getFetcherConfigJsonSchema(org.apache.tika.GetFetcherConfigJsonSchemaRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.GetFetcherConfigJsonSchemaReply> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetFetcherConfigJsonSchemaMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service Tika.
   * <pre>
   * The Tika Grpc Service definition
   * </pre>
   */
  public static abstract class TikaImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return TikaGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service Tika.
   * <pre>
   * The Tika Grpc Service definition
   * </pre>
   */
  public static final class TikaStub
      extends io.grpc.stub.AbstractAsyncStub<TikaStub> {
    private TikaStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TikaStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TikaStub(channel, callOptions);
    }

    /**
     * <pre>
     * 
     *Save a fetcher to the fetcher store.   
     * </pre>
     */
    public void saveFetcher(org.apache.tika.SaveFetcherRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.SaveFetcherReply> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSaveFetcherMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * 
     *Get a fetcher's data from the fetcher store.   
     * </pre>
     */
    public void getFetcher(org.apache.tika.GetFetcherRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.GetFetcherReply> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetFetcherMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * 
     *List fetchers that are currently in the fetcher store.   
     * </pre>
     */
    public void listFetchers(org.apache.tika.ListFetchersRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.ListFetchersReply> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListFetchersMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * 
     *Delete a fetcher from the fetcher store.   
     * </pre>
     */
    public void deleteFetcher(org.apache.tika.DeleteFetcherRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.DeleteFetcherReply> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getDeleteFetcherMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * 
     *Using a Fetcher in the fetcher store, send a FetchAndParse request. This will fetch, parse, and return
     *the FetchParseTuple data output from Tika Pipes. This is a synchronous call that immediately returns 1 result.
     * </pre>
     */
    public void fetchAndParse(org.apache.tika.FetchAndParseRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.FetchAndParseReply> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getFetchAndParseMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Using a Fetcher in the fetcher store, send a FetchAndParse request. This will fetch, parse, and return
     *the FetchParseTuple data output from Tika Pipes. This will stream the data from the server in response.
     * </pre>
     */
    public void fetchAndParseServerSideStreaming(org.apache.tika.FetchAndParseRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.FetchAndParseReply> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getFetchAndParseServerSideStreamingMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Using a Fetcher in the fetcher store, send a FetchAndParse request. This will fetch, parse, and return
     *the FetchParseTuple data output from Tika Pipes. This serves a bi-directional stream of fetch inputs and
     *parsed outputs.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.tika.FetchAndParseRequest> fetchAndParseBiDirectionalStreaming(
        io.grpc.stub.StreamObserver<org.apache.tika.FetchAndParseReply> responseObserver) {
      return io.grpc.stub.ClientCalls.asyncBidiStreamingCall(
          getChannel().newCall(getFetchAndParseBiDirectionalStreamingMethod(), getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     *Get the Fetcher Config schema for a given fetcher class.
     * </pre>
     */
    public void getFetcherConfigJsonSchema(org.apache.tika.GetFetcherConfigJsonSchemaRequest request,
        io.grpc.stub.StreamObserver<org.apache.tika.GetFetcherConfigJsonSchemaReply> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetFetcherConfigJsonSchemaMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service Tika.
   * <pre>
   * The Tika Grpc Service definition
   * </pre>
   */
  public static final class TikaBlockingV2Stub
      extends io.grpc.stub.AbstractBlockingStub<TikaBlockingV2Stub> {
    private TikaBlockingV2Stub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TikaBlockingV2Stub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TikaBlockingV2Stub(channel, callOptions);
    }

    /**
     * <pre>
     * 
     *Save a fetcher to the fetcher store.   
     * </pre>
     */
    public org.apache.tika.SaveFetcherReply saveFetcher(org.apache.tika.SaveFetcherRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSaveFetcherMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * 
     *Get a fetcher's data from the fetcher store.   
     * </pre>
     */
    public org.apache.tika.GetFetcherReply getFetcher(org.apache.tika.GetFetcherRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetFetcherMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * 
     *List fetchers that are currently in the fetcher store.   
     * </pre>
     */
    public org.apache.tika.ListFetchersReply listFetchers(org.apache.tika.ListFetchersRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListFetchersMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * 
     *Delete a fetcher from the fetcher store.   
     * </pre>
     */
    public org.apache.tika.DeleteFetcherReply deleteFetcher(org.apache.tika.DeleteFetcherRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getDeleteFetcherMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * 
     *Using a Fetcher in the fetcher store, send a FetchAndParse request. This will fetch, parse, and return
     *the FetchParseTuple data output from Tika Pipes. This is a synchronous call that immediately returns 1 result.
     * </pre>
     */
    public org.apache.tika.FetchAndParseReply fetchAndParse(org.apache.tika.FetchAndParseRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getFetchAndParseMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Using a Fetcher in the fetcher store, send a FetchAndParse request. This will fetch, parse, and return
     *the FetchParseTuple data output from Tika Pipes. This will stream the data from the server in response.
     * </pre>
     */
    @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/10918")
    public io.grpc.stub.BlockingClientCall<?, org.apache.tika.FetchAndParseReply>
        fetchAndParseServerSideStreaming(org.apache.tika.FetchAndParseRequest request) {
      return io.grpc.stub.ClientCalls.blockingV2ServerStreamingCall(
          getChannel(), getFetchAndParseServerSideStreamingMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Using a Fetcher in the fetcher store, send a FetchAndParse request. This will fetch, parse, and return
     *the FetchParseTuple data output from Tika Pipes. This serves a bi-directional stream of fetch inputs and
     *parsed outputs.
     * </pre>
     */
    @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/10918")
    public io.grpc.stub.BlockingClientCall<org.apache.tika.FetchAndParseRequest, org.apache.tika.FetchAndParseReply>
        fetchAndParseBiDirectionalStreaming() {
      return io.grpc.stub.ClientCalls.blockingBidiStreamingCall(
          getChannel(), getFetchAndParseBiDirectionalStreamingMethod(), getCallOptions());
    }

    /**
     * <pre>
     *Get the Fetcher Config schema for a given fetcher class.
     * </pre>
     */
    public org.apache.tika.GetFetcherConfigJsonSchemaReply getFetcherConfigJsonSchema(org.apache.tika.GetFetcherConfigJsonSchemaRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetFetcherConfigJsonSchemaMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do limited synchronous rpc calls to service Tika.
   * <pre>
   * The Tika Grpc Service definition
   * </pre>
   */
  public static final class TikaBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<TikaBlockingStub> {
    private TikaBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TikaBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TikaBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * 
     *Save a fetcher to the fetcher store.   
     * </pre>
     */
    public org.apache.tika.SaveFetcherReply saveFetcher(org.apache.tika.SaveFetcherRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSaveFetcherMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * 
     *Get a fetcher's data from the fetcher store.   
     * </pre>
     */
    public org.apache.tika.GetFetcherReply getFetcher(org.apache.tika.GetFetcherRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetFetcherMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * 
     *List fetchers that are currently in the fetcher store.   
     * </pre>
     */
    public org.apache.tika.ListFetchersReply listFetchers(org.apache.tika.ListFetchersRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListFetchersMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * 
     *Delete a fetcher from the fetcher store.   
     * </pre>
     */
    public org.apache.tika.DeleteFetcherReply deleteFetcher(org.apache.tika.DeleteFetcherRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getDeleteFetcherMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * 
     *Using a Fetcher in the fetcher store, send a FetchAndParse request. This will fetch, parse, and return
     *the FetchParseTuple data output from Tika Pipes. This is a synchronous call that immediately returns 1 result.
     * </pre>
     */
    public org.apache.tika.FetchAndParseReply fetchAndParse(org.apache.tika.FetchAndParseRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getFetchAndParseMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Using a Fetcher in the fetcher store, send a FetchAndParse request. This will fetch, parse, and return
     *the FetchParseTuple data output from Tika Pipes. This will stream the data from the server in response.
     * </pre>
     */
    public java.util.Iterator<org.apache.tika.FetchAndParseReply> fetchAndParseServerSideStreaming(
        org.apache.tika.FetchAndParseRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getFetchAndParseServerSideStreamingMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Get the Fetcher Config schema for a given fetcher class.
     * </pre>
     */
    public org.apache.tika.GetFetcherConfigJsonSchemaReply getFetcherConfigJsonSchema(org.apache.tika.GetFetcherConfigJsonSchemaRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetFetcherConfigJsonSchemaMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service Tika.
   * <pre>
   * The Tika Grpc Service definition
   * </pre>
   */
  public static final class TikaFutureStub
      extends io.grpc.stub.AbstractFutureStub<TikaFutureStub> {
    private TikaFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TikaFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TikaFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * 
     *Save a fetcher to the fetcher store.   
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.tika.SaveFetcherReply> saveFetcher(
        org.apache.tika.SaveFetcherRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSaveFetcherMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * 
     *Get a fetcher's data from the fetcher store.   
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.tika.GetFetcherReply> getFetcher(
        org.apache.tika.GetFetcherRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetFetcherMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * 
     *List fetchers that are currently in the fetcher store.   
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.tika.ListFetchersReply> listFetchers(
        org.apache.tika.ListFetchersRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListFetchersMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * 
     *Delete a fetcher from the fetcher store.   
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.tika.DeleteFetcherReply> deleteFetcher(
        org.apache.tika.DeleteFetcherRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getDeleteFetcherMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * 
     *Using a Fetcher in the fetcher store, send a FetchAndParse request. This will fetch, parse, and return
     *the FetchParseTuple data output from Tika Pipes. This is a synchronous call that immediately returns 1 result.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.tika.FetchAndParseReply> fetchAndParse(
        org.apache.tika.FetchAndParseRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getFetchAndParseMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Get the Fetcher Config schema for a given fetcher class.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.tika.GetFetcherConfigJsonSchemaReply> getFetcherConfigJsonSchema(
        org.apache.tika.GetFetcherConfigJsonSchemaRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetFetcherConfigJsonSchemaMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_SAVE_FETCHER = 0;
  private static final int METHODID_GET_FETCHER = 1;
  private static final int METHODID_LIST_FETCHERS = 2;
  private static final int METHODID_DELETE_FETCHER = 3;
  private static final int METHODID_FETCH_AND_PARSE = 4;
  private static final int METHODID_FETCH_AND_PARSE_SERVER_SIDE_STREAMING = 5;
  private static final int METHODID_GET_FETCHER_CONFIG_JSON_SCHEMA = 6;
  private static final int METHODID_FETCH_AND_PARSE_BI_DIRECTIONAL_STREAMING = 7;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_SAVE_FETCHER:
          serviceImpl.saveFetcher((org.apache.tika.SaveFetcherRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.tika.SaveFetcherReply>) responseObserver);
          break;
        case METHODID_GET_FETCHER:
          serviceImpl.getFetcher((org.apache.tika.GetFetcherRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.tika.GetFetcherReply>) responseObserver);
          break;
        case METHODID_LIST_FETCHERS:
          serviceImpl.listFetchers((org.apache.tika.ListFetchersRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.tika.ListFetchersReply>) responseObserver);
          break;
        case METHODID_DELETE_FETCHER:
          serviceImpl.deleteFetcher((org.apache.tika.DeleteFetcherRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.tika.DeleteFetcherReply>) responseObserver);
          break;
        case METHODID_FETCH_AND_PARSE:
          serviceImpl.fetchAndParse((org.apache.tika.FetchAndParseRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.tika.FetchAndParseReply>) responseObserver);
          break;
        case METHODID_FETCH_AND_PARSE_SERVER_SIDE_STREAMING:
          serviceImpl.fetchAndParseServerSideStreaming((org.apache.tika.FetchAndParseRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.tika.FetchAndParseReply>) responseObserver);
          break;
        case METHODID_GET_FETCHER_CONFIG_JSON_SCHEMA:
          serviceImpl.getFetcherConfigJsonSchema((org.apache.tika.GetFetcherConfigJsonSchemaRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.tika.GetFetcherConfigJsonSchemaReply>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_FETCH_AND_PARSE_BI_DIRECTIONAL_STREAMING:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.fetchAndParseBiDirectionalStreaming(
              (io.grpc.stub.StreamObserver<org.apache.tika.FetchAndParseReply>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getSaveFetcherMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              org.apache.tika.SaveFetcherRequest,
              org.apache.tika.SaveFetcherReply>(
                service, METHODID_SAVE_FETCHER)))
        .addMethod(
          getGetFetcherMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              org.apache.tika.GetFetcherRequest,
              org.apache.tika.GetFetcherReply>(
                service, METHODID_GET_FETCHER)))
        .addMethod(
          getListFetchersMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              org.apache.tika.ListFetchersRequest,
              org.apache.tika.ListFetchersReply>(
                service, METHODID_LIST_FETCHERS)))
        .addMethod(
          getDeleteFetcherMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              org.apache.tika.DeleteFetcherRequest,
              org.apache.tika.DeleteFetcherReply>(
                service, METHODID_DELETE_FETCHER)))
        .addMethod(
          getFetchAndParseMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              org.apache.tika.FetchAndParseRequest,
              org.apache.tika.FetchAndParseReply>(
                service, METHODID_FETCH_AND_PARSE)))
        .addMethod(
          getFetchAndParseServerSideStreamingMethod(),
          io.grpc.stub.ServerCalls.asyncServerStreamingCall(
            new MethodHandlers<
              org.apache.tika.FetchAndParseRequest,
              org.apache.tika.FetchAndParseReply>(
                service, METHODID_FETCH_AND_PARSE_SERVER_SIDE_STREAMING)))
        .addMethod(
          getFetchAndParseBiDirectionalStreamingMethod(),
          io.grpc.stub.ServerCalls.asyncBidiStreamingCall(
            new MethodHandlers<
              org.apache.tika.FetchAndParseRequest,
              org.apache.tika.FetchAndParseReply>(
                service, METHODID_FETCH_AND_PARSE_BI_DIRECTIONAL_STREAMING)))
        .addMethod(
          getGetFetcherConfigJsonSchemaMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              org.apache.tika.GetFetcherConfigJsonSchemaRequest,
              org.apache.tika.GetFetcherConfigJsonSchemaReply>(
                service, METHODID_GET_FETCHER_CONFIG_JSON_SCHEMA)))
        .build();
  }

  private static abstract class TikaBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    TikaBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return org.apache.tika.TikaProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Tika");
    }
  }

  private static final class TikaFileDescriptorSupplier
      extends TikaBaseDescriptorSupplier {
    TikaFileDescriptorSupplier() {}
  }

  private static final class TikaMethodDescriptorSupplier
      extends TikaBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    TikaMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (TikaGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new TikaFileDescriptorSupplier())
              .addMethod(getSaveFetcherMethod())
              .addMethod(getGetFetcherMethod())
              .addMethod(getListFetchersMethod())
              .addMethod(getDeleteFetcherMethod())
              .addMethod(getFetchAndParseMethod())
              .addMethod(getFetchAndParseServerSideStreamingMethod())
              .addMethod(getFetchAndParseBiDirectionalStreamingMethod())
              .addMethod(getGetFetcherConfigJsonSchemaMethod())
              .build();
        }
      }
    }
    return result;
  }
}
