/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing.general;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.tika.fuzzing.Transformer;
import org.apache.tika.mime.MediaType;

public class ByteInjector
implements Transformer {
    static Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.OCTET_STREAM);
    Random random = new Random();
    float injectionFrequency = 0.01f;
    int maxSpan = 100;

    @Override
    public Set<MediaType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public void transform(InputStream is, OutputStream os) throws IOException {
        byte[] input = IOUtils.toByteArray((InputStream)is);
        int numInjections = (int)Math.floor((double)this.injectionFrequency * (double)input.length);
        numInjections = numInjections == 0 ? 1 : numInjections;
        int[] starts = new int[numInjections];
        if (numInjections > 1) {
            for (int i = 0; i < numInjections; ++i) {
                starts[i] = this.random.nextInt(input.length - 1);
            }
        } else {
            starts[0] = 0;
        }
        Arrays.sort(starts);
        int startIndex = 0;
        for (int i = 0; i < input.length; ++i) {
            os.write(input[i]);
            if (startIndex >= starts.length || starts[startIndex] != i) continue;
            this.inject(os);
            ++startIndex;
        }
    }

    private void inject(OutputStream os) throws IOException {
        int len = this.random.nextInt(this.maxSpan);
        byte[] randBytes = new byte[len];
        this.random.nextBytes(randBytes);
        os.write(randBytes);
    }
}

