/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing.pdf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.tika.fuzzing.Transformer;
import org.apache.tika.fuzzing.general.ByteDeleter;
import org.apache.tika.fuzzing.general.ByteFlipper;
import org.apache.tika.fuzzing.general.ByteInjector;
import org.apache.tika.fuzzing.general.GeneralTransformer;
import org.apache.tika.fuzzing.general.SpanSwapper;
import org.apache.tika.fuzzing.general.Truncator;

public class PDFTransformerConfig {
    private final Random random = new Random();
    private float randomizeObjectNumbers = -1.0f;
    private float randomizeRefNumbers = -1.0f;
    private int maxFilters = 1;
    private int minFilters = 1;
    private long maxFilteredStreamLength = -1L;
    private Set<COSName> allowableFilters = new HashSet<COSName>();
    private Transformer streamTransformer = new GeneralTransformer(1, new ByteDeleter(), new ByteFlipper(), new ByteInjector(), new SpanSwapper(), new Truncator());
    private Transformer unfilteredStreamTransformer = new GeneralTransformer(1, new ByteDeleter(), new ByteFlipper(), new ByteInjector(), new SpanSwapper(), new Truncator());

    public float getRandomizeObjectNumbers() {
        return this.randomizeObjectNumbers;
    }

    public void setRandomizeObjectNumbers(float randomizeObjectNumbers) {
        this.randomizeObjectNumbers = randomizeObjectNumbers;
    }

    public float getRandomizeRefNumbers() {
        return this.randomizeRefNumbers;
    }

    public void setRandomizeRefNumbers(float randomizeRefNumbers) {
        this.randomizeRefNumbers = randomizeRefNumbers;
    }

    public Transformer getUnfilteredStreamTransformer() {
        return this.unfilteredStreamTransformer;
    }

    public void setUnfilteredStreamTransformer(Transformer transformer) {
        this.unfilteredStreamTransformer = transformer;
    }

    public Transformer getStreamTransformer() {
        return this.streamTransformer;
    }

    public void setStreamTransformer(Transformer transformer) {
        this.streamTransformer = transformer;
    }

    public void setMaxFilters(int maxFilters) {
        this.maxFilters = maxFilters;
    }

    public Set<COSName> getAllowableFilters() {
        return this.allowableFilters;
    }

    public void setAllowableFilters(Set<COSName> allowableFilters) {
        this.allowableFilters = allowableFilters;
    }

    public List<COSName> getFilters(COSBase existingFilters) {
        if (this.maxFilters < 0) {
            ArrayList<COSName> ret = new ArrayList<COSName>();
            if (existingFilters instanceof COSArray) {
                for (COSBase obj : (COSArray)existingFilters) {
                    ret.add((COSName)obj);
                }
            } else if (existingFilters instanceof COSName) {
                ret.add((COSName)existingFilters);
            }
            return ret;
        }
        int numFilters = this.maxFilters - this.minFilters == 0 ? this.maxFilters : this.minFilters + this.random.nextInt(this.maxFilters - this.minFilters);
        ArrayList<COSName> allowable = new ArrayList<COSName>(this.allowableFilters);
        ArrayList<COSName> filters = new ArrayList<COSName>();
        for (int i = 0; i < numFilters; ++i) {
            int index = this.random.nextInt(allowable.size());
            filters.add((COSName)allowable.get(index));
        }
        return filters;
    }

    public void setMinFilters(int minFilters) {
        this.minFilters = minFilters;
    }

    public long getMaxFilteredStreamLength() {
        return this.maxFilteredStreamLength;
    }

    public void setMaxFilteredStreamLength(long maxFilteredStreamLength) {
        this.maxFilteredStreamLength = maxFilteredStreamLength;
    }
}

