/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.fuzzing.Transformer;
import org.apache.tika.fuzzing.cli.FuzzingCLIConfig;
import org.apache.tika.fuzzing.general.ByteDeleter;
import org.apache.tika.fuzzing.general.ByteFlipper;
import org.apache.tika.fuzzing.general.ByteInjector;
import org.apache.tika.fuzzing.general.GeneralTransformer;
import org.apache.tika.fuzzing.general.SpanSwapper;
import org.apache.tika.fuzzing.general.Truncator;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.PipesConfig;
import org.apache.tika.pipes.PipesParser;
import org.apache.tika.pipes.PipesResult;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.pipes.fetcher.FetcherManager;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzingCLI {
    private static final Logger LOG = LoggerFactory.getLogger(FuzzingCLI.class);
    private static final String TEMP_FETCHER_NAME = "temp";
    private static final String TEMP_EMITTER_NAME = "temp";

    public static void main(String[] args) throws Exception {
        FuzzingCLIConfig config = FuzzingCLIConfig.parse(args);
        if (config.getMaxTransformers() == 0) {
            LOG.warn("max transformers == 0!");
        }
        FuzzingCLI fuzzingCLI = new FuzzingCLI();
        Files.createDirectories(config.getProblemsDirectory(), new FileAttribute[0]);
        fuzzingCLI.execute(config);
    }

    private void execute(FuzzingCLIConfig config) throws Exception {
        ArrayBlockingQueue<FetchEmitTuple> q = new ArrayBlockingQueue<FetchEmitTuple>(10000);
        PipesConfig pipesConfig = PipesConfig.load((Path)config.getTikaConfig());
        FetcherManager fetcherManager = FetcherManager.load((Path)config.getTikaConfig());
        int totalThreads = pipesConfig.getNumClients() + 1;
        ExecutorService executorService = Executors.newFixedThreadPool(totalThreads);
        ExecutorCompletionService<Integer> executorCompletionService = new ExecutorCompletionService<Integer>(executorService);
        PipesIterator pipesIterator = PipesIterator.build((Path)config.getTikaConfig());
        FileAdder fileAdder = new FileAdder(pipesIterator, q);
        executorCompletionService.submit(fileAdder);
        try (PipesParser parser = new PipesParser(pipesConfig);){
            for (int i = 0; i < pipesConfig.getNumClients(); ++i) {
                executorCompletionService.submit(new Fuzzer(q, config, parser, fetcherManager));
            }
            int finished = 0;
            while (finished < totalThreads) {
                Future future = null;
                try {
                    future = executorCompletionService.poll(1L, TimeUnit.SECONDS);
                    if (future != null) {
                        future.get();
                        ++finished;
                    }
                    LOG.info("Finished thread {} threads of {}", (Object)finished, (Object)totalThreads);
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                    break;
                }
            }
            executorService.shutdown();
            executorService.shutdownNow();
        }
    }

    private static class FileAdder
    implements Callable<Integer> {
        private final PipesIterator pipesIterator;
        private final ArrayBlockingQueue<FetchEmitTuple> queue;
        private int added = 0;

        public FileAdder(PipesIterator pipesIterator, ArrayBlockingQueue<FetchEmitTuple> queue) {
            this.pipesIterator = pipesIterator;
            this.queue = queue;
        }

        @Override
        public Integer call() throws Exception {
            int added = 0;
            for (FetchEmitTuple tuple : this.pipesIterator) {
                this.queue.put(tuple);
                ++added;
            }
            this.queue.put(PipesIterator.COMPLETED_SEMAPHORE);
            LOG.info("file adder finished " + added);
            return 1;
        }
    }

    private static class Fuzzer
    implements Callable<Integer> {
        static AtomicInteger COUNTER = new AtomicInteger();
        static AtomicInteger FUZZED = new AtomicInteger();
        static AtomicInteger SOURCE_FILES = new AtomicInteger();
        private final int threadId = COUNTER.getAndIncrement();
        private final ArrayBlockingQueue<FetchEmitTuple> q;
        private final FuzzingCLIConfig config;
        private final PipesParser pipesParser;
        private final Transformer transformer;
        private final FetcherManager fetcherManager;

        public Fuzzer(ArrayBlockingQueue<FetchEmitTuple> q, FuzzingCLIConfig config, PipesParser pipesParser, FetcherManager fetcherManager) {
            this.q = q;
            this.config = config;
            this.pipesParser = pipesParser;
            this.transformer = new GeneralTransformer(config.getMaxTransformers(), new ByteDeleter(), new ByteFlipper(), new ByteInjector(), new Truncator(), new SpanSwapper());
            this.fetcherManager = fetcherManager;
        }

        @Override
        public Integer call() throws Exception {
            block3: while (true) {
                FetchEmitTuple fetchEmitTuple;
                if ((fetchEmitTuple = this.q.take()).equals((Object)PipesIterator.COMPLETED_SEMAPHORE)) {
                    LOG.debug("Thread " + this.threadId + " stopping");
                    this.q.put(PipesIterator.COMPLETED_SEMAPHORE);
                    return 1;
                }
                int inputFiles = SOURCE_FILES.getAndIncrement();
                if (inputFiles % 100 == 0) {
                    LOG.info("Processed {} source files", (Object)inputFiles);
                }
                int i = 0;
                while (true) {
                    if (i >= this.config.perFileIterations) continue block3;
                    try {
                        this.fuzzIt(fetchEmitTuple);
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.warn("serious problem with", (Throwable)e);
                    }
                    ++i;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fuzzIt(FetchEmitTuple fetchEmitTuple) throws IOException, InterruptedException, TikaException {
            Path cwd = Files.createTempDirectory("tika-fuzz-", new FileAttribute[0]);
            try {
                Path fuzzedPath = this.fuzz(fetchEmitTuple, cwd);
                Path extract = Files.createTempFile(cwd, "tika-extract-", ".json", new FileAttribute[0]);
                FetchEmitTuple fuzzedTuple = new FetchEmitTuple(fetchEmitTuple.getId(), new FetchKey("temp", fuzzedPath.toAbsolutePath().toString()), new EmitKey("temp", extract.toAbsolutePath().toString()));
                int count = FUZZED.getAndIncrement();
                if (count % 100 == 0) {
                    LOG.info("processed {} fuzzed files", (Object)count);
                }
                boolean tryAgain = true;
                for (int tries = 0; tryAgain && tries < this.config.getRetries(); ++tries) {
                    try {
                        PipesResult result = this.pipesParser.parse(fuzzedTuple);
                        tryAgain = this.handleResult(result.getStatus(), fetchEmitTuple.getFetchKey().getFetchKey(), fuzzedPath, tries, this.config.getRetries());
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        tryAgain = this.handleResult(PipesResult.STATUS.UNSPECIFIED_CRASH, fetchEmitTuple.getFetchKey().getFetchKey(), fuzzedPath, tries, this.config.getRetries());
                        continue;
                    }
                }
            }
            finally {
                try {
                    FileUtils.deleteDirectory((File)cwd.toFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOG.warn("Couldn't delete " + cwd.toAbsolutePath(), (Throwable)e);
                }
            }
        }

        private Path fuzz(FetchEmitTuple fetchEmitTuple, Path cwd) throws IOException, TikaException {
            Path target = Files.createTempFile(cwd, "tika-fuzz-target-", "." + FilenameUtils.getExtension((String)fetchEmitTuple.getFetchKey().getFetchKey()), new FileAttribute[0]);
            try (InputStream is = this.fetcherManager.getFetcher(fetchEmitTuple.getFetchKey().getFetcherName()).fetch(fetchEmitTuple.getFetchKey().getFetchKey(), new Metadata());
                 OutputStream os = Files.newOutputStream(target, new OpenOption[0]);){
                this.transformer.transform(is, os);
            }
            return target;
        }

        private boolean handleResult(PipesResult.STATUS status, String origFetchKey, Path fuzzedPath, int tries, int maxRetries) throws IOException {
            switch (status) {
                case OOM: 
                case TIMEOUT: 
                case UNSPECIFIED_CRASH: {
                    if (tries < maxRetries) {
                        LOG.info("trying again ({} of {}): {}", new Object[]{tries, maxRetries, status.name()});
                        return true;
                    }
                    Path problemFilePath = this.getProblemFile(status, origFetchKey);
                    LOG.info("found a problem {} -> {} : {}", new Object[]{origFetchKey, problemFilePath, status.name()});
                    Files.copy(fuzzedPath, problemFilePath, new CopyOption[0]);
                    return false;
                }
            }
            return false;
        }

        private Path getProblemFile(PipesResult.STATUS status, String origFetchKey) throws IOException {
            String name = FilenameUtils.getName((String)origFetchKey) + "-" + UUID.randomUUID();
            Path problemFile = this.config.getProblemsDirectory().resolve(status.name().toLowerCase(Locale.US)).resolve(name);
            Files.createDirectories(problemFile.getParent(), new FileAttribute[0]);
            return problemFile;
        }
    }
}

