/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.language.translate.impl.GoogleTranslator;

public class TranscribeTranslateExample {
    public static String googleTranslateToEnglish(String text) {
        GoogleTranslator translator = new GoogleTranslator();
        String result = null;
        if (translator.isAvailable()) {
            try {
                result = translator.translate(text, "en-US");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String amazonTranscribe(Path tikaConfig, Path file) throws Exception {
        return new Tika(new TikaConfig(tikaConfig)).parseToString(file);
    }

    public static void main(String[] args) throws Exception {
        String text = null;
        if (args.length > 1) {
            if ("transcribe-translate".equals(args[1])) {
                text = TranscribeTranslateExample.googleTranslateToEnglish(TranscribeTranslateExample.amazonTranscribe(Paths.get(args[0], new String[0]), Paths.get(args[1], new String[0])));
                System.out.print("Transcription and translation successful!\nEXTRACTED TEXT: " + text);
            } else if ("transcribe".equals(args[1])) {
                text = TranscribeTranslateExample.amazonTranscribe(Paths.get(args[0], new String[0]), Paths.get(args[1], new String[0]));
                System.out.print("Transcription successful!\nEXTRACTED TEXT: " + text);
            } else {
                System.out.print("Incorrect invocation, see Javadoc.");
            }
        } else {
            System.out.print("Incorrect invocation, see Javadoc.");
        }
    }
}

