/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.tika.Tika;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;

public class MetadataAwareLuceneIndexer {
    private Tika tika;
    private IndexWriter writer;

    public MetadataAwareLuceneIndexer(IndexWriter writer, Tika tika) {
        this.writer = writer;
        this.tika = tika;
    }

    public void indexContentSpecificMet(File file) throws Exception {
        Metadata met = new Metadata();
        try (FileInputStream is = new FileInputStream(file);){
            this.tika.parse((InputStream)is, met);
            Document document = new Document();
            for (String key : met.names()) {
                String[] values;
                for (String val : values = met.getValues(key)) {
                    document.add((IndexableField)new TextField(key, val, Field.Store.YES));
                }
                this.writer.addDocument((Iterable)document);
            }
        }
    }

    public void indexWithDublinCore(File file) throws Exception {
        Metadata met = new Metadata();
        met.add(TikaCoreProperties.CREATOR, "Manning");
        met.add(TikaCoreProperties.CREATOR, "Tika in Action");
        met.set(TikaCoreProperties.CREATED, new Date());
        met.set(TikaCoreProperties.FORMAT, this.tika.detect(file));
        met.set(DublinCore.SOURCE, file.toURI().toURL().toString());
        met.add(TikaCoreProperties.SUBJECT, "File");
        met.add(TikaCoreProperties.SUBJECT, "Indexing");
        met.add(TikaCoreProperties.SUBJECT, "Metadata");
        met.set(Property.externalClosedChoise((String)TikaCoreProperties.RIGHTS.getName(), (String[])new String[]{"public", "private"}), "public");
        try (FileInputStream is = new FileInputStream(file);){
            this.tika.parse((InputStream)is, met);
            Document document = new Document();
            for (String key : met.names()) {
                String[] values;
                for (String val : values = met.getValues(key)) {
                    document.add((IndexableField)new TextField(key, val, Field.Store.YES));
                }
                this.writer.addDocument((Iterable)document);
            }
        }
    }
}

