/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.jcr.Item;
import org.apache.jackrabbit.server.io.DefaultIOListener;
import org.apache.jackrabbit.server.io.IOListener;
import org.apache.jackrabbit.server.io.IOUtil;
import org.apache.jackrabbit.server.io.ImportContext;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportContextImpl
implements ImportContext {
    private static final Logger LOG = LoggerFactory.getLogger(ImportContextImpl.class);
    private final IOListener ioListener;
    private final Item importRoot;
    private final String systemId;
    private final File inputFile;
    private final MediaType type;
    private InputContext inputCtx;
    private boolean completed;

    public ImportContextImpl(Item importRoot, String systemId, InputContext ctx, InputStream stream, IOListener ioListener, Detector detector) throws IOException {
        this.importRoot = importRoot;
        this.systemId = systemId;
        this.inputCtx = ctx;
        this.ioListener = ioListener != null ? ioListener : new DefaultIOListener(LOG);
        Metadata metadata = new Metadata();
        if (ctx != null && ctx.getContentType() != null) {
            metadata.set("Content-Type", ctx.getContentType());
        }
        if (systemId != null) {
            metadata.set("resourceName", systemId);
        }
        if (stream != null && !stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        this.type = detector.detect(stream, metadata);
        this.inputFile = IOUtil.getTempFile((InputStream)stream);
    }

    public IOListener getIOListener() {
        return this.ioListener;
    }

    public Item getImportRoot() {
        return this.importRoot;
    }

    public boolean hasStream() {
        return this.inputFile != null;
    }

    public InputStream getInputStream() {
        this.checkCompleted();
        FileInputStream in = null;
        if (this.inputFile != null) {
            try {
                in = new FileInputStream(this.inputFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return in;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public long getModificationTime() {
        return this.inputCtx != null ? this.inputCtx.getModificationTime() : new Date().getTime();
    }

    public String getContentLanguage() {
        return this.inputCtx != null ? this.inputCtx.getContentLanguage() : null;
    }

    public long getContentLength() {
        long length = -1L;
        if (this.inputCtx != null) {
            length = this.inputCtx.getContentLength();
        }
        if (length < 0L && this.inputFile != null) {
            length = this.inputFile.length();
        }
        if (length < 0L) {
            LOG.debug("Unable to determine content length -> default value = {}", (Object)-1L);
        }
        return length;
    }

    public String getMimeType() {
        return IOUtil.getMimeType((String)this.type.toString());
    }

    public String getEncoding() {
        return IOUtil.getEncoding((String)this.type.toString());
    }

    public Object getProperty(Object propertyName) {
        return this.inputCtx != null ? this.inputCtx.getProperty(propertyName.toString()) : null;
    }

    public void informCompleted(boolean success) {
        this.checkCompleted();
        this.completed = true;
        if (this.inputFile != null) {
            this.inputFile.delete();
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }

    private void checkCompleted() {
        if (this.completed) {
            throw new IllegalStateException("ImportContext has already been consumed.");
        }
    }
}

