/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.detect.LanguageHandler;
import org.apache.tika.language.detect.LanguageResult;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.DelegatingParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.TeeContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LanguageDetectingParser
extends DelegatingParser {
    private static final long serialVersionUID = 4291320409396502774L;

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, IOException, TikaException {
        LanguageHandler langHandler = new LanguageHandler();
        TeeContentHandler tee = new TeeContentHandler(new ContentHandler[]{handler, langHandler});
        super.parse(stream, (ContentHandler)tee, metadata, context);
        LanguageResult result = langHandler.getLanguage();
        if (result.isReasonablyCertain()) {
            metadata.set(TikaCoreProperties.LANGUAGE, result.getLanguage());
        }
    }
}

