/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.PhoneExtractingContentHandler;
import org.xml.sax.ContentHandler;

public class GrabPhoneNumbersExample {
    private static HashSet<String> phoneNumbers = new HashSet();
    private static int failedFiles;
    private static int successfulFiles;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage `java GrabPhoneNumbers [corpus]");
            return;
        }
        Path folder = Paths.get(args[0], new String[0]);
        System.out.println("Searching " + folder.toAbsolutePath() + "...");
        GrabPhoneNumbersExample.processFolder(folder);
        System.out.println(phoneNumbers.toString());
        System.out.println("Parsed " + successfulFiles + "/" + (successfulFiles + failedFiles));
    }

    public static void processFolder(Path folder) {
        try {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        GrabPhoneNumbersExample.process(file);
                        ++successfulFiles;
                    }
                    catch (Exception e) {
                        ++failedFiles;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    ++failedFiles;
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void process(Path path) throws Exception {
        AutoDetectParser parser = new AutoDetectParser();
        Metadata metadata = new Metadata();
        PhoneExtractingContentHandler handler = new PhoneExtractingContentHandler((ContentHandler)new BodyContentHandler(), metadata);
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            parser.parse((InputStream)stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String[] numbers = metadata.getValues("phonenumbers");
        Collections.addAll(phoneNumbers, numbers);
    }

    static {
        successfulFiles = 0;
    }
}

