/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.emitter.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.emitter.AbstractEmitter;
import org.apache.tika.pipes.emitter.StreamEmitter;
import org.apache.tika.pipes.emitter.TikaEmitterException;
import org.apache.tika.serialization.JsonMetadataList;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Emitter
extends AbstractEmitter
implements Initializable,
StreamEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3Emitter.class);
    private String region;
    private String profile;
    private String bucket;
    private String credentialsProvider;
    private String accessKey;
    private String secretKey;
    private String endpointConfigurationService;
    private String fileExtension = "json";
    private boolean spoolToTemp = true;
    private String prefix = null;
    private int maxConnections = 50;
    private boolean pathStyleAccessEnabled = false;
    private AmazonS3 s3Client;

    public void emit(String emitKey, List<Metadata> metadataList, ParseContext parseContext) throws IOException, TikaEmitterException {
        if (metadataList == null || metadataList.size() == 0) {
            throw new TikaEmitterException("metadata list must not be null or of size 0");
        }
        if (!this.spoolToTemp) {
            UnsynchronizedByteArrayOutputStream bos = UnsynchronizedByteArrayOutputStream.builder().get();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8));){
                JsonMetadataList.toJson(metadataList, (Writer)writer);
            }
            catch (IOException e) {
                throw new TikaEmitterException("can't jsonify", (Throwable)e);
            }
            byte[] bytes = bos.toByteArray();
            try (TikaInputStream is = TikaInputStream.get((byte[])bytes);){
                this.emit(emitKey, (InputStream)is, new Metadata(), parseContext);
            }
        }
        try (TemporaryResources tmp = new TemporaryResources();){
            Path tmpPath = tmp.createTempFile();
            try (BufferedWriter writer = Files.newBufferedWriter(tmpPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
                JsonMetadataList.toJson(metadataList, (Writer)writer);
            }
            catch (IOException e) {
                throw new TikaEmitterException("can't jsonify", (Throwable)e);
            }
            try (TikaInputStream is = TikaInputStream.get((Path)tmpPath);){
                this.emit(emitKey, (InputStream)is, new Metadata(), parseContext);
            }
        }
    }

    public void emit(String path, InputStream is, Metadata userMetadata, ParseContext parseContext) throws IOException, TikaEmitterException {
        if (!StringUtils.isBlank((String)this.prefix)) {
            path = this.prefix + "/" + (String)path;
        }
        if (!StringUtils.isBlank((String)this.fileExtension)) {
            path = (String)path + "." + this.fileExtension;
        }
        LOGGER.debug("about to emit to target bucket: ({}) path:({})", (Object)this.bucket, path);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        for (String n : userMetadata.names()) {
            String[] vals = userMetadata.getValues(n);
            if (vals.length > 1) {
                LOGGER.warn("Can only write the first value for key {}. I see {} values.", (Object)n, (Object)vals.length);
            }
            objectMetadata.addUserMetadata(n, vals[0]);
        }
        if (is instanceof TikaInputStream && ((TikaInputStream)is).hasFile()) {
            try {
                PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, (String)path, ((TikaInputStream)is).getFile()).withMetadata(objectMetadata);
                this.s3Client.putObject(putObjectRequest);
            }
            catch (IOException e) {
                throw new TikaEmitterException("exception sending underlying file", (Throwable)e);
            }
            return;
        }
        try {
            this.s3Client.putObject(this.bucket, (String)path, is, objectMetadata);
        }
        catch (AmazonClientException e) {
            throw new IOException("problem writing s3object", e);
        }
    }

    @Field
    public void setSpoolToTemp(boolean spoolToTemp) {
        this.spoolToTemp = spoolToTemp;
    }

    @Field
    public void setRegion(String region) {
        this.region = region;
    }

    @Field
    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Field
    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @Field
    public void setPrefix(String prefix) {
        this.prefix = prefix.endsWith("/") ? prefix.substring(0, prefix.length() - 1) : prefix;
    }

    @Field
    public void setCredentialsProvider(String credentialsProvider) {
        if (!(credentialsProvider.equals("profile") || credentialsProvider.equals("instance") || credentialsProvider.equals("key_secret"))) {
            throw new IllegalArgumentException("credentialsProvider must be either 'profile', 'instance' or 'key_secret'");
        }
        this.credentialsProvider = credentialsProvider;
    }

    @Field
    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Field
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Field
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Field
    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Field
    public void setEndpointConfigurationService(String endpointConfigurationService) {
        this.endpointConfigurationService = endpointConfigurationService;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        AWSCredentialsProvider provider;
        if ("instance".equals(this.credentialsProvider)) {
            provider = InstanceProfileCredentialsProvider.getInstance();
        } else if ("profile".equals(this.credentialsProvider)) {
            provider = new ProfileCredentialsProvider(this.profile);
        } else if (this.credentialsProvider.equals("key_secret")) {
            provider = new AWSStaticCredentialsProvider(new BasicAWSCredentials(this.accessKey, this.secretKey));
        } else {
            throw new TikaConfigException("credentialsProvider must be set and must be either 'instance', 'profile' or 'key_secret'");
        }
        ClientConfiguration clientConfig = new ClientConfiguration().withMaxConnections(this.maxConnections);
        try {
            AmazonS3ClientBuilder amazonS3ClientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(clientConfig)).withCredentials(provider)).withPathStyleAccessEnabled(this.pathStyleAccessEnabled);
            if (!StringUtils.isBlank((String)this.endpointConfigurationService)) {
                amazonS3ClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpointConfigurationService, this.region));
            } else {
                amazonS3ClientBuilder.withRegion(this.region);
            }
            this.s3Client = (AmazonS3)amazonS3ClientBuilder.build();
        }
        catch (AmazonClientException e) {
            throw new TikaConfigException("can't initialize s3 emitter", (Throwable)e);
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        TikaConfig.mustNotBeEmpty((String)"bucket", (String)this.bucket);
        TikaConfig.mustNotBeEmpty((String)"region", (String)this.region);
    }

    @Field
    public void setPathStyleAccessEnabled(boolean pathStyleAccessEnabled) {
        this.pathStyleAccessEnabled = pathStyleAccessEnabled;
    }
}

