/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.dl.imagerec;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tika.config.Field;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.recognition.ObjectRecogniser;
import org.apache.tika.parser.recognition.RecognisedObject;
import org.datavec.image.loader.NativeImageLoader;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.modelimport.keras.KerasModel;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasModelBuilder;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DL4JInceptionV3Net
implements ObjectRecogniser {
    private static final Set<MediaType> MEDIA_TYPES = Collections.singleton(MediaType.image((String)"jpeg"));
    private static final Logger LOG = LoggerFactory.getLogger(DL4JInceptionV3Net.class);
    private static final String DEF_WEIGHTS_URL = "https://github.com/USCDataScience/tika-dockers/releases/download/v0.2/inception_v3_keras_2.h5";
    private static final String DEF_LABEL_MAPPING_URL = "https://github.com/USCDataScience/tika-dockers/releases/download/v0.2/imagenet_class_index.json";
    private static final String BASE_DIR = System.getProperty("user.home") + File.separator + ".tika-dl" + File.separator + "models" + File.separator + "keras";
    private static final String MODEL_DIR = BASE_DIR + File.separator + "inception-v3";
    @Field
    private File cacheDir = new File(MODEL_DIR);
    @Field
    private String modelWeightsPath = "https://github.com/USCDataScience/tika-dockers/releases/download/v0.2/inception_v3_keras_2.h5";
    @Field
    private String labelFile = "https://github.com/USCDataScience/tika-dockers/releases/download/v0.2/imagenet_class_index.json";
    @Field
    private String labelLang = "en";
    @Field
    private int imgHeight = 299;
    @Field
    private int imgWidth = 299;
    @Field
    private int imgChannels = 3;
    @Field
    private double minConfidence = 0.005;
    private ComputationGraph graph;
    private NativeImageLoader imageLoader;
    private Map<Integer, String> labelMap;

    private static synchronized File cachedDownload(File cacheDir, URI uri) throws IOException {
        if ("file".equals(uri.getScheme()) || uri.getScheme() == null) {
            return new File(uri);
        }
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        String[] parts = uri.toASCIIString().split("/");
        File cacheFile = new File(cacheDir, parts[parts.length - 1]);
        File successFlag = new File(cacheFile.getAbsolutePath() + ".success");
        if (cacheFile.exists() && successFlag.exists()) {
            LOG.info("Cache exist at {}. Not downloading it", (Object)cacheFile.getAbsolutePath());
        } else {
            if (successFlag.exists()) {
                successFlag.delete();
            }
            LOG.info("Cache doesn't exist. Going to make a copy");
            LOG.info("This might take a while! GET {}", (Object)uri);
            FileUtils.copyURLToFile((URL)uri.toURL(), (File)cacheFile, (int)5000, (int)60000);
            FileUtils.write((File)successFlag, (CharSequence)("CopiedAt:" + System.currentTimeMillis()), (Charset)StandardCharsets.UTF_8);
        }
        return cacheFile;
    }

    public Set<MediaType> getSupportedMimes() {
        return MEDIA_TYPES;
    }

    private File retrieveFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            LOG.warn("File {} not found in local file system. Asking the classloader", (Object)path);
            URL url = this.getClass().getClassLoader().getResource(path);
            if (url == null) {
                LOG.debug("Classloader does not know the file {}", (Object)path);
                file = null;
            } else {
                LOG.debug("Classloader knows the file {}", (Object)path);
                try {
                    file = DL4JInceptionV3Net.cachedDownload(this.cacheDir, url.toURI());
                }
                catch (IOException | URISyntaxException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        return file;
    }

    private InputStream retrieveResource(String path) throws FileNotFoundException {
        File file = new File(path);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        LOG.warn("File {} not found in local file system. Asking the classloader", (Object)path);
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    private String mayBeDownloadFile(String path) throws TikaConfigException {
        String resolvedFilePath;
        if (path.startsWith("http://") || path.startsWith("https://")) {
            LOG.debug("Config instructed to download the file, doing so.");
            try {
                resolvedFilePath = DL4JInceptionV3Net.cachedDownload(this.cacheDir, URI.create(path)).getAbsolutePath();
            }
            catch (IOException e) {
                throw new TikaConfigException(e.getMessage(), (Throwable)e);
            }
        } else {
            File file = this.retrieveFile(path);
            if (!file.exists()) {
                LOG.error("File does not exist at :: {}", (Object)path);
            }
            resolvedFilePath = file.getAbsolutePath();
        }
        return resolvedFilePath;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.modelWeightsPath = this.mayBeDownloadFile(this.modelWeightsPath);
        try (InputStream stream = this.retrieveResource(this.mayBeDownloadFile(this.labelFile));){
            this.labelMap = this.loadClassIndex(stream);
        }
        catch (IOException | ParseException e) {
            LOG.error("Could not load labels map", e);
            return;
        }
        try {
            this.imageLoader = new NativeImageLoader((long)this.imgHeight, (long)this.imgWidth, (long)this.imgChannels);
            LOG.info("Going to load Inception network...");
            long st = System.currentTimeMillis();
            try (KerasModelBuilder builder = new KerasModel().modelBuilder().modelHdf5Filename(this.modelWeightsPath).enforceTrainingConfig(false);){
                builder.inputShape(new int[]{this.imgHeight, this.imgWidth, 3});
                KerasModel model = builder.buildModel();
                this.graph = model.getComputationGraph();
                long time = System.currentTimeMillis() - st;
                LOG.info("Loaded the Inception model. Time taken={}ms", (Object)time);
            }
        }
        catch (IOException | InvalidKerasConfigurationException | UnsupportedKerasConfigurationException e) {
            throw new TikaConfigException(e.getMessage(), e);
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
    }

    public boolean isAvailable() {
        return this.graph != null;
    }

    public INDArray preProcessImage(INDArray input) {
        return input.div((Number)255.0).sub((Number)0.5).mul((Number)2.0);
    }

    public Map<Integer, String> loadClassIndex(InputStream stream) throws IOException, ParseException {
        String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        JSONObject jIndex = (JSONObject)new JSONParser().parse(content);
        HashMap<Integer, String> classMap = new HashMap<Integer, String>();
        for (Object key : jIndex.keySet()) {
            JSONArray names = (JSONArray)jIndex.get(key);
            classMap.put(Integer.parseInt(key.toString()), names.get(names.size() - 1).toString());
        }
        return classMap;
    }

    public List<RecognisedObject> recognise(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        INDArray image = this.preProcessImage(this.imageLoader.asImageMatrix(stream, false).getImage());
        INDArray scores = this.graph.outputSingle(new INDArray[]{image});
        ArrayList<RecognisedObject> result = new ArrayList<RecognisedObject>();
        int i = 0;
        while ((long)i < scores.length()) {
            if (scores.getDouble((long)i) > this.minConfidence) {
                String label = this.labelMap.get(i);
                String id = i + "";
                result.add(new RecognisedObject(label, this.labelLang, id, scores.getDouble((long)i)));
                LOG.debug("Found Object {}", (Object)label);
            }
            ++i;
        }
        return result;
    }
}

