/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.siegfried;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.tika.config.Field;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.BoundedInputStream;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.ExternalProcess;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.utils.FileProcessResult;
import org.apache.tika.utils.ProcessUtils;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiegfriedDetector
implements Detector {
    public static final String SIEGFRIED_PREFIX = "sf:";
    public static Property SIEGFRIED_STATUS = Property.externalText((String)"sf:status");
    public static Property SIEGFRIED_VERSION = Property.externalText((String)"sf:sf_version");
    public static Property SIEGFRIED_SIGNATURE = Property.externalText((String)"sf:signature");
    public static Property SIEGFRIED_IDENTIFIERS_NAME = Property.externalTextBag((String)"sf:identifiers_name");
    public static Property SIEGFRIED_IDENTIFIERS_DETAILS = Property.externalTextBag((String)"sf:identifiers_details");
    public static Property SIEGFRIED_ERRORS = Property.externalTextBag((String)"sf:errors");
    public static String ID = "id";
    public static String FORMAT = "format";
    public static String VERSION = "version";
    public static String MIME = "mime";
    public static String WARNING = "warning";
    public static String BASIS = "basis";
    public static String ERRORS = "errors";
    private static final Logger LOGGER = LoggerFactory.getLogger(SiegfriedDetector.class);
    private static final long DEFAULT_TIMEOUT_MS = 60000L;
    private static final String DEFAULT_SIEGFRIED_PATH = "sf";
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static boolean HAS_WARNED = false;
    private Boolean hasSiegfriedCommand = null;
    private String siegfriedPath = "sf";
    private int maxBytes = 1000000;
    private long timeoutMs = 60000L;
    private boolean useMime = false;

    public static boolean checkHasSiegfried(String siegfriedCommandPath) {
        String[] commandline = new String[]{siegfriedCommandPath, "-version"};
        return ExternalParser.check((String[])commandline, (int[])new int[0]);
    }

    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (this.hasSiegfriedCommand == null) {
            this.hasSiegfriedCommand = SiegfriedDetector.checkHasSiegfried(this.siegfriedPath);
        }
        if (!this.hasSiegfriedCommand.booleanValue()) {
            if (!HAS_WARNED) {
                LOGGER.warn("'siegfried' command isn't working: '" + this.siegfriedPath + "'");
                HAS_WARNED = true;
            }
            return MediaType.OCTET_STREAM;
        }
        TikaInputStream tis = TikaInputStream.cast((InputStream)input);
        if (tis != null) {
            return this.detectOnPath(tis.getPath(), metadata);
        }
        input.mark(this.maxBytes);
        try {
            MediaType mediaType;
            try (TemporaryResources tmp = new TemporaryResources();){
                Path tmpFile = tmp.createTempFile();
                Files.copy((InputStream)new BoundedInputStream((long)this.maxBytes, input), tmpFile, StandardCopyOption.REPLACE_EXISTING);
                mediaType = this.detectOnPath(tmpFile, metadata);
            }
            return mediaType;
        }
        finally {
            input.reset();
        }
    }

    @Field
    public void setUseMime(boolean useMime) {
        this.useMime = useMime;
    }

    public boolean isUseMime() {
        return this.useMime;
    }

    private MediaType detectOnPath(Path path, Metadata metadata) throws IOException {
        String[] args = new String[]{ProcessUtils.escapeCommandLine((String)this.siegfriedPath), "-json", ProcessUtils.escapeCommandLine((String)path.toAbsolutePath().toString())};
        ProcessBuilder builder = new ProcessBuilder(args);
        FileProcessResult result = ProcessUtils.execute((ProcessBuilder)builder, (long)this.timeoutMs, (int)1000000, (int)1000);
        return SiegfriedDetector.processResult(result, metadata, this.useMime);
    }

    protected static MediaType processResult(FileProcessResult result, Metadata metadata, boolean returnMime) {
        JsonNode root;
        metadata.set(ExternalProcess.EXIT_VALUE, result.getExitValue());
        metadata.set(ExternalProcess.IS_TIMEOUT, result.isTimeout());
        if (result.isTimeout()) {
            metadata.set(SIEGFRIED_STATUS, STATUS.TIMEOUT.name());
            return MediaType.OCTET_STREAM;
        }
        if (result.getExitValue() != 0) {
            metadata.set(SIEGFRIED_STATUS, STATUS.CRASH.name());
            return MediaType.OCTET_STREAM;
        }
        try {
            root = OBJECT_MAPPER.readTree(result.getStdout());
        }
        catch (JsonProcessingException e) {
            metadata.set(SIEGFRIED_STATUS, STATUS.JSON_PARSE_EXCEPTION.name());
            return MediaType.OCTET_STREAM;
        }
        if (root.has("siegfried")) {
            String siegfriedVersion = root.get("siegfried").asText("");
            metadata.set(SIEGFRIED_VERSION, siegfriedVersion);
        }
        if (root.has("signature")) {
            String sig = root.get("signature").asText("");
            metadata.set(SIEGFRIED_SIGNATURE, sig);
        }
        if (root.has("identifiers")) {
            for (JsonNode n : root.get("identifiers")) {
                if (!n.has("name") || !n.has("details")) continue;
                String name = n.get("name").asText("");
                String details = n.get("details").asText("");
                metadata.add(SIEGFRIED_IDENTIFIERS_NAME, name);
                metadata.add(SIEGFRIED_IDENTIFIERS_DETAILS, details);
            }
        }
        MediaType mt = MediaType.OCTET_STREAM;
        if (root.has("files")) {
            for (JsonNode file : root.get("files")) {
                if (file.has(ERRORS)) {
                    JsonNode errors = file.get(ERRORS);
                    if (errors.isTextual()) {
                        metadata.add(SIEGFRIED_ERRORS, file.get(ERRORS).asText());
                    } else if (errors.isArray()) {
                        for (JsonNode e : errors) {
                            metadata.add(SIEGFRIED_ERRORS, e.asText());
                        }
                    }
                }
                for (JsonNode match : file.get("matches")) {
                    String mimeString;
                    String ns = match.has("ns") ? match.get("ns").asText("") : "";
                    SiegfriedDetector.addNotBlank(match, "basis", metadata, SIEGFRIED_PREFIX + ns + ":" + BASIS);
                    SiegfriedDetector.addNotBlank(match, "format", metadata, SIEGFRIED_PREFIX + ns + ":" + FORMAT);
                    SiegfriedDetector.addNotBlank(match, "id", metadata, SIEGFRIED_PREFIX + ns + ":" + ID);
                    SiegfriedDetector.addNotBlank(match, "mime", metadata, SIEGFRIED_PREFIX + ns + ":" + MIME);
                    SiegfriedDetector.addNotBlank(match, "version", metadata, SIEGFRIED_PREFIX + ns + ":" + VERSION);
                    SiegfriedDetector.addNotBlank(match, "warning", metadata, SIEGFRIED_PREFIX + ns + ":" + WARNING);
                    if (!returnMime || !mt.equals((Object)MediaType.OCTET_STREAM) || !match.has("mime") || (mt = MediaType.parse((String)(mimeString = match.get("mime").asText("")))) != null) continue;
                    mt = MediaType.OCTET_STREAM;
                }
            }
        }
        return mt;
    }

    private static void addNotBlank(JsonNode node, String jsonKey, Metadata metadata, String metadataKey) {
        if (node.has(jsonKey)) {
            String val = node.get(jsonKey).asText("");
            if (StringUtils.isBlank((String)val)) {
                return;
            }
            metadata.set(metadataKey, val);
        }
    }

    @Field
    public void setSiegfriedPath(String fileCommandPath) {
        this.siegfriedPath = fileCommandPath;
        SiegfriedDetector.checkHasSiegfried(this.siegfriedPath);
    }

    @Field
    public void setMaxBytes(int maxBytes) {
        this.maxBytes = maxBytes;
    }

    @Field
    public void setTimeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    static enum STATUS {
        SUCCESS,
        TIMEOUT,
        CRASH,
        JSON_PARSE_EXCEPTION;

    }
}

