/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.client.TezClient;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.output.MROutputLegacy;
import org.apache.tez.mapreduce.processor.map.MapProcessor;
import org.apache.tez.mapreduce.processor.reduce.ReduceProcessor;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.partitioner.HashPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByOrderByMRRTest
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(GroupByOrderByMRRTest.class);

    private static DAG createDAG(Configuration conf, Map<String, LocalResource> commonLocalResources, Path stagingDir, String inputPath, String outputPath, boolean useMRSettings) throws Exception {
        Vertex finalReduceVertex;
        Vertex intermediateVertex;
        Vertex mapVertex;
        JobConf mapStageConf = new JobConf(conf);
        mapStageConf.set("mapreduce.job.map.class", MyMapper.class.getName());
        MRHelpers.translateMRConfToTez((Configuration)mapStageConf);
        JobConf iReduceStageConf = new JobConf(conf);
        iReduceStageConf.setInt("mapreduce.job.reduces", 2);
        iReduceStageConf.set("mapreduce.job.reduce.class", MyGroupByReducer.class.getName());
        iReduceStageConf.set("tez.runtime.key.class", Text.class.getName());
        iReduceStageConf.set("tez.runtime.value.class", IntWritable.class.getName());
        iReduceStageConf.setBoolean("mapred.mapper.new-api", true);
        MRHelpers.translateMRConfToTez((Configuration)iReduceStageConf);
        JobConf finalReduceConf = new JobConf(conf);
        finalReduceConf.setInt("mapreduce.job.reduces", 1);
        finalReduceConf.set("mapreduce.job.reduce.class", MyOrderByNoOpReducer.class.getName());
        finalReduceConf.set("tez.runtime.key.class", IntWritable.class.getName());
        finalReduceConf.set("tez.runtime.value.class", Text.class.getName());
        MRHelpers.translateMRConfToTez((Configuration)finalReduceConf);
        MRHelpers.configureMRApiUsage((Configuration)mapStageConf);
        MRHelpers.configureMRApiUsage((Configuration)iReduceStageConf);
        MRHelpers.configureMRApiUsage((Configuration)finalReduceConf);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        mapStageConf.writeXml((OutputStream)outputStream);
        String mapStageHistoryText = new String(outputStream.toByteArray(), "UTF-8");
        mapStageConf.set("mapreduce.job.inputformat.class", TextInputFormat.class.getName());
        mapStageConf.set("mapreduce.input.fileinputformat.inputdir", inputPath);
        mapStageConf.setBoolean("mapred.mapper.new-api", true);
        DataSourceDescriptor dsd = MRInputHelpers.configureMRInputWithLegacySplitGeneration((Configuration)mapStageConf, (Path)stagingDir, (boolean)true);
        ProcessorDescriptor mapProcessorDescriptor = (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)MapProcessor.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)mapStageConf))).setHistoryText(mapStageHistoryText);
        if (!useMRSettings) {
            mapVertex = Vertex.create((String)"initialmap", (ProcessorDescriptor)mapProcessorDescriptor);
        } else {
            mapVertex = Vertex.create((String)"initialmap", (ProcessorDescriptor)mapProcessorDescriptor, (int)-1, (Resource)MRHelpers.getResourceForMRMapper((Configuration)mapStageConf));
            mapVertex.setTaskLaunchCmdOpts(MRHelpers.getJavaOptsForMRMapper((Configuration)mapStageConf));
        }
        mapVertex.addTaskLocalFiles(commonLocalResources).addDataSource("MRInput", dsd);
        vertices.add(mapVertex);
        ByteArrayOutputStream iROutputStream = new ByteArrayOutputStream(4096);
        iReduceStageConf.writeXml((OutputStream)iROutputStream);
        String iReduceStageHistoryText = new String(iROutputStream.toByteArray(), "UTF-8");
        ProcessorDescriptor iReduceProcessorDescriptor = (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)ReduceProcessor.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)iReduceStageConf))).setHistoryText(iReduceStageHistoryText);
        if (!useMRSettings) {
            intermediateVertex = Vertex.create((String)"ireduce1", (ProcessorDescriptor)iReduceProcessorDescriptor, (int)1);
        } else {
            intermediateVertex = Vertex.create((String)"ireduce1", (ProcessorDescriptor)iReduceProcessorDescriptor, (int)1, (Resource)MRHelpers.getResourceForMRReducer((Configuration)iReduceStageConf));
            intermediateVertex.setTaskLaunchCmdOpts(MRHelpers.getJavaOptsForMRReducer((Configuration)iReduceStageConf));
        }
        intermediateVertex.addTaskLocalFiles(commonLocalResources);
        vertices.add(intermediateVertex);
        ByteArrayOutputStream finalReduceOutputStream = new ByteArrayOutputStream(4096);
        finalReduceConf.writeXml((OutputStream)finalReduceOutputStream);
        String finalReduceStageHistoryText = new String(finalReduceOutputStream.toByteArray(), "UTF-8");
        UserPayload finalReducePayload = TezUtils.createUserPayloadFromConf((Configuration)finalReduceConf);
        ProcessorDescriptor finalReduceProcessorDescriptor = (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)ReduceProcessor.class.getName()).setUserPayload(finalReducePayload)).setHistoryText(finalReduceStageHistoryText);
        if (!useMRSettings) {
            finalReduceVertex = Vertex.create((String)"finalreduce", (ProcessorDescriptor)finalReduceProcessorDescriptor, (int)1);
        } else {
            finalReduceVertex = Vertex.create((String)"finalreduce", (ProcessorDescriptor)finalReduceProcessorDescriptor, (int)1, (Resource)MRHelpers.getResourceForMRReducer((Configuration)finalReduceConf));
            finalReduceVertex.setTaskLaunchCmdOpts(MRHelpers.getJavaOptsForMRReducer((Configuration)finalReduceConf));
        }
        finalReduceVertex.addTaskLocalFiles(commonLocalResources);
        finalReduceVertex.addDataSink("MROutput", MROutputLegacy.createConfigBuilder((Configuration)finalReduceConf, TextOutputFormat.class, (String)outputPath).build());
        vertices.add(finalReduceVertex);
        DAG dag = DAG.create((String)"groupbyorderbymrrtest");
        for (Vertex v : vertices) {
            dag.addVertex(v);
        }
        OrderedPartitionedKVEdgeConfig edgeConf1 = ((OrderedPartitionedKVEdgeConfig.Builder)OrderedPartitionedKVEdgeConfig.newBuilder((String)Text.class.getName(), (String)IntWritable.class.getName(), (String)HashPartitioner.class.getName()).setFromConfiguration(conf).configureInput().useLegacyInput().done()).build();
        dag.addEdge(Edge.create((Vertex)dag.getVertex("initialmap"), (Vertex)dag.getVertex("ireduce1"), (EdgeProperty)edgeConf1.createDefaultEdgeProperty()));
        OrderedPartitionedKVEdgeConfig edgeConf2 = ((OrderedPartitionedKVEdgeConfig.Builder)OrderedPartitionedKVEdgeConfig.newBuilder((String)IntWritable.class.getName(), (String)Text.class.getName(), (String)HashPartitioner.class.getName()).setFromConfiguration(conf).configureInput().useLegacyInput().done()).build();
        dag.addEdge(Edge.create((Vertex)dag.getVertex("ireduce1"), (Vertex)dag.getVertex("finalreduce"), (EdgeProperty)edgeConf2.createDefaultEdgeProperty()));
        return dag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length != 2) {
            System.err.println("Usage: groupbyorderbymrrtest <in> <out>");
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 2;
        }
        String inputPath = otherArgs[0];
        String outputPath = otherArgs[1];
        UserGroupInformation.setConfiguration((Configuration)conf);
        TezConfiguration tezConf = new TezConfiguration(conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(new Path(outputPath))) {
            throw new FileAlreadyExistsException("Output directory " + outputPath + " already exists");
        }
        TreeMap<String, LocalResource> localResources = new TreeMap<String, LocalResource>();
        String stagingDirStr = conf.get("tez.staging-dir", TezConfiguration.TEZ_AM_STAGING_DIR_DEFAULT) + "/" + Long.toString(System.currentTimeMillis());
        Path stagingDir = new Path(stagingDirStr);
        FileSystem pathFs = stagingDir.getFileSystem((Configuration)tezConf);
        pathFs.mkdirs(new Path(stagingDirStr));
        tezConf.set("tez.staging-dir", stagingDirStr);
        stagingDir = pathFs.makeQualified(new Path(stagingDirStr));
        TezClient tezClient = TezClient.create((String)"groupbyorderbymrrtest", (TezConfiguration)tezConf);
        tezClient.start();
        LOG.info("Submitting groupbyorderbymrrtest DAG as a new Tez Application");
        try {
            DAG dag = GroupByOrderByMRRTest.createDAG(conf, localResources, stagingDir, inputPath, outputPath, true);
            tezClient.waitTillReady();
            DAGClient dagClient = tezClient.submitDAG(dag);
            DAGStatus dagStatus = dagClient.waitForCompletionWithStatusUpdates(null);
            if (dagStatus.getState() != DAGStatus.State.SUCCEEDED) {
                LOG.error("groupbyorderbymrrtest failed, state=" + dagStatus.getState() + ", diagnostics=" + dagStatus.getDiagnostics());
                int n = -1;
                return n;
            }
            LOG.info("Application completed. FinalState=" + dagStatus.getState());
            int n = 0;
            return n;
        }
        finally {
            tezClient.stop();
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration configuration = new Configuration();
        GroupByOrderByMRRTest groupByOrderByMRRTest = new GroupByOrderByMRRTest();
        int status = ToolRunner.run((Configuration)configuration, (Tool)groupByOrderByMRRTest, (String[])args);
        System.exit(status);
    }

    public static class MyOrderByNoOpReducer
    extends Reducer<IntWritable, Text, Text, IntWritable> {
        public void reduce(IntWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            for (Text word : values) {
                context.write((Object)word, (Object)key);
            }
        }
    }

    public static class MyGroupByReducer
    extends Reducer<Text, IntWritable, IntWritable, Text> {
        private IntWritable result = new IntWritable();

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)this.result, (Object)key);
        }
    }

    public static class MyMapper
    extends Mapper<Object, Text, Text, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private static final Text word = new Text();

        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            StringTokenizer itr = new StringTokenizer(value.toString());
            String deptName = "";
            if (itr.hasMoreTokens()) {
                String empName = itr.nextToken();
                if (itr.hasMoreTokens()) {
                    deptName = itr.nextToken();
                }
                if (!empName.isEmpty() && !deptName.isEmpty()) {
                    word.set(deptName);
                    context.write((Object)word, (Object)one);
                }
            }
        }
    }
}

