/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples.terasort;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Checksum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.mapreduce.examples.terasort.GenSort;
import org.apache.tez.mapreduce.examples.terasort.Random16;
import org.apache.tez.mapreduce.examples.terasort.TeraOutputFormat;
import org.apache.tez.mapreduce.examples.terasort.TeraSort;
import org.apache.tez.mapreduce.examples.terasort.Unsigned16;

public class TeraGen
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(TeraSort.class);
    public static final String NUM_ROWS = "mapreduce.terasort.num-rows";

    static long getNumberOfRows(JobContext job) {
        return job.getConfiguration().getLong(NUM_ROWS, 0L);
    }

    static void setNumberOfRows(Job job, long numRows) {
        job.getConfiguration().setLong(NUM_ROWS, numRows);
    }

    private static void usage() throws IOException {
        System.err.println("teragen <num rows> <output dir>");
    }

    private static long parseHumanLong(String str) {
        char tail = str.charAt(str.length() - 1);
        long base = 1L;
        switch (tail) {
            case 't': {
                base *= -727379968L;
                break;
            }
            case 'b': {
                base *= 1000000000L;
                break;
            }
            case 'm': {
                base *= 1000000L;
                break;
            }
            case 'k': {
                base *= 1000L;
                break;
            }
        }
        if (base != 1L) {
            str = str.substring(0, str.length() - 1);
        }
        return Long.parseLong(str) * base;
    }

    public int run(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = Job.getInstance((Configuration)this.getConf());
        if (args.length != 2) {
            TeraGen.usage();
            return 2;
        }
        TeraGen.setNumberOfRows(job, TeraGen.parseHumanLong(args[0]));
        Path outputDir = new Path(args[1]);
        if (outputDir.getFileSystem(this.getConf()).exists(outputDir)) {
            throw new IOException("Output directory " + outputDir + " already exists.");
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        job.setJobName("TeraGen");
        job.setJarByClass(TeraGen.class);
        job.setMapperClass(SortGenMapper.class);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(RangeInputFormat.class);
        job.setOutputFormatClass(TeraOutputFormat.class);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new TeraGen(), (String[])args);
        System.exit(res);
    }

    public static class SortGenMapper
    extends Mapper<LongWritable, NullWritable, Text, Text> {
        private Text key = new Text();
        private Text value = new Text();
        private Unsigned16 rand = null;
        private Unsigned16 rowId = null;
        private Unsigned16 checksum = new Unsigned16();
        private Checksum crc32 = new PureJavaCrc32();
        private Unsigned16 total = new Unsigned16();
        private static final Unsigned16 ONE = new Unsigned16(1L);
        private byte[] buffer = new byte[100];
        private Counter checksumCounter;

        public void map(LongWritable row, NullWritable ignored, Mapper.Context context) throws IOException, InterruptedException {
            if (this.rand == null) {
                this.rowId = new Unsigned16(row.get());
                this.rand = Random16.skipAhead(this.rowId);
                this.checksumCounter = context.getCounter((Enum)Counters.CHECKSUM);
            }
            Random16.nextRand(this.rand);
            GenSort.generateRecord(this.buffer, this.rand, this.rowId);
            this.key.set(this.buffer, 0, 10);
            this.value.set(this.buffer, 10, 90);
            context.write((Object)this.key, (Object)this.value);
            this.crc32.reset();
            this.crc32.update(this.buffer, 0, 100);
            this.checksum.set(this.crc32.getValue());
            this.total.add(this.checksum);
            this.rowId.add(ONE);
        }

        public void cleanup(Mapper.Context context) {
            if (this.checksumCounter != null) {
                this.checksumCounter.increment(this.total.getLow8());
            }
        }
    }

    static class RangeInputFormat
    extends InputFormat<LongWritable, NullWritable> {
        RangeInputFormat() {
        }

        public RecordReader<LongWritable, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return new RangeRecordReader();
        }

        public List<InputSplit> getSplits(JobContext job) {
            long totalRows = TeraGen.getNumberOfRows(job);
            int numSplits = job.getConfiguration().getInt("mapreduce.job.maps", 1);
            LOG.info((Object)("Generating " + totalRows + " using " + numSplits));
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            long currentRow = 0L;
            for (int split = 0; split < numSplits; ++split) {
                long goal = (long)Math.ceil((double)totalRows * (double)(split + 1) / (double)numSplits);
                splits.add(new RangeInputSplit(currentRow, goal - currentRow));
                currentRow = goal;
            }
            return splits;
        }

        static class RangeRecordReader
        extends RecordReader<LongWritable, NullWritable> {
            long startRow;
            long finishedRows;
            long totalRows;
            LongWritable key = null;

            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                this.startRow = ((RangeInputSplit)split).firstRow;
                this.finishedRows = 0L;
                this.totalRows = ((RangeInputSplit)split).rowCount;
            }

            public void close() throws IOException {
            }

            public LongWritable getCurrentKey() {
                return this.key;
            }

            public NullWritable getCurrentValue() {
                return NullWritable.get();
            }

            public float getProgress() throws IOException {
                return (float)this.finishedRows / (float)this.totalRows;
            }

            public boolean nextKeyValue() {
                if (this.key == null) {
                    this.key = new LongWritable();
                }
                if (this.finishedRows < this.totalRows) {
                    this.key.set(this.startRow + this.finishedRows);
                    ++this.finishedRows;
                    return true;
                }
                return false;
            }
        }

        static class RangeInputSplit
        extends InputSplit
        implements Writable {
            long firstRow;
            long rowCount;

            public RangeInputSplit() {
            }

            public RangeInputSplit(long offset, long length) {
                this.firstRow = offset;
                this.rowCount = length;
            }

            public long getLength() throws IOException {
                return 0L;
            }

            public String[] getLocations() throws IOException {
                return new String[0];
            }

            public void readFields(DataInput in) throws IOException {
                this.firstRow = WritableUtils.readVLong((DataInput)in);
                this.rowCount = WritableUtils.readVLong((DataInput)in);
            }

            public void write(DataOutput out) throws IOException {
                WritableUtils.writeVLong((DataOutput)out, (long)this.firstRow);
                WritableUtils.writeVLong((DataOutput)out, (long)this.rowCount);
            }
        }
    }

    public static enum Counters {
        CHECKSUM;

    }
}

