/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.processor;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.runtime.api.AbstractLogicalIOProcessor;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class SimpleProcessor
extends AbstractLogicalIOProcessor {
    protected Map<String, LogicalInput> inputs;
    protected Map<String, LogicalOutput> outputs;

    public SimpleProcessor(ProcessorContext context) {
        super(context);
    }

    public void run(Map<String, LogicalInput> _inputs, Map<String, LogicalOutput> _outputs) throws Exception {
        this.inputs = _inputs;
        this.outputs = _outputs;
        this.preOp();
        this.run();
        this.postOp();
    }

    public abstract void run() throws Exception;

    protected void preOp() throws Exception {
        if (this.getInputs() != null) {
            for (LogicalInput input : this.getInputs().values()) {
                input.start();
            }
        }
        if (this.getOutputs() != null) {
            for (LogicalOutput output : this.getOutputs().values()) {
                output.start();
            }
        }
    }

    protected void postOp() throws Exception {
    }

    public void initialize() throws Exception {
    }

    public void handleEvents(List<Event> processorEvents) {
    }

    public void close() throws Exception {
    }

    public Map<String, LogicalInput> getInputs() {
        return this.inputs;
    }

    public Map<String, LogicalOutput> getOutputs() {
        return this.outputs;
    }
}

