/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.HttpConnection;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;

public class ShuffleUtils {
    private static final Log LOG = LogFactory.getLog(ShuffleUtils.class);
    public static String SHUFFLE_HANDLER_SERVICE_ID = "mapreduce_shuffle";

    public static SecretKey getJobTokenSecretFromTokenBytes(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{meta});
        Token jt = new Token();
        jt.readFields((DataInput)in);
        SecretKey sk = JobTokenSecretManager.createSecretKey((byte[])jt.getPassword());
        return sk;
    }

    public static ByteBuffer convertJobTokenToBytes(Token<JobTokenIdentifier> jobToken) throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        jobToken.write((DataOutput)dob);
        ByteBuffer bb = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deserializeShuffleProviderMetaData(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        try {
            int port;
            in.reset(new ByteBuffer[]{meta});
            int n = port = in.readInt();
            return n;
        }
        finally {
            in.close();
        }
    }

    public static void shuffleToMemory(byte[] shuffleData, InputStream input, int decompressedLength, int compressedLength, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, Log LOG, String identifier) throws IOException {
        try {
            IFile.Reader.readToMemory(shuffleData, input, compressedLength, codec, ifileReadAhead, ifileReadAheadLength);
            LOG.info((Object)("Read " + shuffleData.length + " bytes from input for " + identifier));
        }
        catch (IOException ioe) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{input});
            throw ioe;
        }
    }

    public static void shuffleToDisk(OutputStream output, String hostIdentifier, InputStream input, long compressedLength, Log LOG, String identifier) throws IOException {
        long bytesLeft;
        try {
            int n;
            int BYTES_TO_READ = 65536;
            byte[] buf = new byte[65536];
            for (bytesLeft = compressedLength; bytesLeft > 0L; bytesLeft -= (long)n) {
                n = input.read(buf, 0, (int)Math.min(bytesLeft, 65536L));
                if (n < 0) {
                    throw new IOException("read past end of stream reading " + identifier);
                }
                output.write(buf, 0, n);
            }
            LOG.info((Object)("Read " + (compressedLength - bytesLeft) + " bytes from input for " + identifier));
            output.close();
        }
        catch (IOException ioe) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{input, output});
            throw ioe;
        }
        if (bytesLeft != 0L) {
            throw new IOException("Incomplete map output received for " + identifier + " from " + hostIdentifier + " (" + bytesLeft + " bytes missing of " + compressedLength + ")");
        }
    }

    public static StringBuilder constructBaseURIForShuffleHandler(String host, int port, int partition, String appId, boolean sslShuffle) {
        return ShuffleUtils.constructBaseURIForShuffleHandler(host + ":" + String.valueOf(port), partition, appId, sslShuffle);
    }

    public static StringBuilder constructBaseURIForShuffleHandler(String hostIdentifier, int partition, String appId, boolean sslShuffle) {
        String http_protocol = sslShuffle ? "https://" : "http://";
        StringBuilder sb = new StringBuilder(http_protocol);
        sb.append(hostIdentifier);
        sb.append("/");
        sb.append("mapOutput?job=");
        sb.append(appId.replace("application", "job"));
        sb.append("&reduce=");
        sb.append(String.valueOf(partition));
        sb.append("&map=");
        return sb;
    }

    public static URL constructInputURL(String baseURI, List<InputAttemptIdentifier> inputs, boolean keepAlive) throws MalformedURLException {
        StringBuilder url = new StringBuilder(baseURI);
        boolean first = true;
        for (InputAttemptIdentifier input : inputs) {
            if (first) {
                first = false;
                url.append(input.getPathComponent());
                continue;
            }
            url.append(",").append(input.getPathComponent());
        }
        if (keepAlive) {
            url.append("&keepAlive=true");
        }
        return new URL(url.toString());
    }

    public static HttpConnection.HttpConnectionParams constructHttpShuffleConnectionParams(Configuration conf) {
        HttpConnection.HttpConnectionParamsBuilder builder = new HttpConnection.HttpConnectionParamsBuilder();
        int connectionTimeout = conf.getInt("tez.runtime.shuffle.connect.timeout", 180000);
        int readTimeout = conf.getInt("tez.runtime.shuffle.read.timeout", 180000);
        int bufferSize = conf.getInt("tez.runtime.shuffle.buffersize", 8192);
        boolean keepAlive = conf.getBoolean("tez.runtime.shuffle.keep-alive.enabled", false);
        int keepAliveMaxConnections = conf.getInt("tez.runtime.shuffle.keep-alive.max.connections", 20);
        if (keepAlive) {
            System.setProperty("sun.net.http.errorstream.enableBuffering", "true");
            System.setProperty("http.maxConnections", String.valueOf(keepAliveMaxConnections));
            LOG.info((Object)("Set keepAlive max connections: " + keepAliveMaxConnections));
        }
        builder.setTimeout(connectionTimeout, readTimeout).setBufferSize(bufferSize).setKeepAlive(keepAlive, keepAliveMaxConnections);
        boolean sslShuffle = conf.getBoolean("tez.runtime.shuffle.ssl.enable", false);
        builder.setSSL(sslShuffle, conf);
        return builder.build();
    }

    public static String stringify(ShuffleUserPayloads.DataMovementEventPayloadProto dmProto) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (dmProto.hasEmptyPartitions()) {
            sb.append("hasEmptyPartitions: ").append(dmProto.hasEmptyPartitions()).append(", ");
        }
        sb.append("host: " + dmProto.getHost()).append(", ");
        sb.append("port: " + dmProto.getPort()).append(", ");
        sb.append("pathComponent: " + dmProto.getPathComponent()).append(", ");
        sb.append("runDuration: " + dmProto.getRunDuration()).append(", ");
        if (dmProto.hasData()) {
            sb.append(", ").append("hasDataInEvent: " + dmProto.hasData());
        }
        sb.append("]");
        return sb.toString();
    }
}

