/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.impl.MapHost;
import org.apache.tez.runtime.library.common.shuffle.impl.MapOutput;
import org.apache.tez.runtime.library.common.shuffle.impl.MergeManager;
import org.apache.tez.runtime.library.common.shuffle.impl.Shuffle;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleClientMetrics;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleHeader;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleScheduler;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.apache.tez.runtime.library.common.sort.impl.TezSpillRecord;
import org.apache.tez.runtime.library.shuffle.common.HttpConnection;
import org.apache.tez.runtime.library.shuffle.common.ShuffleUtils;

class Fetcher
extends Thread {
    private static final Log LOG = LogFactory.getLog(Fetcher.class);
    private final Configuration conf;
    private final boolean localDiskFetchEnabled;
    private static final String SHUFFLE_ERR_GRP_NAME = "Shuffle Errors";
    private final TezCounter connectionErrs;
    private final TezCounter ioErrs;
    private final TezCounter wrongLengthErrs;
    private final TezCounter badIdErrs;
    private final TezCounter wrongMapErrs;
    private final TezCounter wrongReduceErrs;
    private final MergeManager merger;
    private final ShuffleScheduler scheduler;
    private final ShuffleClientMetrics metrics;
    private final Shuffle shuffle;
    private final int id;
    private final String logIdentifier;
    private static int nextId = 0;
    private int currentPartition = -1;
    private final CompressionCodec codec;
    private final SecretKey jobTokenSecret;
    private volatile boolean stopped = false;
    private final boolean ifileReadAhead;
    private final int ifileReadAheadLength;
    private LinkedHashSet<InputAttemptIdentifier> remaining;
    volatile HttpURLConnection connection;
    volatile DataInputStream input;
    HttpConnection httpConnection;
    HttpConnection.HttpConnectionParams httpConnectionParams;
    static final String localhostName = NetUtils.getHostname();
    private Object cleanupLock = new Object();
    private static InputAttemptIdentifier[] EMPTY_ATTEMPT_ID_ARRAY = new InputAttemptIdentifier[0];

    public Fetcher(HttpConnection.HttpConnectionParams httpConnectionParams, ShuffleScheduler scheduler, MergeManager merger, ShuffleClientMetrics metrics, Shuffle shuffle, SecretKey jobTokenSecret, boolean ifileReadAhead, int ifileReadAheadLength, CompressionCodec codec, InputContext inputContext, Configuration conf, boolean localDiskFetchEnabled) throws IOException {
        this.setDaemon(true);
        this.scheduler = scheduler;
        this.merger = merger;
        this.metrics = metrics;
        this.shuffle = shuffle;
        this.id = ++nextId;
        this.jobTokenSecret = jobTokenSecret;
        this.ioErrs = inputContext.getCounters().findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.IO_ERROR.toString());
        this.wrongLengthErrs = inputContext.getCounters().findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.WRONG_LENGTH.toString());
        this.badIdErrs = inputContext.getCounters().findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.BAD_ID.toString());
        this.wrongMapErrs = inputContext.getCounters().findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.WRONG_MAP.toString());
        this.connectionErrs = inputContext.getCounters().findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.CONNECTION.toString());
        this.wrongReduceErrs = inputContext.getCounters().findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.WRONG_REDUCE.toString());
        this.ifileReadAhead = ifileReadAhead;
        this.ifileReadAheadLength = ifileReadAheadLength;
        this.httpConnectionParams = httpConnectionParams;
        this.codec = codec != null ? codec : null;
        this.conf = conf;
        this.localDiskFetchEnabled = localDiskFetchEnabled;
        this.logIdentifier = "fetcher [" + TezUtilsInternal.cleanVertexName((String)inputContext.getSourceVertexName()) + "] #" + this.id + " " + localhostName;
        this.setName(this.logIdentifier);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.stopped && !Thread.currentThread().isInterrupted()) {
                this.remaining = null;
                MapHost host = null;
                try {
                    this.merger.waitForInMemoryMerge();
                    host = this.scheduler.getHost();
                    this.metrics.threadBusy();
                    String hostPort = host.getHostIdentifier();
                    String hostname = hostPort.substring(0, hostPort.indexOf(":"));
                    if (this.localDiskFetchEnabled && hostname.equals(System.getenv(ApplicationConstants.Environment.NM_HOST.toString()))) {
                        this.setupLocalDiskFetch(host);
                        continue;
                    }
                    this.copyFromHost(host);
                }
                finally {
                    this.cleanupCurrentConnection(false);
                    if (host == null) continue;
                    this.scheduler.freeHost(host);
                    this.metrics.threadFree();
                }
            }
            return;
        }
        catch (InterruptedException ie) {
            return;
        }
        catch (Throwable t) {
            this.shuffle.reportException(t);
        }
    }

    public void shutDown() throws InterruptedException {
        this.stopped = true;
        this.interrupt();
        this.cleanupCurrentConnection(true);
        try {
            this.join(5000L);
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)("Got interrupt while joining " + this.getName()), (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupCurrentConnection(boolean disconnect) {
        Object object = this.cleanupLock;
        synchronized (object) {
            try {
                if (this.httpConnection != null) {
                    this.httpConnection.cleanup(disconnect);
                }
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Exception while shutting down fetcher " + this.logIdentifier), (Throwable)e);
                }
                LOG.info((Object)("Exception while shutting down fetcher " + this.logIdentifier + ": " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void copyFromHost(MapHost host) throws IOException {
        List<InputAttemptIdentifier> srcAttempts = this.scheduler.getMapsForHost(host);
        this.currentPartition = host.getPartitionId();
        if (srcAttempts.size() == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetcher " + this.id + " going to fetch from " + host + " for: " + srcAttempts + ", partitionId: " + this.currentPartition));
        }
        this.remaining = new LinkedHashSet<InputAttemptIdentifier>(srcAttempts);
        boolean connectSucceeded = false;
        try {
            URL url = ShuffleUtils.constructInputURL(host.getBaseUrl(), srcAttempts, this.httpConnectionParams.getKeepAlive());
            this.httpConnection = new HttpConnection(url, this.httpConnectionParams, this.logIdentifier, this.jobTokenSecret);
            connectSucceeded = this.httpConnection.connect();
            if (this.stopped) {
                LOG.info((Object)"Detected fetcher has been shutdown after connection establishment. Returning");
                this.cleanupCurrentConnection(true);
                this.putBackRemainingMapOutputs(host);
                return;
            }
            this.input = this.httpConnection.getInputStream();
            this.httpConnection.validate();
        }
        catch (IOException ie) {
            if (this.stopped) {
                LOG.info((Object)"Not reporting fetch failure, since an Exception was caught after shutdown");
                this.cleanupCurrentConnection(true);
                this.putBackRemainingMapOutputs(host);
                return;
            }
            this.ioErrs.increment(1L);
            if (!connectSucceeded) {
                LOG.warn((Object)("Failed to connect to " + host + " with " + this.remaining.size() + " inputs"), (Throwable)ie);
                this.connectionErrs.increment(1L);
            } else {
                LOG.warn((Object)("Failed to verify reply after connecting to " + host + " with " + this.remaining.size() + " inputs pending"), (Throwable)ie);
            }
            for (InputAttemptIdentifier left : this.remaining) {
                this.scheduler.copyFailed(left, host, connectSucceeded, !connectSucceeded);
            }
            this.putBackRemainingMapOutputs(host);
            return;
        }
        try {
            Object[] failedTasks = null;
            while (!this.remaining.isEmpty() && failedTasks == null) {
                failedTasks = this.copyMapOutput(host, this.input);
            }
            if (failedTasks != null && failedTasks.length > 0) {
                LOG.warn((Object)("copyMapOutput failed for tasks " + Arrays.toString(failedTasks)));
                for (Object left : failedTasks) {
                    this.scheduler.copyFailed((InputAttemptIdentifier)left, host, true, false);
                }
            }
            this.cleanupCurrentConnection(false);
            if (failedTasks == null && !this.remaining.isEmpty()) {
                throw new IOException("server didn't return all expected map outputs: " + this.remaining.size() + " left.");
            }
        }
        finally {
            this.putBackRemainingMapOutputs(host);
        }
    }

    @VisibleForTesting
    protected void putBackRemainingMapOutputs(MapHost host) {
        boolean isFirst = true;
        InputAttemptIdentifier first = null;
        for (InputAttemptIdentifier left : this.remaining) {
            if (isFirst) {
                first = left;
                isFirst = false;
                continue;
            }
            this.scheduler.putBackKnownMapOutput(host, left);
        }
        if (first != null) {
            this.scheduler.putBackKnownMapOutput(host, first);
        }
    }

    private InputAttemptIdentifier[] copyMapOutput(MapHost host, DataInputStream input) {
        MapOutput mapOutput = null;
        InputAttemptIdentifier srcAttemptId = null;
        long decompressedLength = -1L;
        long compressedLength = -1L;
        try {
            long startTime = System.currentTimeMillis();
            int forReduce = -1;
            try {
                ShuffleHeader header = new ShuffleHeader();
                header.readFields(input);
                if (!header.mapId.startsWith("attempt")) {
                    throw new IllegalArgumentException("Invalid header received: " + header.mapId + " partition: " + header.forReduce);
                }
                srcAttemptId = this.scheduler.getIdentifierForFetchedOutput(header.mapId, header.forReduce);
                compressedLength = header.compressedLength;
                decompressedLength = header.uncompressedLength;
                forReduce = header.forReduce;
            }
            catch (IllegalArgumentException e) {
                this.badIdErrs.increment(1L);
                LOG.warn((Object)"Invalid map id ", (Throwable)e);
                return new InputAttemptIdentifier[]{this.getNextRemainingAttempt()};
            }
            if (!this.verifySanity(compressedLength, decompressedLength, forReduce, this.remaining, srcAttemptId)) {
                if (srcAttemptId == null) {
                    LOG.warn((Object)("Was expecting " + this.getNextRemainingAttempt() + " but got null"));
                    srcAttemptId = this.getNextRemainingAttempt();
                }
                assert (srcAttemptId != null);
                return new InputAttemptIdentifier[]{srcAttemptId};
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("header: " + srcAttemptId + ", len: " + compressedLength + ", decomp len: " + decompressedLength));
            }
            try {
                mapOutput = this.merger.reserve(srcAttemptId, decompressedLength, compressedLength, this.id);
            }
            catch (IOException e) {
                this.ioErrs.increment(1L);
                this.scheduler.reportLocalError(e);
                return EMPTY_ATTEMPT_ID_ARRAY;
            }
            if (mapOutput.getType() == MapOutput.Type.WAIT) {
                LOG.info((Object)("fetcher#" + this.id + " - MergerManager returned Status.WAIT ..."));
                return EMPTY_ATTEMPT_ID_ARRAY;
            }
            LOG.info((Object)("fetcher#" + this.id + " about to shuffle output of map " + mapOutput.getAttemptIdentifier() + " decomp: " + decompressedLength + " len: " + compressedLength + " to " + (Object)((Object)mapOutput.getType())));
            if (mapOutput.getType() == MapOutput.Type.MEMORY) {
                ShuffleUtils.shuffleToMemory(mapOutput.getMemory(), input, (int)decompressedLength, (int)compressedLength, this.codec, this.ifileReadAhead, this.ifileReadAheadLength, LOG, mapOutput.getAttemptIdentifier().toString());
            } else if (mapOutput.getType() == MapOutput.Type.DISK) {
                ShuffleUtils.shuffleToDisk(mapOutput.getDisk(), host.getHostIdentifier(), input, compressedLength, LOG, mapOutput.getAttemptIdentifier().toString());
            } else {
                throw new IOException("Unknown mapOutput type while fetching shuffle data:" + (Object)((Object)mapOutput.getType()));
            }
            long endTime = System.currentTimeMillis();
            this.scheduler.copySucceeded(srcAttemptId, host, compressedLength, decompressedLength, endTime - startTime, mapOutput);
            this.remaining.remove(srcAttemptId);
            this.metrics.successFetch();
            return null;
        }
        catch (IOException ioe) {
            if (this.stopped) {
                LOG.info((Object)("Not reporting fetch failure for exception during data copy: [" + ioe.getClass().getName() + ", " + ioe.getMessage() + "]"));
                this.cleanupCurrentConnection(true);
                if (mapOutput != null) {
                    mapOutput.abort();
                }
                return EMPTY_ATTEMPT_ID_ARRAY;
            }
            this.ioErrs.increment(1L);
            if (srcAttemptId == null || mapOutput == null) {
                LOG.info((Object)("fetcher#" + this.id + " failed to read map header" + srcAttemptId + " decomp: " + decompressedLength + ", " + compressedLength), (Throwable)ioe);
                if (srcAttemptId == null) {
                    return this.remaining.toArray(new InputAttemptIdentifier[this.remaining.size()]);
                }
                return new InputAttemptIdentifier[]{srcAttemptId};
            }
            LOG.warn((Object)("Failed to shuffle output of " + srcAttemptId + " from " + host.getHostIdentifier()), (Throwable)ioe);
            mapOutput.abort();
            this.metrics.failedFetch();
            return new InputAttemptIdentifier[]{srcAttemptId};
        }
    }

    private boolean verifySanity(long compressedLength, long decompressedLength, int forReduce, Set<InputAttemptIdentifier> remaining, InputAttemptIdentifier srcAttemptId) {
        if (compressedLength < 0L || decompressedLength < 0L) {
            this.wrongLengthErrs.increment(1L);
            LOG.warn((Object)(this.getName() + " invalid lengths in map output header: id: " + srcAttemptId + " len: " + compressedLength + ", decomp len: " + decompressedLength));
            return false;
        }
        if (forReduce != this.currentPartition) {
            this.wrongReduceErrs.increment(1L);
            LOG.warn((Object)(this.getName() + " data for the wrong partition map: " + srcAttemptId + " len: " + compressedLength + " decomp len: " + decompressedLength + " for partition " + forReduce + ", expected partition: " + this.currentPartition));
            return false;
        }
        if (!remaining.contains(srcAttemptId)) {
            this.wrongMapErrs.increment(1L);
            LOG.warn((Object)("Invalid map-output! Received output for " + srcAttemptId));
            return false;
        }
        return true;
    }

    private InputAttemptIdentifier getNextRemainingAttempt() {
        if (this.remaining.size() > 0) {
            return (InputAttemptIdentifier)this.remaining.iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void setupLocalDiskFetch(MapHost host) throws InterruptedException {
        List<InputAttemptIdentifier> srcAttempts = this.scheduler.getMapsForHost(host);
        this.currentPartition = host.getPartitionId();
        if (srcAttempts.size() == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetcher " + this.id + " going to fetch (local disk) from " + host + " for: " + srcAttempts + ", partitionId: " + this.currentPartition));
        }
        this.remaining = new LinkedHashSet<InputAttemptIdentifier>(srcAttempts);
        try {
            Iterator iter = this.remaining.iterator();
            while (iter.hasNext()) {
                InputAttemptIdentifier srcAttemptId = (InputAttemptIdentifier)iter.next();
                MapOutput mapOutput = null;
                try {
                    long startTime = System.currentTimeMillis();
                    Path filename = this.getShuffleInputFileName(srcAttemptId.getPathComponent(), null);
                    TezIndexRecord indexRecord = this.getIndexRecord(srcAttemptId.getPathComponent(), this.currentPartition);
                    mapOutput = this.getMapOutputForDirectDiskFetch(srcAttemptId, filename, indexRecord);
                    long endTime = System.currentTimeMillis();
                    this.scheduler.copySucceeded(srcAttemptId, host, indexRecord.getPartLength(), indexRecord.getRawLength(), endTime - startTime, mapOutput);
                    iter.remove();
                    this.metrics.successFetch();
                }
                catch (IOException e) {
                    if (mapOutput != null) {
                        mapOutput.abort();
                    }
                    this.metrics.failedFetch();
                    this.ioErrs.increment(1L);
                    this.scheduler.copyFailed(srcAttemptId, host, true, false);
                    LOG.warn((Object)("Failed to read local disk output of " + srcAttemptId + " from " + host.getHostIdentifier()), (Throwable)e);
                }
            }
        }
        finally {
            this.putBackRemainingMapOutputs(host);
        }
    }

    @VisibleForTesting
    protected Path getShuffleInputFileName(String pathComponent, String suffix) throws IOException {
        LocalDirAllocator localDirAllocator = new LocalDirAllocator("tez.runtime.framework.local.dirs");
        suffix = suffix != null ? suffix : "";
        String pathFromLocalDir = "output/" + pathComponent + "/" + "file.out" + suffix;
        return localDirAllocator.getLocalPathToRead(pathFromLocalDir.toString(), this.conf);
    }

    @VisibleForTesting
    protected TezIndexRecord getIndexRecord(String pathComponent, int partitionId) throws IOException {
        Path indexFile = this.getShuffleInputFileName(pathComponent, ".index");
        TezSpillRecord spillRecord = new TezSpillRecord(indexFile, this.conf);
        return spillRecord.getIndex(partitionId);
    }

    @VisibleForTesting
    protected MapOutput getMapOutputForDirectDiskFetch(InputAttemptIdentifier srcAttemptId, Path filename, TezIndexRecord indexRecord) throws IOException {
        return MapOutput.createLocalDiskMapOutput(srcAttemptId, this.merger, filename, indexRecord.getStartOffset(), indexRecord.getPartLength(), true);
    }

    private static enum ShuffleErrors {
        IO_ERROR,
        WRONG_LENGTH,
        BAD_ID,
        WRONG_MAP,
        CONNECTION,
        WRONG_REDUCE;

    }
}

