/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.shuffle.common;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.runtime.library.common.sort.impl.IFileInputStream;
import org.apache.tez.runtime.library.shuffle.common.DiskFetchedInput;
import org.apache.tez.runtime.library.shuffle.common.MemoryFetchedInput;

public class ShuffleUtils {
    public static String SHUFFLE_HANDLER_SERVICE_ID = "mapreduce_shuffle";

    public static SecretKey getJobTokenSecretFromTokenBytes(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{meta});
        Token jt = new Token();
        jt.readFields((DataInput)in);
        SecretKey sk = JobTokenSecretManager.createSecretKey((byte[])jt.getPassword());
        return sk;
    }

    public static ByteBuffer convertJobTokenToBytes(Token<JobTokenIdentifier> jobToken) throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        jobToken.write((DataOutput)dob);
        ByteBuffer bb = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deserializeShuffleProviderMetaData(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        try {
            int port;
            in.reset(new ByteBuffer[]{meta});
            int n = port = in.readInt();
            return n;
        }
        finally {
            in.close();
        }
    }

    public static void shuffleToMemory(MemoryFetchedInput fetchedInput, InputStream input, int decompressedLength, int compressedLength, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, Log LOG) throws IOException {
        IFileInputStream checksumIn = new IFileInputStream(input, compressedLength, ifileReadAhead, ifileReadAheadLength);
        input = checksumIn;
        Decompressor decompressor = null;
        if (codec != null) {
            decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
            decompressor.reset();
            input = codec.createInputStream(input, decompressor);
        }
        byte[] shuffleData = fetchedInput.getBytes();
        try {
            IOUtils.readFully((InputStream)input, (byte[])shuffleData, (int)0, (int)shuffleData.length);
            LOG.info((Object)("Read " + shuffleData.length + " bytes from input for " + fetchedInput.getInputAttemptIdentifier()));
        }
        catch (IOException ioe) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{input});
            throw ioe;
        }
        finally {
            if (decompressor != null) {
                decompressor.reset();
                CodecPool.returnDecompressor((Decompressor)decompressor);
            }
        }
    }

    public static void shuffleToDisk(DiskFetchedInput fetchedInput, InputStream input, long compressedLength, Log LOG) throws IOException {
        long bytesLeft;
        OutputStream output = fetchedInput.getOutputStream();
        try {
            int n;
            int BYTES_TO_READ = 65536;
            byte[] buf = new byte[65536];
            for (bytesLeft = compressedLength; bytesLeft > 0L; bytesLeft -= (long)n) {
                n = input.read(buf, 0, (int)Math.min(bytesLeft, 65536L));
                if (n < 0) {
                    throw new IOException("read past end of stream reading " + fetchedInput.getInputAttemptIdentifier());
                }
                output.write(buf, 0, n);
            }
            LOG.info((Object)("Read " + (compressedLength - bytesLeft) + " bytes from input for " + fetchedInput.getInputAttemptIdentifier()));
            output.close();
        }
        catch (IOException ioe) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{input, output});
            throw ioe;
        }
        if (bytesLeft != 0L) {
            throw new IOException("Incomplete input received for " + fetchedInput.getInputAttemptIdentifier() + " (" + bytesLeft + " bytes missing of " + compressedLength + ")");
        }
    }

    public static StringBuilder constructBaseURIForShuffleHandler(String host, int port, int partition, ApplicationId appId) {
        StringBuilder sb = new StringBuilder("http://");
        sb.append(host);
        sb.append(":");
        sb.append(String.valueOf(port));
        sb.append("/");
        sb.append("mapOutput?job=");
        sb.append(appId.toString().replace("application", "job"));
        sb.append("&reduce=");
        sb.append(String.valueOf(partition));
        sb.append("&map=");
        return sb;
    }
}

