/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.PriorityQueue;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.library.common.Constants;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TezMerger {
    private static final Log LOG = LogFactory.getLog(TezMerger.class);
    private static LocalDirAllocator lDirAlloc = new LocalDirAllocator("tez.runtime.local.dirs");

    public static TezRawKeyValueIterator merge(Configuration conf, FileSystem fs, Class keyClass, Class valueClass, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int ifileBufferSize, Path[] inputs, boolean deleteInputs, int mergeFactor, Path tmpDir, RawComparator comparator, Progressable reporter, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException {
        return new MergeQueue(conf, fs, inputs, deleteInputs, codec, ifileReadAhead, ifileReadAheadLength, ifileBufferSize, false, comparator, reporter, null).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter, bytesReadCounter, mergePhase);
    }

    public static TezRawKeyValueIterator merge(Configuration conf, FileSystem fs, Class keyClass, Class valueClass, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int ifileBufferSize, Path[] inputs, boolean deleteInputs, int mergeFactor, Path tmpDir, RawComparator comparator, Progressable reporter, TezCounter readsCounter, TezCounter writesCounter, TezCounter mergedMapOutputsCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException {
        return new MergeQueue(conf, fs, inputs, deleteInputs, codec, ifileReadAhead, ifileReadAheadLength, ifileBufferSize, false, comparator, reporter, mergedMapOutputsCounter).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter, bytesReadCounter, mergePhase);
    }

    public static TezRawKeyValueIterator merge(Configuration conf, FileSystem fs, Class keyClass, Class valueClass, List<Segment> segments, int mergeFactor, Path tmpDir, RawComparator comparator, Progressable reporter, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException {
        return TezMerger.merge(conf, fs, keyClass, valueClass, segments, mergeFactor, tmpDir, comparator, reporter, false, readsCounter, writesCounter, bytesReadCounter, mergePhase);
    }

    public static <K, V> TezRawKeyValueIterator merge(Configuration conf, FileSystem fs, Class keyClass, Class valueClass, List<Segment> segments, int mergeFactor, Path tmpDir, RawComparator comparator, Progressable reporter, boolean sortSegments, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException {
        return new MergeQueue(conf, fs, segments, comparator, reporter, sortSegments, false).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter, bytesReadCounter, mergePhase);
    }

    public static <K, V> TezRawKeyValueIterator merge(Configuration conf, FileSystem fs, Class keyClass, Class valueClass, CompressionCodec codec, List<Segment> segments, int mergeFactor, Path tmpDir, RawComparator comparator, Progressable reporter, boolean sortSegments, boolean considerFinalMergeForProgress, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException {
        return new MergeQueue(conf, fs, segments, comparator, reporter, sortSegments, codec, considerFinalMergeForProgress).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter, bytesReadCounter, mergePhase);
    }

    public static <K, V> TezRawKeyValueIterator merge(Configuration conf, FileSystem fs, Class keyClass, Class valueClass, CompressionCodec codec, List<Segment> segments, int mergeFactor, int inMemSegments, Path tmpDir, RawComparator comparator, Progressable reporter, boolean sortSegments, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException {
        return new MergeQueue(conf, fs, segments, comparator, reporter, sortSegments, codec, false).merge(keyClass, valueClass, mergeFactor, inMemSegments, tmpDir, readsCounter, writesCounter, bytesReadCounter, mergePhase);
    }

    public static <K, V> void writeFile(TezRawKeyValueIterator records, IFile.Writer writer, Progressable progressable, long recordsBeforeProgress) throws IOException {
        long recordCtr = 0L;
        while (records.next()) {
            writer.append(records.getKey(), records.getValue());
            if (recordCtr++ % recordsBeforeProgress != 0L) continue;
            progressable.progress();
        }
    }

    private static class EmptyIterator
    implements TezRawKeyValueIterator {
        final Progress progress = new Progress();

        EmptyIterator() {
            this.progress.set(1.0f);
        }

        @Override
        public DataInputBuffer getKey() throws IOException {
            throw new RuntimeException("No keys on an empty iterator");
        }

        @Override
        public DataInputBuffer getValue() throws IOException {
            throw new RuntimeException("No values on an empty iterator");
        }

        @Override
        public boolean next() throws IOException {
            return false;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public Progress getProgress() {
            return this.progress;
        }
    }

    private static class MergeQueue<K, V>
    extends PriorityQueue<Segment>
    implements TezRawKeyValueIterator {
        Configuration conf;
        FileSystem fs;
        CompressionCodec codec;
        boolean ifileReadAhead = true;
        int ifileReadAheadLength = 0x400000;
        int ifileBufferSize = -1;
        long recordsBeforeProgress = 10000L;
        List<Segment> segments = new ArrayList<Segment>();
        RawComparator comparator;
        private long totalBytesProcessed;
        private float progPerByte;
        private Progress mergeProgress = new Progress();
        private final boolean considerFinalMergeForProgress;
        Progressable reporter;
        DataInputBuffer key;
        final DataInputBuffer value = new DataInputBuffer();
        final DataInputBuffer diskIFileValue = new DataInputBuffer();
        Segment minSegment;
        Comparator<Segment> segmentComparator = new Comparator<Segment>(){

            @Override
            public int compare(Segment o1, Segment o2) {
                if (o1.getLength() == o2.getLength()) {
                    return 0;
                }
                return o1.getLength() < o2.getLength() ? -1 : 1;
            }
        };

        public MergeQueue(Configuration conf, FileSystem fs, Path[] inputs, boolean deleteInputs, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int ifileBufferSize, boolean considerFinalMergeForProgress, RawComparator comparator, Progressable reporter, TezCounter mergedMapOutputsCounter) throws IOException {
            this.conf = conf;
            this.fs = fs;
            this.codec = codec;
            this.comparator = comparator;
            this.reporter = reporter;
            this.considerFinalMergeForProgress = considerFinalMergeForProgress;
            for (Path file : inputs) {
                LOG.debug((Object)("MergeQ: adding: " + file));
                this.segments.add(new Segment(conf, fs, file, codec, ifileReadAhead, ifileReadAheadLength, ifileBufferSize, !deleteInputs, file.toString().endsWith(Constants.MERGED_OUTPUT_PREFIX) ? null : mergedMapOutputsCounter));
            }
            Collections.sort(this.segments, this.segmentComparator);
        }

        public MergeQueue(Configuration conf, FileSystem fs, List<Segment> segments, RawComparator comparator, Progressable reporter, boolean sortSegments, boolean considerFinalMergeForProgress) {
            this.conf = conf;
            this.fs = fs;
            this.comparator = comparator;
            this.segments = segments;
            this.reporter = reporter;
            this.considerFinalMergeForProgress = considerFinalMergeForProgress;
            if (sortSegments) {
                Collections.sort(segments, this.segmentComparator);
            }
        }

        public MergeQueue(Configuration conf, FileSystem fs, List<Segment> segments, RawComparator comparator, Progressable reporter, boolean sortSegments, CompressionCodec codec, boolean considerFinalMergeForProgress) {
            this(conf, fs, segments, comparator, reporter, sortSegments, considerFinalMergeForProgress);
            this.codec = codec;
        }

        @Override
        public void close() throws IOException {
            Segment segment;
            while ((segment = (Segment)this.pop()) != null) {
                segment.close();
            }
        }

        @Override
        public DataInputBuffer getKey() throws IOException {
            return this.key;
        }

        @Override
        public DataInputBuffer getValue() throws IOException {
            return this.value;
        }

        private void adjustPriorityQueue(Segment reader) throws IOException {
            long startPos = reader.getPosition();
            boolean hasNext = reader.nextRawKey();
            long endPos = reader.getPosition();
            this.totalBytesProcessed += endPos - startPos;
            this.mergeProgress.set((float)this.totalBytesProcessed * this.progPerByte);
            if (hasNext) {
                this.adjustTop();
            } else {
                this.pop();
                reader.close();
            }
        }

        @Override
        public boolean next() throws IOException {
            if (this.size() == 0) {
                return false;
            }
            if (this.minSegment != null) {
                this.adjustPriorityQueue(this.minSegment);
                if (this.size() == 0) {
                    this.minSegment = null;
                    return false;
                }
            }
            this.minSegment = (Segment)this.top();
            if (!this.minSegment.inMemory()) {
                this.value.reset(this.diskIFileValue.getData(), this.diskIFileValue.getLength());
            }
            long startPos = this.minSegment.getPosition();
            this.key = this.minSegment.getKey();
            this.minSegment.getValue(this.value);
            long endPos = this.minSegment.getPosition();
            this.totalBytesProcessed += endPos - startPos;
            this.mergeProgress.set((float)this.totalBytesProcessed * this.progPerByte);
            return true;
        }

        protected boolean lessThan(Object a, Object b) {
            DataInputBuffer key1 = ((Segment)a).getKey();
            DataInputBuffer key2 = ((Segment)b).getKey();
            int s1 = key1.getPosition();
            int l1 = key1.getLength() - s1;
            int s2 = key2.getPosition();
            int l2 = key2.getLength() - s2;
            return this.comparator.compare(key1.getData(), s1, l1, key2.getData(), s2, l2) < 0;
        }

        public TezRawKeyValueIterator merge(Class keyClass, Class valueClass, int factor, Path tmpDir, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException {
            return this.merge(keyClass, valueClass, factor, 0, tmpDir, readsCounter, writesCounter, bytesReadCounter, mergePhase);
        }

        TezRawKeyValueIterator merge(Class keyClass, Class valueClass, int factor, int inMem, Path tmpDir, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException {
            long totalBytes;
            LOG.info((Object)("Merging " + this.segments.size() + " sorted segments"));
            if (this.segments.size() == 0) {
                LOG.info((Object)"Nothing to merge. Returning an empty iterator");
                return new EmptyIterator();
            }
            int numSegments = this.segments.size();
            int origFactor = factor;
            int passNo = 1;
            if (mergePhase != null) {
                this.mergeProgress = mergePhase;
            }
            if ((totalBytes = this.computeBytesInMerges(factor, inMem)) != 0L) {
                this.progPerByte = 1.0f / (float)totalBytes;
            }
            while (true) {
                factor = this.getPassFactor(factor, passNo, numSegments - inMem);
                if (1 == passNo) {
                    factor += inMem;
                }
                ArrayList<Segment> segmentsToMerge = new ArrayList<Segment>();
                int segmentsConsidered = 0;
                int numSegmentsToConsider = factor;
                long startBytes = 0L;
                while (true) {
                    List<Segment> mStream = this.getSegmentDescriptors(numSegmentsToConsider);
                    for (Segment segment : mStream) {
                        segment.init(readsCounter, bytesReadCounter);
                        long startPos = segment.getPosition();
                        boolean hasNext = segment.nextRawKey();
                        long endPos = segment.getPosition();
                        if (hasNext) {
                            startBytes += endPos - startPos;
                            segmentsToMerge.add(segment);
                            ++segmentsConsidered;
                            continue;
                        }
                        segment.close();
                        --numSegments;
                    }
                    if (segmentsConsidered == factor || this.segments.size() == 0) break;
                    numSegmentsToConsider = factor - segmentsConsidered;
                }
                this.initialize(segmentsToMerge.size());
                this.clear();
                for (Segment segment : segmentsToMerge) {
                    this.put(segment);
                }
                if (numSegments <= factor) {
                    if (!this.considerFinalMergeForProgress) {
                        this.totalBytesProcessed = 0L;
                        totalBytes = 0L;
                        for (int i = 0; i < segmentsToMerge.size(); ++i) {
                            totalBytes += ((Segment)segmentsToMerge.get(i)).getLength();
                        }
                    }
                    if (totalBytes != 0L) {
                        this.progPerByte = 1.0f / (float)totalBytes;
                    }
                    this.totalBytesProcessed += startBytes;
                    if (totalBytes != 0L) {
                        this.mergeProgress.set((float)this.totalBytesProcessed * this.progPerByte);
                    } else {
                        this.mergeProgress.set(1.0f);
                    }
                    LOG.info((Object)("Down to the last merge-pass, with " + numSegments + " segments left of total size: " + (totalBytes - this.totalBytesProcessed) + " bytes"));
                    return this;
                }
                LOG.info((Object)("Merging " + segmentsToMerge.size() + " intermediate segments out of a total of " + (this.segments.size() + segmentsToMerge.size())));
                long bytesProcessedInPrevMerges = this.totalBytesProcessed;
                this.totalBytesProcessed += startBytes;
                long approxOutputSize = 0L;
                for (Segment s : segmentsToMerge) {
                    approxOutputSize = (long)((double)approxOutputSize + ((double)s.getLength() + ChecksumFileSystem.getApproxChkSumLength((long)s.getLength())));
                }
                Path tmpFilename = new Path(tmpDir, "intermediate").suffix("." + passNo);
                Path outputFile = lDirAlloc.getLocalPathForWrite(tmpFilename.toString(), approxOutputSize, this.conf);
                IFile.Writer writer = new IFile.Writer(this.conf, this.fs, outputFile, keyClass, valueClass, this.codec, writesCounter, null);
                TezMerger.writeFile(this, writer, this.reporter, this.recordsBeforeProgress);
                writer.close();
                this.close();
                Segment tempSegment = new Segment(this.conf, this.fs, outputFile, this.codec, this.ifileReadAhead, this.ifileReadAheadLength, this.ifileBufferSize, false);
                int pos = Collections.binarySearch(this.segments, tempSegment, this.segmentComparator);
                if (pos < 0) {
                    pos = -pos - 1;
                }
                this.segments.add(pos, tempSegment);
                numSegments = this.segments.size();
                long inputBytesOfThisMerge = this.totalBytesProcessed - bytesProcessedInPrevMerges;
                if ((totalBytes -= inputBytesOfThisMerge - tempSegment.getLength()) != 0L) {
                    this.progPerByte = 1.0f / (float)totalBytes;
                }
                ++passNo;
                factor = origFactor;
            }
        }

        private int getPassFactor(int factor, int passNo, int numSegments) {
            if (passNo > 1 || numSegments <= factor || factor == 1) {
                return factor;
            }
            int mod = (numSegments - 1) % (factor - 1);
            if (mod == 0) {
                return factor;
            }
            return mod + 1;
        }

        private List<Segment> getSegmentDescriptors(int numDescriptors) {
            if (numDescriptors > this.segments.size()) {
                ArrayList<Segment> subList = new ArrayList<Segment>(this.segments);
                this.segments.clear();
                return subList;
            }
            ArrayList<Segment> subList = new ArrayList<Segment>(this.segments.subList(0, numDescriptors));
            for (int i = 0; i < numDescriptors; ++i) {
                this.segments.remove(0);
            }
            return subList;
        }

        long computeBytesInMerges(int factor, int inMem) {
            int numSegments = this.segments.size();
            ArrayList<Long> segmentSizes = new ArrayList<Long>(numSegments);
            long totalBytes = 0L;
            int n = numSegments - inMem;
            int f = this.getPassFactor(factor, 1, n) + inMem;
            n = numSegments;
            for (int i = 0; i < numSegments; ++i) {
                segmentSizes.add(this.segments.get(i).getLength());
            }
            boolean considerFinalMerge = this.considerFinalMergeForProgress;
            while (n > f || considerFinalMerge) {
                if (n <= f) {
                    considerFinalMerge = false;
                }
                long mergedSize = 0L;
                f = Math.min(f, segmentSizes.size());
                for (int j = 0; j < f; ++j) {
                    mergedSize += ((Long)segmentSizes.remove(0)).longValue();
                }
                totalBytes += mergedSize;
                int pos = Collections.binarySearch(segmentSizes, mergedSize);
                if (pos < 0) {
                    pos = -pos - 1;
                }
                segmentSizes.add(pos, mergedSize);
                n -= f - 1;
                f = factor;
            }
            return totalBytes;
        }

        @Override
        public Progress getProgress() {
            return this.mergeProgress;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Segment<K, V> {
        IFile.Reader reader = null;
        final DataInputBuffer key = new DataInputBuffer();
        Configuration conf = null;
        FileSystem fs = null;
        Path file = null;
        boolean preserve = false;
        CompressionCodec codec = null;
        long segmentOffset = 0L;
        long segmentLength = -1L;
        boolean ifileReadAhead;
        int ifileReadAheadLength;
        int bufferSize = -1;
        TezCounter mapOutputsCounter = null;

        public Segment(Configuration conf, FileSystem fs, Path file, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int bufferSize, boolean preserve) throws IOException {
            this(conf, fs, file, codec, ifileReadAhead, ifileReadAheadLength, bufferSize, preserve, null);
        }

        public Segment(Configuration conf, FileSystem fs, Path file, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLenth, int bufferSize, boolean preserve, TezCounter mergedMapOutputsCounter) throws IOException {
            this(conf, fs, file, 0L, fs.getFileStatus(file).getLen(), codec, ifileReadAhead, ifileReadAheadLenth, bufferSize, preserve, mergedMapOutputsCounter);
        }

        public Segment(Configuration conf, FileSystem fs, Path file, long segmentOffset, long segmentLength, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int bufferSize, boolean preserve) throws IOException {
            this(conf, fs, file, segmentOffset, segmentLength, codec, ifileReadAhead, ifileReadAheadLength, bufferSize, preserve, null);
        }

        public Segment(Configuration conf, FileSystem fs, Path file, long segmentOffset, long segmentLength, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int bufferSize, boolean preserve, TezCounter mergedMapOutputsCounter) throws IOException {
            this.conf = conf;
            this.fs = fs;
            this.file = file;
            this.codec = codec;
            this.preserve = preserve;
            this.ifileReadAhead = ifileReadAhead;
            this.ifileReadAheadLength = ifileReadAheadLength;
            this.bufferSize = bufferSize;
            this.segmentOffset = segmentOffset;
            this.segmentLength = segmentLength;
            this.mapOutputsCounter = mergedMapOutputsCounter;
        }

        public Segment(IFile.Reader reader, boolean preserve) {
            this(reader, preserve, null);
        }

        public Segment(IFile.Reader reader, boolean preserve, TezCounter mapOutputsCounter) {
            this.reader = reader;
            this.preserve = preserve;
            this.segmentLength = reader.getLength();
            this.mapOutputsCounter = mapOutputsCounter;
        }

        void init(TezCounter readsCounter, TezCounter byetsReadCounter) throws IOException {
            if (this.reader == null) {
                FSDataInputStream in = this.fs.open(this.file);
                in.seek(this.segmentOffset);
                this.reader = new IFile.Reader((InputStream)in, this.segmentLength, this.codec, readsCounter, byetsReadCounter, this.ifileReadAhead, this.ifileReadAheadLength, this.bufferSize);
            }
            if (this.mapOutputsCounter != null) {
                this.mapOutputsCounter.increment(1L);
            }
        }

        boolean inMemory() {
            return this.fs == null;
        }

        DataInputBuffer getKey() {
            return this.key;
        }

        DataInputBuffer getValue(DataInputBuffer value) throws IOException {
            this.nextRawValue(value);
            return value;
        }

        public long getLength() {
            return this.reader == null ? this.segmentLength : this.reader.getLength();
        }

        boolean nextRawKey() throws IOException {
            return this.reader.nextRawKey(this.key);
        }

        void nextRawValue(DataInputBuffer value) throws IOException {
            this.reader.nextRawValue(value);
        }

        void closeReader() throws IOException {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }

        void close() throws IOException {
            this.closeReader();
            if (!this.preserve && this.fs != null) {
                this.fs.delete(this.file, false);
            }
        }

        public long getPosition() throws IOException {
            return this.reader.getPosition();
        }

        long getActualPosition() throws IOException {
            return this.segmentOffset + this.reader.getPosition();
        }

        IFile.Reader getReader() {
            return this.reader;
        }

        void reinitReader(int offset) throws IOException {
            if (!this.inMemory()) {
                this.closeReader();
                this.segmentOffset = offset;
                this.segmentLength = this.fs.getFileStatus(this.file).getLen() - this.segmentOffset;
                this.init(null, null);
            }
        }
    }
}

