/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.broadcast.output.FileBasedKVWriter;
import org.apache.tez.runtime.library.shuffle.common.ShuffleUtils;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;

public class OnFileUnorderedKVOutput
implements LogicalOutput {
    private static final Log LOG = LogFactory.getLog(OnFileUnorderedKVOutput.class);
    private TezOutputContext outputContext;
    private FileBasedKVWriter kvWriter;
    private Configuration conf;
    private boolean dataViaEventsEnabled;
    private int dataViaEventsMaxSize;

    public List<Event> initialize(TezOutputContext outputContext) throws Exception {
        this.outputContext = outputContext;
        this.conf = TezUtils.createConfFromUserPayload((byte[])outputContext.getUserPayload());
        this.conf.setStrings("tez.runtime.local.dirs", outputContext.getWorkDirs());
        this.outputContext.requestInitialMemory(0L, null);
        this.dataViaEventsEnabled = this.conf.getBoolean("tez.runtime.broadcast.data-via-events.enabled", false);
        this.dataViaEventsMaxSize = this.conf.getInt("tez.runtime.broadcast.data-via-events.max-size", 204800);
        LOG.info((Object)(this.getClass().getSimpleName() + " running with params -> " + "dataViaEventsEnabled: " + this.dataViaEventsEnabled + ", dataViaEventsMaxSize: " + this.dataViaEventsMaxSize));
        this.kvWriter = new FileBasedKVWriter(outputContext, this.conf);
        return Collections.emptyList();
    }

    public void start() {
    }

    public KeyValueWriter getWriter() throws Exception {
        return this.kvWriter;
    }

    public void handleEvents(List<Event> outputEvents) {
        throw new TezUncheckedException("Not expecting any events");
    }

    public List<Event> close() throws Exception {
        boolean outputGenerated = this.kvWriter.close();
        ShuffleUserPayloads.DataMovementEventPayloadProto.Builder payloadBuilder = ShuffleUserPayloads.DataMovementEventPayloadProto.newBuilder();
        LOG.info((Object)("Closing KVOutput: RawLength: " + this.kvWriter.getRawLength() + ", CompressedLength: " + this.kvWriter.getCompressedLength()));
        if (this.dataViaEventsEnabled && outputGenerated && this.kvWriter.getCompressedLength() <= (long)this.dataViaEventsMaxSize) {
            LOG.info((Object)("Serialzing actual data into DataMovementEvent, dataSize: " + this.kvWriter.getCompressedLength()));
            byte[] data = this.kvWriter.getData();
            ShuffleUserPayloads.DataProto.Builder dataProtoBuilder = ShuffleUserPayloads.DataProto.newBuilder();
            dataProtoBuilder.setData(ByteString.copyFrom((byte[])data));
            dataProtoBuilder.setRawLength((int)this.kvWriter.getRawLength());
            dataProtoBuilder.setCompressedLength((int)this.kvWriter.getCompressedLength());
            payloadBuilder.setData(dataProtoBuilder.build());
        }
        String host = this.getHost();
        ByteBuffer shuffleMetadata = this.outputContext.getServiceProviderMetaData(ShuffleUtils.SHUFFLE_HANDLER_SERVICE_ID);
        int shufflePort = ShuffleUtils.deserializeShuffleProviderMetaData(shuffleMetadata);
        payloadBuilder.setOutputGenerated(outputGenerated);
        if (outputGenerated) {
            payloadBuilder.setHost(host);
            payloadBuilder.setPort(shufflePort);
            payloadBuilder.setPathComponent(this.outputContext.getUniqueIdentifier());
        }
        ShuffleUserPayloads.DataMovementEventPayloadProto payloadProto = payloadBuilder.build();
        DataMovementEvent dmEvent = new DataMovementEvent(0, payloadProto.toByteArray());
        ArrayList events = Lists.newArrayListWithCapacity((int)1);
        events.add(dmEvent);
        return events;
    }

    public void setNumPhysicalOutputs(int numOutputs) {
        Preconditions.checkArgument((numOutputs == 1 ? 1 : 0) != 0, (Object)("Number of outputs can only be 1 for " + this.getClass().getName()));
    }

    @VisibleForTesting
    @InterfaceAudience.Private
    String getHost() {
        return System.getenv(ApplicationConstants.Environment.NM_HOST.toString());
    }
}

