/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.tez.common.TezUtils;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.api.Writer;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.common.sort.impl.dflt.InMemoryShuffleSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemorySortedOutput
implements LogicalOutput {
    protected InMemoryShuffleSorter sorter;
    protected int numTasks;
    protected TezOutputContext outputContext;

    public List<Event> initialize(TezOutputContext outputContext) throws IOException {
        this.outputContext = outputContext;
        this.sorter = new InMemoryShuffleSorter();
        this.sorter.initialize(outputContext, TezUtils.createConfFromUserPayload((byte[])outputContext.getUserPayload()), this.numTasks);
        return Collections.emptyList();
    }

    public Writer getWriter() throws IOException {
        return new KeyValueWriter(){

            public void write(Object key, Object value) throws IOException {
                InMemorySortedOutput.this.sorter.write(key, value);
            }
        };
    }

    public void handleEvents(List<Event> outputEvents) {
    }

    public void setNumPhysicalOutputs(int numOutputs) {
        this.numTasks = numOutputs;
    }

    public List<Event> close() throws IOException {
        this.sorter.flush();
        this.sorter.close();
        return null;
    }
}

