/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.TezInputContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.broadcast.input.BroadcastKVReader;
import org.apache.tez.runtime.library.broadcast.input.BroadcastShuffleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShuffledUnorderedKVInput
implements LogicalInput {
    private static final Log LOG = LogFactory.getLog(ShuffledUnorderedKVInput.class);
    private Configuration conf;
    private int numInputs = -1;
    private BroadcastShuffleManager shuffleManager;
    private BroadcastKVReader kvReader;

    public List<Event> initialize(TezInputContext inputContext) throws Exception {
        Preconditions.checkArgument((this.numInputs != -1 ? 1 : 0) != 0, (Object)"Number of Inputs has not been set");
        this.conf = TezUtils.createConfFromUserPayload((byte[])inputContext.getUserPayload());
        this.conf.setStrings("tez.runtime.local.dirs", inputContext.getWorkDirs());
        if (this.numInputs == 0) {
            return null;
        }
        this.shuffleManager = new BroadcastShuffleManager(inputContext, this.conf, this.numInputs);
        this.shuffleManager.run();
        this.kvReader = this.shuffleManager.createReader();
        return null;
    }

    public KeyValueReader getReader() throws Exception {
        if (this.numInputs == 0) {
            return new KeyValueReader(){

                public boolean next() throws IOException {
                    return false;
                }

                public Object getCurrentKey() throws IOException {
                    throw new RuntimeException("No data available in Input");
                }

                public Object getCurrentValue() throws IOException {
                    throw new RuntimeException("No data available in Input");
                }
            };
        }
        return this.kvReader;
    }

    public void handleEvents(List<Event> inputEvents) throws IOException {
        if (this.numInputs == 0) {
            throw new RuntimeException("No input events expected as numInputs is 0");
        }
        this.shuffleManager.handleEvents(inputEvents);
    }

    public List<Event> close() throws Exception {
        if (this.numInputs != 0) {
            this.shuffleManager.shutdown();
        }
        return null;
    }

    public void setNumPhysicalInputs(int numInputs) {
        this.numInputs = numInputs;
    }
}

