/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.util.IndexedSorter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.QuickSort;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.api.TezTaskContext;
import org.apache.tez.runtime.library.api.Partitioner;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.apache.tez.runtime.library.common.combine.Combiner;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleHeader;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;
import org.apache.tez.runtime.library.hadoop.compat.NullProgressable;

public abstract class ExternalSorter {
    private static final Log LOG = LogFactory.getLog(ExternalSorter.class);
    protected Progressable nullProgressable = new NullProgressable();
    protected TezOutputContext outputContext;
    protected Combiner combiner;
    protected Partitioner partitioner;
    protected Configuration conf;
    protected FileSystem rfs;
    protected TezTaskOutput mapOutputFile;
    protected int partitions;
    protected Class keyClass;
    protected Class valClass;
    protected RawComparator comparator;
    protected SerializationFactory serializationFactory;
    protected Serializer keySerializer;
    protected Serializer valSerializer;
    protected boolean ifileReadAhead;
    protected int ifileReadAheadLength;
    protected int ifileBufferSize;
    protected IndexedSorter sorter;
    protected CompressionCodec codec;
    protected TezCounter mapOutputByteCounter;
    protected TezCounter mapOutputRecordCounter;
    protected TezCounter fileOutputByteCounter;
    protected TezCounter spilledRecordsCounter;

    public abstract void close() throws IOException;

    public abstract void flush() throws IOException;

    public abstract void write(Object var1, Object var2) throws IOException;

    public void initialize(TezOutputContext outputContext, Configuration conf, int numOutputs) throws IOException {
        this.outputContext = outputContext;
        this.conf = conf;
        this.partitions = numOutputs;
        this.rfs = FileSystem.getLocal((Configuration)this.conf).getRaw();
        this.sorter = (IndexedSorter)ReflectionUtils.newInstance((Class)this.conf.getClass("tez.runtime.internal.sorter.class", QuickSort.class, IndexedSorter.class), (Configuration)this.conf);
        this.comparator = ConfigUtils.getIntermediateOutputKeyComparator(this.conf);
        this.keyClass = ConfigUtils.getIntermediateOutputKeyClass(this.conf);
        this.valClass = ConfigUtils.getIntermediateOutputValueClass(this.conf);
        this.serializationFactory = new SerializationFactory(this.conf);
        this.keySerializer = this.serializationFactory.getSerializer(this.keyClass);
        this.valSerializer = this.serializationFactory.getSerializer(this.valClass);
        this.mapOutputByteCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.MAP_OUTPUT_BYTES);
        this.mapOutputRecordCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS);
        this.fileOutputByteCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.MAP_OUTPUT_MATERIALIZED_BYTES);
        this.spilledRecordsCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.SPILLED_RECORDS);
        if (ConfigUtils.shouldCompressIntermediateOutput(this.conf)) {
            Class<? extends CompressionCodec> codecClass = ConfigUtils.getIntermediateOutputCompressorClass(this.conf, DefaultCodec.class);
            this.codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)this.conf);
        } else {
            this.codec = null;
        }
        this.ifileReadAhead = this.conf.getBoolean("tez.runtime.ifile.readahead", true);
        this.ifileReadAheadLength = this.ifileReadAhead ? conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000) : 0;
        this.ifileBufferSize = conf.getInt("io.file.buffer.size", -1);
        this.mapOutputFile = TezRuntimeUtils.instantiateTaskOutputManager(conf, outputContext);
        LOG.info((Object)("Instantiating Partitioner: [" + conf.get("tez.runtime.partitioner.class") + "]"));
        this.conf.setInt("tez.runtime.num.expected.partitions", this.partitions);
        this.partitioner = TezRuntimeUtils.instantiatePartitioner(this.conf);
        this.combiner = TezRuntimeUtils.instantiateCombiner(this.conf, (TezTaskContext)outputContext);
    }

    @InterfaceAudience.Private
    public TezTaskOutput getMapOutput() {
        return this.mapOutputFile;
    }

    protected void runCombineProcessor(TezRawKeyValueIterator kvIter, IFile.Writer writer) throws IOException {
        try {
            this.combiner.combine(kvIter, writer);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected void sameVolRename(Path srcPath, Path dstPath) throws IOException {
        RawLocalFileSystem rfs = (RawLocalFileSystem)this.rfs;
        File src = rfs.pathToFile(srcPath);
        File dst = rfs.pathToFile(dstPath);
        if (!dst.getParentFile().exists() && !dst.getParentFile().mkdirs()) {
            throw new IOException("Unable to rename " + src + " to " + dst + ": couldn't create parent directory");
        }
        if (!src.renameTo(dst)) {
            throw new IOException("Unable to rename " + src + " to " + dst);
        }
    }

    public InputStream getSortedStream(int partition) {
        throw new UnsupportedOperationException("getSortedStream isn't supported!");
    }

    public ShuffleHeader getShuffleHeader(int reduce) {
        throw new UnsupportedOperationException("getShuffleHeader isn't supported!");
    }

    public static class MapBufferTooSmallException
    extends IOException {
        public MapBufferTooSmallException(String s) {
            super(s);
        }
    }
}

