/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.security;

import java.util.Map;
import java.util.TreeMap;
import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.runtime.library.common.security.JobTokenIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobTokenSecretManager
extends SecretManager<JobTokenIdentifier> {
    private final SecretKey masterKey = this.generateSecret();
    private final Map<String, SecretKey> currentJobTokens = new TreeMap<String, SecretKey>();

    public static SecretKey createSecretKey(byte[] key) {
        return SecretManager.createSecretKey((byte[])key);
    }

    public static byte[] computeHash(byte[] msg, SecretKey key) {
        return JobTokenSecretManager.createPassword((byte[])msg, (SecretKey)key);
    }

    public byte[] createPassword(JobTokenIdentifier identifier) {
        byte[] result = JobTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.masterKey);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTokenForJob(String jobId, Token<JobTokenIdentifier> token) {
        SecretKey tokenSecret = JobTokenSecretManager.createSecretKey(token.getPassword());
        Map<String, SecretKey> map = this.currentJobTokens;
        synchronized (map) {
            this.currentJobTokens.put(jobId, tokenSecret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTokenForJob(String jobId) {
        Map<String, SecretKey> map = this.currentJobTokens;
        synchronized (map) {
            this.currentJobTokens.remove(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretKey retrieveTokenSecret(String jobId) throws SecretManager.InvalidToken {
        SecretKey tokenSecret = null;
        Map<String, SecretKey> map = this.currentJobTokens;
        synchronized (map) {
            tokenSecret = this.currentJobTokens.get(jobId);
        }
        if (tokenSecret == null) {
            throw new SecretManager.InvalidToken("Can't find job token for job " + jobId + " !!");
        }
        return tokenSecret;
    }

    public byte[] retrievePassword(JobTokenIdentifier identifier) throws SecretManager.InvalidToken {
        return this.retrieveTokenSecret(identifier.getJobId().toString()).getEncoded();
    }

    public JobTokenIdentifier createIdentifier() {
        return new JobTokenIdentifier();
    }
}

