/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.broadcast.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.broadcast.input.BroadcastShuffleManager;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.shuffle.impl.InMemoryReader;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.shuffle.common.FetchedInput;
import org.apache.tez.runtime.library.shuffle.common.MemoryFetchedInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastKVReader<K, V>
implements KeyValueReader {
    private static final Log LOG = LogFactory.getLog(BroadcastKVReader.class);
    private final BroadcastShuffleManager shuffleManager;
    private final CompressionCodec codec;
    private final Class<K> keyClass;
    private final Class<V> valClass;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valDeserializer;
    private final DataInputBuffer keyIn;
    private final DataInputBuffer valIn;
    private final boolean ifileReadAhead;
    private final int ifileReadAheadLength;
    private final int ifileBufferSize;
    private K key;
    private V value;
    private FetchedInput currentFetchedInput;
    private IFile.Reader currentReader;
    private int numRecordsRead = 0;

    public BroadcastKVReader(BroadcastShuffleManager shuffleManager, Configuration conf, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int ifileBufferSize) throws IOException {
        this.shuffleManager = shuffleManager;
        this.codec = codec;
        this.ifileReadAhead = ifileReadAhead;
        this.ifileReadAheadLength = ifileReadAheadLength;
        this.ifileBufferSize = ifileBufferSize;
        this.keyClass = ConfigUtils.getIntermediateInputKeyClass(conf);
        this.valClass = ConfigUtils.getIntermediateInputValueClass(conf);
        this.keyIn = new DataInputBuffer();
        this.valIn = new DataInputBuffer();
        SerializationFactory serializationFactory = new SerializationFactory(conf);
        this.keyDeserializer = serializationFactory.getDeserializer(this.keyClass);
        this.keyDeserializer.open((InputStream)this.keyIn);
        this.valDeserializer = serializationFactory.getDeserializer(this.valClass);
        this.valDeserializer.open((InputStream)this.valIn);
    }

    @Override
    public boolean next() throws IOException {
        if (this.readNextFromCurrentReader()) {
            ++this.numRecordsRead;
            return true;
        }
        boolean nextInputExists = this.moveToNextInput();
        while (nextInputExists) {
            if (this.readNextFromCurrentReader()) {
                ++this.numRecordsRead;
                return true;
            }
            nextInputExists = this.moveToNextInput();
        }
        LOG.info((Object)("Num Records read: " + this.numRecordsRead));
        return false;
    }

    @Override
    public Object getCurrentKey() throws IOException {
        return this.key;
    }

    @Override
    public Object getCurrentValue() throws IOException {
        return this.value;
    }

    private boolean readNextFromCurrentReader() throws IOException {
        if (this.currentReader == null) {
            return false;
        }
        boolean hasMore = this.currentReader.nextRawKey(this.keyIn);
        if (hasMore) {
            this.currentReader.nextRawValue(this.valIn);
            this.key = this.keyDeserializer.deserialize(this.key);
            this.value = this.valDeserializer.deserialize(this.value);
            return true;
        }
        return false;
    }

    private boolean moveToNextInput() throws IOException {
        if (this.currentReader != null) {
            this.currentReader.close();
            this.currentFetchedInput.free();
        }
        try {
            this.currentFetchedInput = this.shuffleManager.getNextInput();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted while waiting for next available input", (Throwable)e);
            throw new IOException(e);
        }
        if (this.currentFetchedInput == null) {
            return false;
        }
        this.currentReader = this.openIFileReader(this.currentFetchedInput);
        return true;
    }

    public IFile.Reader openIFileReader(FetchedInput fetchedInput) throws IOException {
        if (fetchedInput.getType() == FetchedInput.Type.MEMORY) {
            MemoryFetchedInput mfi = (MemoryFetchedInput)fetchedInput;
            return new InMemoryReader(null, mfi.getInputAttemptIdentifier(), mfi.getBytes(), 0, (int)mfi.getActualSize());
        }
        return new IFile.Reader(fetchedInput.getInputStream(), fetchedInput.getCompressedSize(), this.codec, null, this.ifileReadAhead, this.ifileReadAheadLength, this.ifileBufferSize);
    }
}

