/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import com.google.common.primitives.Ints;
import javax.annotation.Nullable;
import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.dag.api.EdgeManagerPluginOnDemand;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductCombination;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductEdgeManagerReal;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductUserPayload;
import org.apache.tez.runtime.library.utils.Grouper;

class FairCartesianProductEdgeManager
extends CartesianProductEdgeManagerReal {
    private int numPartition;
    private int positionInSrc;
    private int[] numChunkPerSrc;
    private int[] numTaskPerSrcVertexInGroup;
    private int positionInGroup;
    private int numDestConsumerPerChunk;
    private Grouper grouper = new Grouper();
    private Grouper grouperForComputeOffset = new Grouper();

    public FairCartesianProductEdgeManager(EdgeManagerPluginContext context) {
        super(context);
    }

    @Override
    public void initialize(CartesianProductUserPayload.CartesianProductConfigProto config) {
        String groupName = this.getContext().getVertexGroupName();
        String srcName = groupName != null ? groupName : this.getContext().getSourceVertexName();
        this.positionInSrc = config.getSourcesList().indexOf((Object)srcName);
        this.numPartition = config.hasNumPartitionsForFairCase() ? config.getNumPartitionsForFairCase() : (int)Math.pow(config.getMaxParallelism(), 1.0 / (double)config.getSourcesCount());
        if (config.getNumChunksCount() > 0) {
            this.numChunkPerSrc = Ints.toArray(config.getNumChunksList());
            this.grouper.init(this.getContext().getSourceVertexNumTasks() * this.numPartition, this.numChunkPerSrc[this.positionInSrc]);
            this.numTaskPerSrcVertexInGroup = Ints.toArray(config.getNumTaskPerVertexInGroupList());
            this.positionInGroup = config.getPositionInGroup();
            this.numDestConsumerPerChunk = 1;
            for (int numChunk : this.numChunkPerSrc) {
                this.numDestConsumerPerChunk *= numChunk;
            }
            this.numDestConsumerPerChunk /= this.numChunkPerSrc[this.positionInSrc];
        }
    }

    @Override
    public int routeInputErrorEventToSource(int destTaskId, int failedInputId) throws Exception {
        int chunkId = CartesianProductCombination.fromTaskId(this.numChunkPerSrc, destTaskId).getCombination().get(this.positionInSrc);
        int itemId = failedInputId - this.getItemIdOffset(chunkId) + this.grouper.getFirstItemInGroup(chunkId);
        return itemId / this.numPartition;
    }

    @Override
    public EdgeManagerPluginOnDemand.EventRouteMetadata routeDataMovementEventToDestination(int srcTaskId, int srcOutputId, int destTaskId) throws Exception {
        int itemId = srcTaskId * this.numPartition + srcOutputId;
        int chunkId = CartesianProductCombination.fromTaskId(this.numChunkPerSrc, destTaskId).getCombination().get(this.positionInSrc);
        if (this.grouper.isInGroup(itemId, chunkId)) {
            int idx = itemId - this.grouper.getFirstItemInGroup(chunkId) + this.getItemIdOffset(chunkId);
            return EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)1, (int[])new int[]{idx});
        }
        return null;
    }

    @Override
    @Nullable
    public EdgeManagerPluginOnDemand.CompositeEventRouteMetadata routeCompositeDataMovementEventToDestination(int srcTaskId, int destTaskId) throws Exception {
        int chunkId = CartesianProductCombination.fromTaskId(this.numChunkPerSrc, destTaskId).getCombination().get(this.positionInSrc);
        int firstItemInChunk = this.grouper.getFirstItemInGroup(chunkId);
        int lastItemInChunk = this.grouper.getLastItemInGroup(chunkId);
        int firstItemInSrcTask = srcTaskId * this.numPartition;
        int lastItemInSrcTask = firstItemInSrcTask + this.numPartition - 1;
        if (lastItemInChunk >= firstItemInSrcTask && firstItemInChunk <= lastItemInSrcTask) {
            int firstItem = Math.max(firstItemInChunk, firstItemInSrcTask);
            int lastItem = Math.min(lastItemInChunk, lastItemInSrcTask);
            return EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)(lastItem - firstItem + 1), (int)(firstItem - firstItemInChunk + this.getItemIdOffset(chunkId)), (int)(firstItem - firstItemInSrcTask));
        }
        return null;
    }

    private int getItemIdOffset(int chunkId) {
        int offset = 0;
        for (int i = 0; i < this.positionInGroup; ++i) {
            this.grouperForComputeOffset.init(this.numTaskPerSrcVertexInGroup[i] * this.numPartition, this.numChunkPerSrc[this.positionInSrc]);
            offset += this.grouperForComputeOffset.getNumItemsInGroup(chunkId);
        }
        return offset;
    }

    @Override
    @Nullable
    public EdgeManagerPluginOnDemand.EventRouteMetadata routeInputSourceTaskFailedEventToDestination(int srcTaskId, int destTaskId) throws Exception {
        int chunkId = CartesianProductCombination.fromTaskId(this.numChunkPerSrc, destTaskId).getCombination().get(this.positionInSrc);
        int firstItemInChunk = this.grouper.getFirstItemInGroup(chunkId);
        int lastItemInChunk = this.grouper.getLastItemInGroup(chunkId);
        int firstItemInSrcTask = srcTaskId * this.numPartition;
        int lastItemInSrcTask = firstItemInSrcTask + this.numPartition - 1;
        if (lastItemInChunk >= firstItemInSrcTask && firstItemInChunk <= lastItemInSrcTask) {
            int firstItem = Math.max(firstItemInChunk, firstItemInSrcTask);
            int lastItem = Math.min(lastItemInChunk, lastItemInSrcTask);
            int[] targetIndices = new int[lastItem - firstItem + 1];
            for (int i = firstItem; i <= lastItem; ++i) {
                targetIndices[i - firstItem] = i - firstItemInChunk + this.getItemIdOffset(chunkId);
            }
            return EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)targetIndices.length, (int[])targetIndices);
        }
        return null;
    }

    @Override
    public int getNumDestinationTaskPhysicalInputs(int destTaskId) {
        int chunkId = CartesianProductCombination.fromTaskId(this.numChunkPerSrc, destTaskId).getCombination().get(this.positionInSrc);
        if (0 <= chunkId && chunkId < this.numChunkPerSrc[this.positionInSrc]) {
            return this.grouper.getNumItemsInGroup(chunkId);
        }
        return 0;
    }

    @Override
    public int getNumSourceTaskPhysicalOutputs(int srcTaskId) {
        return this.numPartition;
    }

    @Override
    public int getNumDestinationConsumerTasks(int sourceTaskIndex) {
        int numChunk = this.grouper.getGroupId(sourceTaskIndex * this.numPartition + this.numPartition - 1) - this.grouper.getGroupId(sourceTaskIndex * this.numPartition) + 1;
        return this.numDestConsumerPerChunk * numChunk;
    }
}

