/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.utils;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.IFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodecUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IFile.class);
    private static final int DEFAULT_BUFFER_SIZE = 131072;

    private CodecUtils() {
    }

    public static CompressionCodec getCodec(Configuration conf) throws IOException {
        if (ConfigUtils.shouldCompressIntermediateOutput(conf)) {
            Class<? extends CompressionCodec> codecClass = ConfigUtils.getIntermediateOutputCompressorClass(conf, DefaultCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)conf);
            if (codec != null) {
                Class compressorType = null;
                RuntimeException cause = null;
                try {
                    compressorType = codec.getCompressorType();
                }
                catch (RuntimeException e) {
                    cause = e;
                }
                if (compressorType == null) {
                    String errMsg = String.format("Unable to get CompressorType for codec (%s). This is most likely due to missing native libraries for the codec.", conf.get("tez.runtime.compress.codec"));
                    throw new IOException(errMsg, cause);
                }
            }
            return codec;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getDecompressedInputStreamWithBufferSize(CompressionCodec codec, IFileInputStream checksumIn, Decompressor decompressor, int compressedLength) throws IOException {
        String bufferSizeProp = TezRuntimeUtils.getBufferSizeProperty(codec);
        Configurable configurableCodec = (Configurable)codec;
        int originalSize = configurableCodec.getConf().getInt(bufferSizeProp, 131072);
        CompressionInputStream in = null;
        if (bufferSizeProp != null) {
            Configuration conf = configurableCodec.getConf();
            int newBufSize = Math.min(compressedLength, 131072);
            LOG.trace("buffer size was set according to min(compressedLength, {}): {}={}", new Object[]{131072, bufferSizeProp, newBufSize});
            CompressionCodec compressionCodec = codec;
            synchronized (compressionCodec) {
                conf.setInt(bufferSizeProp, newBufSize);
                in = codec.createInputStream((InputStream)checksumIn, decompressor);
                configurableCodec.getConf().setInt(bufferSizeProp, originalSize);
            }
        } else {
            in = codec.createInputStream((InputStream)checksumIn, decompressor);
        }
        return in;
    }
}

